/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.transform;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.sis.referencing.internal.Resources;
import org.apache.sis.referencing.operation.matrix.Matrices;
import org.apache.sis.referencing.operation.provider.Affine;
import org.apache.sis.referencing.operation.transform.AbstractMathTransform;
import org.apache.sis.referencing.operation.transform.IterationStrategy;
import org.apache.sis.referencing.operation.transform.LinearTransform;
import org.apache.sis.referencing.operation.transform.MathTransforms;
import org.apache.sis.util.ComparisonMode;
import org.apache.sis.util.resources.Errors;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.referencing.operation.Matrix;
import org.opengis.referencing.operation.NoninvertibleTransformException;
import org.opengis.util.FactoryException;

abstract class AbstractLinearTransform
extends AbstractMathTransform
implements LinearTransform,
Matrix,
Serializable {
    private static final long serialVersionUID = -4649708313541868599L;
    volatile LinearTransform inverse;

    AbstractLinearTransform() {
    }

    static Number[] wrap(double[] elements) {
        Number[] numbers = new Number[elements.length];
        for (int i = 0; i < elements.length; ++i) {
            double element = elements[i];
            if (element == 0.0) continue;
            int ie = (int)element;
            numbers[i] = (double)ie == element ? (double)Integer.valueOf(ie).intValue() : Double.valueOf(element);
        }
        return numbers;
    }

    @Override
    public boolean isAffine() {
        return Matrices.isAffine(this);
    }

    @Override
    public final Matrix clone() {
        return Matrices.copy(this);
    }

    @Override
    public final Matrix getMatrix() {
        return this;
    }

    @Override
    public int getNumRow() {
        return this.getTargetDimensions() + 1;
    }

    @Override
    public int getNumCol() {
        return this.getSourceDimensions() + 1;
    }

    @Override
    protected final MathTransform tryConcatenate(boolean applyOtherFirst, MathTransform other, MathTransformFactory factory) throws FactoryException {
        if (other instanceof LinearTransform) {
            return super.tryConcatenate(applyOtherFirst, other, factory);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LinearTransform inverse() throws NoninvertibleTransformException {
        LinearTransform inv = this.inverse;
        if (inv == null) {
            AbstractLinearTransform abstractLinearTransform = this;
            synchronized (abstractLinearTransform) {
                inv = this.inverse;
                if (inv == null) {
                    this.inverse = inv = this.createInverse();
                }
            }
        }
        return inv;
    }

    LinearTransform createInverse() throws NoninvertibleTransformException {
        if (this.isIdentity()) {
            return this;
        }
        LinearTransform inv = MathTransforms.linear(Matrices.inverse(this));
        if (inv instanceof AbstractLinearTransform) {
            ((AbstractLinearTransform)inv).inverse = this;
        }
        return inv;
    }

    @Override
    public ParameterDescriptorGroup getParameterDescriptors() {
        return Affine.provider(this.getSourceDimensions(), this.getTargetDimensions(), this.isAffine()).getParameters();
    }

    @Override
    public ParameterValueGroup getParameterValues() {
        return Affine.parameters(this);
    }

    @Override
    public final void setElement(int row, int column, double value) {
        throw new UnsupportedOperationException(this.isAffine() ? Resources.format((short)68) : Errors.format((short)153, AbstractLinearTransform.class));
    }

    @Override
    public void deltaTransform(double[] srcPts, int srcOff, double[] dstPts, int dstOff, int numPts) {
        int dstDim;
        int srcDim;
        int offFinal = 0;
        double[] dstFinal = null;
        int srcInc = srcDim = this.getSourceDimensions();
        int dstInc = dstDim = this.getTargetDimensions();
        if (srcPts == dstPts) {
            switch (IterationStrategy.suggest(srcOff, srcDim, dstOff, dstDim, numPts)) {
                case ASCENDING: {
                    break;
                }
                case DESCENDING: {
                    srcOff += (numPts - 1) * srcDim;
                    srcInc = -srcInc;
                    dstOff += (numPts - 1) * dstDim;
                    dstInc = -dstInc;
                    break;
                }
                default: {
                    srcPts = Arrays.copyOfRange(srcPts, srcOff, srcOff + numPts * srcDim);
                    srcOff = 0;
                    break;
                }
                case BUFFER_TARGET: {
                    dstFinal = dstPts;
                    dstPts = new double[numPts * dstInc];
                    offFinal = dstOff;
                    dstOff = 0;
                }
            }
        }
        double[] buffer = new double[dstDim];
        while (--numPts >= 0) {
            for (int j = 0; j < dstDim; ++j) {
                double sum = 0.0;
                for (int i = 0; i < srcDim; ++i) {
                    double e = this.getElement(j, i);
                    if (e == 0.0) continue;
                    sum += srcPts[srcOff + i] * e;
                }
                buffer[j] = sum;
            }
            System.arraycopy(buffer, 0, dstPts, dstOff, dstDim);
            srcOff += srcInc;
            dstOff += dstInc;
        }
        if (dstFinal != null) {
            System.arraycopy(dstPts, 0, dstFinal, offFinal, dstPts.length);
        }
    }

    protected abstract boolean equalsSameClass(Object var1);

    @Override
    public final boolean equals(Object object, ComparisonMode mode) {
        if (object == this) {
            return true;
        }
        if (object == null) {
            return false;
        }
        boolean isApproximate = mode.isApproximate();
        if (!isApproximate && this.getClass() == object.getClass()) {
            if (!this.equalsSameClass(object)) {
                return false;
            }
        } else {
            Matrix m;
            if (mode == ComparisonMode.STRICT) {
                return false;
            }
            if (object instanceof LinearTransform) {
                m = ((LinearTransform)object).getMatrix();
            } else if (object instanceof Matrix) {
                m = (Matrix)object;
            } else {
                return false;
            }
            if (!Matrices.equals(this, m, mode)) {
                return false;
            }
        }
        if (object instanceof AbstractLinearTransform && this.inverse == ((AbstractLinearTransform)object).inverse) {
            return true;
        }
        Matrix mt = null;
        Matrix mo = null;
        try {
            mt = this.inverse().getMatrix();
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        try {
            if (object instanceof LinearTransform) {
                mo = ((LinearTransform)object).inverse().getMatrix();
            } else if (object instanceof Matrix) {
                mo = Matrices.inverse((Matrix)object);
            }
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
        return Matrices.equals(mt, mo, isApproximate ? 1.0E-13 : 0.0, isApproximate);
    }

    @Override
    public String toString() {
        return Matrices.toString(this);
    }
}

