/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.storage.handler.impl;

import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import org.apache.uniffle.storage.api.FileWriter;
import org.apache.uniffle.storage.common.FileBasedShuffleSegment;

public class LocalFileWriter
implements FileWriter,
Closeable {
    private DataOutputStream dataOutputStream;
    private FileOutputStream fileOutputStream;
    private long nextOffset;

    public LocalFileWriter(File file) throws IOException {
        this.fileOutputStream = new FileOutputStream(file, true);
        this.dataOutputStream = new DataOutputStream(new BufferedOutputStream(this.fileOutputStream));
        this.nextOffset = file.length();
    }

    @Override
    public void writeData(byte[] data) throws IOException {
        if (data != null && data.length > 0) {
            this.dataOutputStream.write(data);
            this.nextOffset += (long)data.length;
        }
    }

    @Override
    public void writeIndex(FileBasedShuffleSegment segment) throws IOException {
        this.dataOutputStream.writeLong(segment.getOffset());
        this.dataOutputStream.writeInt(segment.getLength());
        this.dataOutputStream.writeInt(segment.getUncompressLength());
        this.dataOutputStream.writeLong(segment.getCrc());
        this.dataOutputStream.writeLong(segment.getBlockId());
        this.dataOutputStream.writeLong(segment.getTaskAttemptId());
    }

    public long nextOffset() {
        return this.nextOffset;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.dataOutputStream != null) {
            this.dataOutputStream.close();
        }
    }
}

