/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.lang3.JavaVersion;
import org.apache.commons.lang3.SystemUtils;
import org.apache.uniffle.shaded.com.google.common.base.Enums;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JavaUtils {
    private static final Logger logger = LoggerFactory.getLogger(JavaUtils.class);
    private static final String JAVA_9 = "JAVA_9";

    public static boolean isJavaVersionAtLeastJava9() {
        return Enums.getIfPresent(JavaVersion.class, JAVA_9).isPresent() && SystemUtils.isJavaVersionAtLeast((JavaVersion)JavaVersion.JAVA_9);
    }

    public static void closeQuietly(Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException e) {
            logger.error("IOException should not have been thrown.", (Throwable)e);
        }
    }

    public static <K, V> ConcurrentHashMap<K, V> newConcurrentMap() {
        if (JavaUtils.isJavaVersionAtLeastJava9()) {
            return new ConcurrentHashMap();
        }
        return new ConcurrentHashMapForJDK8();
    }

    private static class ConcurrentHashMapForJDK8<K, V>
    extends ConcurrentHashMap<K, V> {
        private ConcurrentHashMapForJDK8() {
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Object result = this.get(key);
            if (null == result) {
                result = super.computeIfAbsent(key, mappingFunction);
            }
            return result;
        }
    }
}

