/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uniffle.common.rpc;

import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.uniffle.common.config.RssBaseConf;
import org.apache.uniffle.common.metrics.GRPCMetrics;
import org.apache.uniffle.common.rpc.MonitoringServerInterceptor;
import org.apache.uniffle.common.rpc.MonitoringServerTransportFilter;
import org.apache.uniffle.common.rpc.ServerInterface;
import org.apache.uniffle.common.util.ExitUtils;
import org.apache.uniffle.common.util.RssUtils;
import org.apache.uniffle.common.util.ThreadUtils;
import org.apache.uniffle.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.uniffle.shaded.com.google.common.collect.Lists;
import org.apache.uniffle.shaded.com.google.common.collect.Queues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GrpcServer
implements ServerInterface {
    private static final Logger LOG = LoggerFactory.getLogger(GrpcServer.class);
    private static volatile boolean poolExecutorHasExecuted;
    private Server server;
    private final int port;
    private int listenPort;
    private final ExecutorService pool;
    private List<Pair<BindableService, List<ServerInterceptor>>> servicesWithInterceptors;
    private GRPCMetrics grpcMetrics;
    private RssBaseConf rssConf;

    protected GrpcServer(RssBaseConf conf, List<Pair<BindableService, List<ServerInterceptor>>> servicesWithInterceptors, GRPCMetrics grpcMetrics) {
        this.rssConf = conf;
        this.port = this.rssConf.getInteger(RssBaseConf.RPC_SERVER_PORT);
        this.servicesWithInterceptors = servicesWithInterceptors;
        this.grpcMetrics = grpcMetrics;
        int rpcExecutorSize = conf.getInteger(RssBaseConf.RPC_EXECUTOR_SIZE);
        this.pool = new GrpcThreadPoolExecutor(rpcExecutorSize, rpcExecutorSize * 2, 10L, TimeUnit.MINUTES, Queues.newLinkedBlockingQueue(Integer.MAX_VALUE), ThreadUtils.getThreadFactory("Grpc"), grpcMetrics);
    }

    static boolean isPoolExecutorHasExecuted() {
        return poolExecutorHasExecuted;
    }

    static void reset() {
        poolExecutorHasExecuted = false;
    }

    private Server buildGrpcServer(int serverPort) {
        boolean isMetricsEnabled = this.rssConf.getBoolean(RssBaseConf.RPC_METRICS_ENABLED);
        long maxInboundMessageSize = this.rssConf.getLong(RssBaseConf.RPC_MESSAGE_MAX_SIZE);
        Object builder = ((ServerBuilder)ServerBuilder.forPort(serverPort).executor(this.pool)).maxInboundMessageSize((int)maxInboundMessageSize);
        if (isMetricsEnabled) {
            ((ServerBuilder)builder).addTransportFilter(new MonitoringServerTransportFilter(this.grpcMetrics));
        }
        this.servicesWithInterceptors.forEach(serviceWithInterceptors -> {
            ArrayList<MonitoringServerInterceptor> interceptors = (ArrayList<MonitoringServerInterceptor>)serviceWithInterceptors.getRight();
            if (isMetricsEnabled) {
                MonitoringServerInterceptor monitoringInterceptor = new MonitoringServerInterceptor(this.grpcMetrics);
                ArrayList<MonitoringServerInterceptor> newInterceptors = Lists.newArrayList(interceptors);
                newInterceptors.add(monitoringInterceptor);
                interceptors = newInterceptors;
            }
            builder.addService(ServerInterceptors.intercept((BindableService)serviceWithInterceptors.getLeft(), (List<? extends ServerInterceptor>)interceptors));
        });
        return ((ServerBuilder)builder).build();
    }

    @Override
    public int start() throws IOException {
        try {
            this.listenPort = RssUtils.startServiceOnPort(this, "grpc.server", this.port, this.rssConf);
        }
        catch (Exception e) {
            ExitUtils.terminate(1, "Fail to start grpc server on conf port:" + this.port, e, LOG);
        }
        return this.listenPort;
    }

    @Override
    public void startOnPort(int startPort) throws Exception {
        this.server = this.buildGrpcServer(startPort);
        this.server.start();
        this.listenPort = this.server.getPort();
        LOG.info("Grpc server started, configured port: {}, listening on {}.", (Object)this.port, (Object)this.listenPort);
    }

    @Override
    public void stop() throws InterruptedException {
        if (this.server != null) {
            this.server.shutdown().awaitTermination(10L, TimeUnit.SECONDS);
            LOG.info("GRPC server stopped!");
        }
        if (this.pool != null) {
            this.pool.shutdown();
        }
    }

    @Override
    public void blockUntilShutdown() throws InterruptedException {
        if (this.server != null) {
            this.server.awaitTermination();
        }
    }

    public int getPort() {
        return this.listenPort;
    }

    public static class GrpcThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final GRPCMetrics grpcMetrics;
        private final AtomicLong activeThreadSize = new AtomicLong(0L);

        public GrpcThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, GRPCMetrics grpcMetrics) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
            this.grpcMetrics = grpcMetrics;
        }

        @Override
        protected void beforeExecute(Thread t, Runnable r) {
            this.grpcMetrics.incGauge("grpcServerExecutorActiveThreads");
            this.grpcMetrics.setGauge("grpcServerExecutorBlockingQueueSize", this.getQueue().size());
            poolExecutorHasExecuted = true;
            super.beforeExecute(t, r);
        }

        @Override
        protected void afterExecute(Runnable r, Throwable t) {
            this.grpcMetrics.decGauge("grpcServerExecutorActiveThreads");
            this.grpcMetrics.setGauge("grpcServerExecutorBlockingQueueSize", this.getQueue().size());
            super.afterExecute(r, t);
        }

        @VisibleForTesting
        void correctMetrics() {
            this.grpcMetrics.setGauge("grpcServerExecutorBlockingQueueSize", this.getQueue().size());
        }
    }

    public static class Builder {
        private RssBaseConf rssBaseConf;
        private GRPCMetrics grpcMetrics;
        private List<Pair<BindableService, List<ServerInterceptor>>> servicesWithInterceptors = new ArrayList<Pair<BindableService, List<ServerInterceptor>>>();

        public static Builder newBuilder() {
            return new Builder();
        }

        public Builder conf(RssBaseConf rssBaseConf) {
            this.rssBaseConf = rssBaseConf;
            return this;
        }

        public Builder addService(BindableService bindableService, ServerInterceptor ... interceptors) {
            this.servicesWithInterceptors.add((Pair<BindableService, List<ServerInterceptor>>)Pair.of((Object)bindableService, Lists.newArrayList(interceptors)));
            return this;
        }

        public Builder grpcMetrics(GRPCMetrics metrics) {
            this.grpcMetrics = metrics;
            return this;
        }

        public GrpcServer build() {
            return new GrpcServer(this.rssBaseConf, this.servicesWithInterceptors, this.grpcMetrics);
        }
    }
}

