/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.common.requests;

import java.nio.ByteBuffer;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.protocol.types.Struct;
import org.apache.kafka.common.requests.AbstractResponse;

public class AddOffsetsToTxnResponse
extends AbstractResponse {
    private static final String ERROR_CODE_KEY_NAME = "error_code";
    private final Errors error;
    private final int throttleTimeMs;

    public AddOffsetsToTxnResponse(int throttleTimeMs, Errors error) {
        this.throttleTimeMs = throttleTimeMs;
        this.error = error;
    }

    public AddOffsetsToTxnResponse(Struct struct) {
        this.throttleTimeMs = struct.getInt("throttle_time_ms");
        this.error = Errors.forCode(struct.getShort(ERROR_CODE_KEY_NAME));
    }

    public int throttleTimeMs() {
        return this.throttleTimeMs;
    }

    public Errors error() {
        return this.error;
    }

    @Override
    protected Struct toStruct(short version) {
        Struct struct = new Struct(ApiKeys.ADD_OFFSETS_TO_TXN.responseSchema(version));
        struct.set("throttle_time_ms", (Object)this.throttleTimeMs);
        struct.set(ERROR_CODE_KEY_NAME, (Object)this.error.code());
        return struct;
    }

    public static AddOffsetsToTxnResponse parse(ByteBuffer buffer, short version) {
        return new AddOffsetsToTxnResponse(ApiKeys.ADD_OFFSETS_TO_TXN.parseResponse(version, buffer));
    }

    public String toString() {
        return "AddOffsetsToTxnResponse(error=" + (Object)((Object)this.error) + ", throttleTimeMs=" + this.throttleTimeMs + ')';
    }
}

