/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

This filter computes the Laplacian of a scalar-valued image.


The Laplacian is an isotropic measure of the 2nd spatial derivative of
an image. The Laplacian of an image highlights regions of rapid
intensity change and is therefore often used for edge detection.
Often, the Laplacian is applied to an image that has first been
smoothed with a Gaussian filter in order to reduce its sensitivity to
noise.


The Laplacian at each pixel location is computed by convolution with
the itk::LaplacianOperator .
Inputs and Outputs
The input to this filter is a scalar-valued itk::Image of arbitrary dimension. The output is a scalar-valued itk::Image .

WARNING:
The pixel type of the input and output images must be of real type
(float or double). ConceptChecking is used here to enforce the input
pixel type. You will get a compilation error if the pixel type of the
input and output images is not float or double.

See:
 Image

 Neighborhood

 NeighborhoodOperator

 NeighborhoodIterator

 LaplacianOperator

 itk::simple::Laplacian for the procedural interface

 itk::LaplacianImageFilter for the Doxygen on the original ITK class.


C++ includes: sitkLaplacianImageFilter.h
*/
public class LaplacianImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LaplacianImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LaplacianImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LaplacianImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LaplacianImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LaplacianImageFilter::~LaplacianImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LaplacianImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LaplacianImageFilter::LaplacianImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LaplacianImageFilter() {
    this(SimpleITKJNI.new_LaplacianImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LaplacianImageFilter::SetUseImageSpacing(bool UseImageSpacing)

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public  void setUseImageSpacing(boolean UseImageSpacing) {
    SimpleITKJNI.LaplacianImageFilter_setUseImageSpacing(swigCPtr, this, UseImageSpacing);
  }

  /**
Self&amp; itk::simple::LaplacianImageFilter::UseImageSpacingOn()

Set the value of UseImageSpacing to true or false respectfully.

*/
public  void useImageSpacingOn() {
    SimpleITKJNI.LaplacianImageFilter_useImageSpacingOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LaplacianImageFilter::UseImageSpacingOff()
*/
public  void useImageSpacingOff() {
    SimpleITKJNI.LaplacianImageFilter_useImageSpacingOff(swigCPtr, this);
  }

  /**
bool itk::simple::LaplacianImageFilter::GetUseImageSpacing() const

Set/Get whether or not the filter will use the spacing of the input
image in its calculations

*/
public  boolean getUseImageSpacing() {
    return SimpleITKJNI.LaplacianImageFilter_getUseImageSpacing(swigCPtr, this);
  }

  /**
std::string itk::simple::LaplacianImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LaplacianImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LaplacianImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LaplacianImageFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::LaplacianImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  Image execute(Image image1) {
    return new Image(SimpleITKJNI.LaplacianImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1), true);
  }

}
