/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Generate a displacement field from a coordinate transform.


Output information (spacing, size and direction) for the output image
should be set. This information has the normal defaults of unit
spacing, zero origin and identity direction. Optionally, the output
information can be obtained from a reference image. If the reference
image is provided and UseReferenceImage is On, then the spacing,
origin and direction of the reference image will be used.

Since this filter produces an image which is a different size than its
input, it needs to override several of the methods defined in ProcessObject in order to properly manage the pipeline execution model. In
particular, this filter overrides ProcessObject::GenerateOutputInformation() .

This filter is implemented as a multithreaded filter. It provides a
ThreadedGenerateData() method for its implementation.


Marius Staring, Leiden University Medical Center, The Netherlands.
 This class was taken from the Insight Journal paper: https://doi.org/10.54294/4ids6q
See:
 itk::simple::TransformToDisplacementFieldFilter for the procedural interface

 itk::TransformToDisplacementFieldFilter for the Doxygen on the original ITK class.


C++ includes: sitkTransformToDisplacementFieldFilter.h
*/
public class TransformToDisplacementFieldFilter extends ImageFilter {
  private transient long swigCPtr;

  protected TransformToDisplacementFieldFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.TransformToDisplacementFieldFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(TransformToDisplacementFieldFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(TransformToDisplacementFieldFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::TransformToDisplacementFieldFilter::~TransformToDisplacementFieldFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_TransformToDisplacementFieldFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::TransformToDisplacementFieldFilter::TransformToDisplacementFieldFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  TransformToDisplacementFieldFilter() {
    this(SimpleITKJNI.new_TransformToDisplacementFieldFilter(), true);
  }

  /**
Self&amp; itk::simple::TransformToDisplacementFieldFilter::SetOutputPixelType(PixelIDValueEnum OutputPixelType)

Set the output pixel type, only sitkVectorFloat32 and
sitkVectorFloat64 are supported.

*/
public  void setOutputPixelType(PixelIDValueEnum OutputPixelType) {
    SimpleITKJNI.TransformToDisplacementFieldFilter_setOutputPixelType(swigCPtr, this, OutputPixelType.swigValue());
  }

  /**
PixelIDValueEnum itk::simple::TransformToDisplacementFieldFilter::GetOutputPixelType() const

Get the ouput pixel type.

*/
public  PixelIDValueEnum getOutputPixelType() {
    return PixelIDValueEnum.swigToEnum(SimpleITKJNI.TransformToDisplacementFieldFilter_getOutputPixelType(swigCPtr, this));
  }

  /**
Self&amp; itk::simple::TransformToDisplacementFieldFilter::SetSize(std::vector&lt; unsigned int &gt; Size)

Set/Get the size of the output image.

*/
public  void setSize(VectorUInt32 Size) {
    SimpleITKJNI.TransformToDisplacementFieldFilter_setSize(swigCPtr, this, VectorUInt32.getCPtr(Size), Size);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::TransformToDisplacementFieldFilter::GetSize() const

Set/Get the size of the output image.

*/
public  VectorUInt32 getSize() {
    return new VectorUInt32(SimpleITKJNI.TransformToDisplacementFieldFilter_getSize(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::TransformToDisplacementFieldFilter::SetOutputOrigin(std::vector&lt; double &gt; OutputOrigin)

Set the output image origin.

*/
public  void setOutputOrigin(VectorDouble OutputOrigin) {
    SimpleITKJNI.TransformToDisplacementFieldFilter_setOutputOrigin(swigCPtr, this, VectorDouble.getCPtr(OutputOrigin), OutputOrigin);
  }

  /**
std::vector&lt;double&gt; itk::simple::TransformToDisplacementFieldFilter::GetOutputOrigin() const

Get the output image origin.

*/
public  VectorDouble getOutputOrigin() {
    return new VectorDouble(SimpleITKJNI.TransformToDisplacementFieldFilter_getOutputOrigin(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::TransformToDisplacementFieldFilter::SetOutputSpacing(std::vector&lt; double &gt; OutputSpacing)

Set the output image spacing.

*/
public  void setOutputSpacing(VectorDouble OutputSpacing) {
    SimpleITKJNI.TransformToDisplacementFieldFilter_setOutputSpacing(swigCPtr, this, VectorDouble.getCPtr(OutputSpacing), OutputSpacing);
  }

  /**
std::vector&lt;double&gt; itk::simple::TransformToDisplacementFieldFilter::GetOutputSpacing() const

Get the output image spacing.

*/
public  VectorDouble getOutputSpacing() {
    return new VectorDouble(SimpleITKJNI.TransformToDisplacementFieldFilter_getOutputSpacing(swigCPtr, this), true);
  }

  /**
Self&amp; itk::simple::TransformToDisplacementFieldFilter::SetOutputDirection(std::vector&lt; double &gt; OutputDirection)

Set the output direction cosine matrix.

*/
public  void setOutputDirection(VectorDouble OutputDirection) {
    SimpleITKJNI.TransformToDisplacementFieldFilter_setOutputDirection(swigCPtr, this, VectorDouble.getCPtr(OutputDirection), OutputDirection);
  }

  /**
std::vector&lt;double&gt; itk::simple::TransformToDisplacementFieldFilter::GetOutputDirection() const

Set the output direction cosine matrix.

*/
public  VectorDouble getOutputDirection() {
    return new VectorDouble(SimpleITKJNI.TransformToDisplacementFieldFilter_getOutputDirection(swigCPtr, this), true);
  }

  /**
std::string itk::simple::TransformToDisplacementFieldFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.TransformToDisplacementFieldFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::TransformToDisplacementFieldFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.TransformToDisplacementFieldFilter_toString(swigCPtr, this);
  }

  /**
Image itk::simple::TransformToDisplacementFieldFilter::Execute(const Transform &amp;transform)

Execute the filter on the input image

*/
public  Image execute(Transform transform) {
    return new Image(SimpleITKJNI.TransformToDisplacementFieldFilter_execute(swigCPtr, this, Transform.getCPtr(transform), transform), true);
  }

  /**
void itk::simple::TransformToDisplacementFieldFilter::SetReferenceImage(const Image &amp;refImage)

This methods sets the size, origin, spacing and direction to that of
the provided image

*/
public  void setReferenceImage(Image refImage) {
    SimpleITKJNI.TransformToDisplacementFieldFilter_setReferenceImage(swigCPtr, this, Image.getCPtr(refImage), refImage);
  }

}
