/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.openapidiff.core.model.deferred;

import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.openapitools.openapidiff.core.model.Changed;
import org.openapitools.openapidiff.core.model.ComposedChanged;
import org.openapitools.openapidiff.core.model.deferred.DeferredChanged;

public class DeferredLogger {
    private DeferredLogger() {
    }

    public static Object logValue(final Object value) {
        return new Object(){

            public String toString() {
                return DeferredLogger.valueToString(value);
            }
        };
    }

    public static String optionalToString(Optional<?> value) {
        return value.map(v -> "Optional[" + DeferredLogger.valueToString(v) + "]").orElse("Optional[empty]");
    }

    public static String changedToString(Changed value) {
        if (value instanceof ComposedChanged) {
            return "Changed: " + value.getClass() + " (composed) ";
        }
        return "Changed: " + value.getClass() + " " + (Object)((Object)value.isChanged());
    }

    public static String streamToString(Stream<?> values) {
        return "[" + values.map(DeferredLogger::valueToString).collect(Collectors.joining(", ")) + "]";
    }

    public static String deferredChangeToString(DeferredChanged<?> deferredChanged) {
        if (deferredChanged.isValueSet()) {
            if (deferredChanged.isPresent()) {
                Object value = deferredChanged.get();
                return DeferredLogger.valueToString(value);
            }
            return deferredChanged.toString();
        }
        return deferredChanged.toString();
    }

    public static String valueToString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof Changed) {
            return DeferredLogger.changedToString((Changed)value);
        }
        if (value instanceof Optional) {
            return DeferredLogger.optionalToString((Optional)value);
        }
        if (value instanceof DeferredChanged) {
            return DeferredLogger.deferredChangeToString((DeferredChanged)value);
        }
        if (value.getClass().isArray()) {
            return DeferredLogger.streamToString(Arrays.stream((Object[])value));
        }
        if (value instanceof Collection) {
            return DeferredLogger.streamToString(((Collection)value).stream());
        }
        return value.toString();
    }
}

