function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React, { Fragment } from 'react';
import PropTypes from "prop-types";
import classNames from 'classnames';
import { OuiI18n } from '../i18n';
import { OuiInnerText } from '../inner_text';
import { keysOf } from '../common';
import { isNil } from '../../services/predicate';
var sizeToClassNameMap = {
  xs: 'ouiProgress--xs',
  s: 'ouiProgress--s',
  m: 'ouiProgress--m',
  l: 'ouiProgress--l'
};
export var SIZES = keysOf(sizeToClassNameMap);
var colorToClassNameMap = {
  primary: 'ouiProgress--primary',
  secondary: 'ouiProgress--secondary',
  success: 'ouiProgress--success',
  warning: 'ouiProgress--warning',
  danger: 'ouiProgress--danger',
  subdued: 'ouiProgress--subdued',
  accent: 'ouiProgress--accent',
  vis0: 'ouiProgress--vis0',
  vis1: 'ouiProgress--vis1',
  vis2: 'ouiProgress--vis2',
  vis3: 'ouiProgress--vis3',
  vis4: 'ouiProgress--vis4',
  vis5: 'ouiProgress--vis5',
  vis6: 'ouiProgress--vis6',
  vis7: 'ouiProgress--vis7',
  vis8: 'ouiProgress--vis8',
  vis9: 'ouiProgress--vis9'
};
export var COLORS = keysOf(colorToClassNameMap);
function isNamedColor(name) {
  return colorToClassNameMap.hasOwnProperty(name);
}
var dataColorToClassNameMap = {
  primary: 'ouiProgress__data--primary',
  secondary: 'ouiProgress__data--secondary',
  success: 'ouiProgress__data--success',
  warning: 'ouiProgress__data--warning',
  danger: 'ouiProgress__data--danger',
  subdued: 'ouiProgress__data--subdued',
  accent: 'ouiProgress__data--accent',
  vis0: 'ouiProgress__data--vis0',
  vis1: 'ouiProgress__data--vis1',
  vis2: 'ouiProgress__data--vis2',
  vis3: 'ouiProgress__data--vis3',
  vis4: 'ouiProgress__data--vis4',
  vis5: 'ouiProgress__data--vis5',
  vis6: 'ouiProgress__data--vis6',
  vis7: 'ouiProgress__data--vis7',
  vis8: 'ouiProgress__data--vis8',
  vis9: 'ouiProgress__data--vis9'
};
var positionsToClassNameMap = {
  fixed: 'ouiProgress--fixed',
  absolute: 'ouiProgress--absolute',
  static: ''
};
export var POSITIONS = keysOf(positionsToClassNameMap);
export var OuiProgress = function OuiProgress(_ref) {
  var className = _ref.className,
    _ref$color = _ref.color,
    color = _ref$color === void 0 ? 'success' : _ref$color,
    _ref$size = _ref.size,
    size = _ref$size === void 0 ? 'm' : _ref$size,
    _ref$position = _ref.position,
    position = _ref$position === void 0 ? 'static' : _ref$position,
    max = _ref.max,
    _ref$valueText = _ref.valueText,
    valueText = _ref$valueText === void 0 ? false : _ref$valueText,
    label = _ref.label,
    value = _ref.value,
    labelProps = _ref.labelProps,
    rest = _objectWithoutProperties(_ref, ["className", "color", "size", "position", "max", "valueText", "label", "value", "labelProps"]);
  var determinate = !isNil(max);
  var colorClass = null;
  var dataColorClass = null;
  var optionalCustomStyles = null;
  if (color) {
    if (isNamedColor(color)) {
      colorClass = colorToClassNameMap[color];
      dataColorClass = dataColorToClassNameMap[color];
    } else {
      optionalCustomStyles = {
        color: color
      };
      colorClass = 'ouiProgress--customColor';
    }
  }
  var classes = classNames('ouiProgress', {
    'ouiProgress--indeterminate': !determinate,
    'ouiProgress--native': determinate
  }, sizeToClassNameMap[size], colorClass, positionsToClassNameMap[position], className);
  var dataClasses = classNames('ouiProgress__data', {
    'ouiProgress__data--l': size === 'l'
  }, dataColorClass);
  var labelClasses = classNames('ouiProgress__label', labelProps && labelProps.className);
  var valueRender;
  if (valueText === true) {
    // valueText is true
    valueRender = /*#__PURE__*/React.createElement(OuiI18n, {
      token: "ouiProgress.valueText",
      default: "{value}%",
      values: {
        value: value
      }
    });
  } else if (valueText) {
    // valueText exists
    valueRender = valueText;
  }

  // Because of a Firefox animation issue, indeterminate progress needs to not use <progress />.
  // See https://css-tricks.com/html5-progress-element/

  if (determinate) {
    return /*#__PURE__*/React.createElement(Fragment, null, label || valueText ? /*#__PURE__*/React.createElement("div", {
      className: dataClasses
    }, label && /*#__PURE__*/React.createElement(OuiInnerText, null, function (ref, innerText) {
      return /*#__PURE__*/React.createElement("span", _extends({
        title: innerText,
        ref: ref
      }, labelProps, {
        className: labelClasses
      }), label);
    }), valueRender && /*#__PURE__*/React.createElement(OuiInnerText, null, function (ref, innerText) {
      return /*#__PURE__*/React.createElement("span", {
        title: innerText,
        ref: ref,
        style: optionalCustomStyles,
        className: "ouiProgress__valueText"
      }, valueRender);
    })) : undefined, /*#__PURE__*/React.createElement("progress", _extends({
      className: classes,
      style: optionalCustomStyles,
      max: max,
      value: value,
      "aria-hidden": label && valueText ? true : false
    }, rest)));
  } else {
    return /*#__PURE__*/React.createElement("div", _extends({
      style: optionalCustomStyles,
      className: classes
    }, rest));
  }
};

/* OUI -> EUI Aliases: Build-Time */
OuiProgress.propTypes = {
  className: PropTypes.string,
  "aria-label": PropTypes.string,
  "data-test-subj": PropTypes.string,
  size: PropTypes.oneOf(["xs", "s", "m", "l"]),
  /**
     * One of OUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
     * **`secondary` color is DEPRECATED, use `success` instead**
     */
  /**
     * One of OUI's color palette, vis colors or a valid CSS color value https://developer.mozilla.org/en-US/docs/Web/CSS/color_value
     * **`secondary` color is DEPRECATED, use `success` instead**
     */
  color: PropTypes.oneOfType([PropTypes.oneOf(["primary", "secondary", "success", "warning", "danger", "subdued", "accent", "vis0", "vis1", "vis2", "vis3", "vis4", "vis5", "vis6", "vis7", "vis8", "vis9"]).isRequired, PropTypes.any.isRequired]),
  position: PropTypes.oneOf(["fixed", "absolute", "static"]),
  max: PropTypes.number,
  /*
       * If true, will render the percentage, otherwise pass a custom node
       */
  valueText: PropTypes.oneOfType([PropTypes.bool.isRequired, PropTypes.node.isRequired]),
  label: PropTypes.node,
  /**
       * Object of props passed to the <span/> wrapping the determinate progress's label
       */
  labelProps: PropTypes.any
};
/* OUI -> EUI Aliases: Build-Time */export { EuiProgress } from '../../eui_components/progress/progress';