/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum LockState {
    COMPLIANCE("compliance"),
    GOVERNANCE("governance"),
    COMPLIANCE_COOLOFF("compliance-cooloff"),
    EXPIRED("expired"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, LockState> VALUE_MAP;
    private final String value;

    private LockState(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static LockState fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<LockState> knownValues() {
        EnumSet<LockState> knownValues = EnumSet.allOf(LockState.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(LockState.class, LockState::toString);
    }
}

