/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.performanceanalyzer.collectors.telemetry;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.opensearch.performanceanalyzer.OpenSearchResources;
import org.opensearch.performanceanalyzer.commons.OSMetricsGeneratorFactory;
import org.opensearch.performanceanalyzer.commons.collectors.PerformanceAnalyzerMetricsCollector;
import org.opensearch.performanceanalyzer.commons.collectors.TelemetryCollector;
import org.opensearch.performanceanalyzer.commons.config.overrides.ConfigOverridesWrapper;
import org.opensearch.performanceanalyzer.commons.metrics.MetricsConfiguration;
import org.opensearch.performanceanalyzer.commons.metrics.RTFMetrics;
import org.opensearch.performanceanalyzer.commons.metrics_generator.DiskMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.metrics_generator.OSMetricsGenerator;
import org.opensearch.performanceanalyzer.commons.stats.measurements.MeasurementSet;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatExceptionCode;
import org.opensearch.performanceanalyzer.commons.stats.metrics.StatMetrics;
import org.opensearch.performanceanalyzer.config.PerformanceAnalyzerController;
import org.opensearch.telemetry.metrics.Histogram;
import org.opensearch.telemetry.metrics.MetricsRegistry;
import org.opensearch.telemetry.metrics.tags.Tags;

public class RTFDisksCollector
extends PerformanceAnalyzerMetricsCollector
implements TelemetryCollector {
    private Histogram diskWaitTimeMetrics;
    private Histogram diskServiceRateMetrics;
    private Histogram diskUtilizationMetrics;
    private MetricsRegistry metricsRegistry;
    private boolean metricsInitialised = false;
    private static final Logger LOG = LogManager.getLogger(RTFDisksCollector.class);
    private PerformanceAnalyzerController performanceAnalyzerController;
    private ConfigOverridesWrapper configOverridesWrapper;

    public RTFDisksCollector(PerformanceAnalyzerController performanceAnalyzerController, ConfigOverridesWrapper configOverridesWrapper) {
        super(((MetricsConfiguration.MetricConfig)MetricsConfiguration.CONFIG_MAP.get(RTFDisksCollector.class)).samplingInterval, "RTFDisksCollector", (MeasurementSet)StatMetrics.RTF_DISKS_COLLECTOR_EXECUTION_TIME, StatExceptionCode.RTF_DISK_METRICS_COLLECTOR_ERROR);
        this.performanceAnalyzerController = performanceAnalyzerController;
        this.configOverridesWrapper = configOverridesWrapper;
    }

    public void collectMetrics(long startTime) {
        if (this.performanceAnalyzerController.isCollectorDisabled(this.configOverridesWrapper, this.getCollectorName())) {
            LOG.info("RTFDisksCollector is disabled. Skipping collection.");
            return;
        }
        OSMetricsGenerator generator = OSMetricsGeneratorFactory.getInstance();
        if (generator == null) {
            LOG.error("could not get the instance of OSMetricsGeneratorFactory class");
            return;
        }
        this.metricsRegistry = OpenSearchResources.INSTANCE.getMetricsRegistry();
        if (this.metricsRegistry == null) {
            LOG.error("could not get the instance of MetricsRegistry class");
            return;
        }
        LOG.debug("Executing collect metrics for RTFDisksCollector");
        this.initialiseMetricsIfNeeded();
        DiskMetricsGenerator diskMetricsGenerator = generator.getDiskMetricsGenerator();
        diskMetricsGenerator.addSample();
        this.recordMetrics(diskMetricsGenerator);
    }

    public void recordMetrics(DiskMetricsGenerator diskMetricsGenerator) {
        for (String disk : diskMetricsGenerator.getAllDisks()) {
            Tags diskNameTag = Tags.create().addTag(RTFMetrics.DiskDimension.DISK_NAME.toString(), disk);
            double diskWaitTime = diskMetricsGenerator.getAwait(disk);
            double diskServiceRate = diskMetricsGenerator.getServiceRate(disk);
            double diskUtilization = diskMetricsGenerator.getDiskUtilization(disk);
            this.diskWaitTimeMetrics.record(diskWaitTime, diskNameTag);
            this.diskUtilizationMetrics.record(diskUtilization, diskNameTag);
            this.diskServiceRateMetrics.record(diskServiceRate, diskNameTag);
        }
    }

    private void initialiseMetricsIfNeeded() {
        if (!this.metricsInitialised) {
            this.diskWaitTimeMetrics = this.metricsRegistry.createHistogram("disk_wait_time", "DiskWaitTimeMetrics", RTFMetrics.MetricUnits.MILLISECOND.toString());
            this.diskServiceRateMetrics = this.metricsRegistry.createHistogram("disk_service_rate", "DiskServiceRateMetrics", RTFMetrics.MetricUnits.MEGABYTE_PER_SEC.toString());
            this.diskUtilizationMetrics = this.metricsRegistry.createHistogram("disk_utilization", "DiskUtilizationMetrics", RTFMetrics.MetricUnits.PERCENT.toString());
            this.metricsInitialised = true;
        }
    }
}

