/* Unit testing for outcomes
(C) 2013-2020 Niall Douglas <http://www.nedproductions.biz/> (2 commits)


Boost Software License - Version 1.0 - August 17th, 2003

Permission is hereby granted, free of charge, to any person or organization
obtaining a copy of the software and accompanying documentation covered by
this license (the "Software") to use, reproduce, display, distribute,
execute, and transmit the Software, and to prepare derivative works of the
Software, and to permit third-parties to whom the Software is furnished to
do so, all subject to the following:

The copyright notices in the Software and this entire statement, including
the above license grant, this restriction and the following disclaimer,
must be included in all copies of the Software, in whole or in part, and
all derivative works of the Software, unless such copies or derivative
works are solely in the form of machine-executable object code generated by
a source language processor.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
DEALINGS IN THE SOFTWARE.
*/

#include <boost/outcome/outcome.hpp>
#include <boost/test/unit_test.hpp>
#include <boost/test/unit_test_monitor.hpp>

BOOST_OUTCOME_AUTO_TEST_CASE(issues_0140_result, "Construction of non copy constructible value_type fails to not compile")
{
  namespace out = BOOST_OUTCOME_V2_NAMESPACE;

  enum op
  {
    constructed,
    moved,
    copied
  };
  struct NotCopyMoveConstructible
  {
    op v{op::constructed};
    NotCopyMoveConstructible() = default;
    NotCopyMoveConstructible(const NotCopyMoveConstructible &o) = delete;
    NotCopyMoveConstructible(NotCopyMoveConstructible &&) = delete;
    NotCopyMoveConstructible &operator=(const NotCopyMoveConstructible &) = delete;
    NotCopyMoveConstructible &operator=(NotCopyMoveConstructible &&) = delete;
    ~NotCopyMoveConstructible() = default;
  };
  struct NotMoveConstructible
  {
    op v{op::constructed};
    NotMoveConstructible() = default;
    NotMoveConstructible(const NotMoveConstructible & /*unused*/)
        : v(op::copied)
    {
    }
    NotMoveConstructible(NotMoveConstructible &&) = delete;
    NotMoveConstructible &operator=(const NotMoveConstructible &) = delete;
    NotMoveConstructible &operator=(NotMoveConstructible &&) = delete;
    ~NotMoveConstructible() = default;
  };
  struct NotCopyConstructible
  {
    op v{op::constructed};
    NotCopyConstructible() = default;
    NotCopyConstructible(NotCopyConstructible && /*unused*/) noexcept : v(op::moved) {}
    NotCopyConstructible(const NotCopyConstructible & /*unused*/) = delete;
    NotCopyConstructible &operator=(const NotCopyConstructible &) = delete;
    NotCopyConstructible &operator=(NotCopyConstructible &&) = delete;
    ~NotCopyConstructible() = default;
  };

  // Uncopyable and immovable items should be neither copyable nor moveable
  static_assert(!std::is_copy_constructible<out::result<NotCopyMoveConstructible>>::value, "result<NotCopyMoveConstructible> is copy constructible!");
  static_assert(!std::is_move_constructible<out::result<NotCopyMoveConstructible>>::value, "result<NotCopyMoveConstructible> is move constructible!");
  static_assert(!std::is_convertible<const NotCopyMoveConstructible &, NotCopyMoveConstructible>::value, "");
  static_assert(!std::is_convertible<NotCopyMoveConstructible &&, NotCopyMoveConstructible>::value, "");
  static_assert(!std::is_constructible<out::result<NotCopyMoveConstructible>, const NotCopyMoveConstructible &>::value, "result<NotCopyMoveConstructible> is constructible from const NotCopyMoveConstructible&!");
  static_assert(!std::is_constructible<out::result<NotCopyMoveConstructible>, NotCopyMoveConstructible &&>::value, "result<NotCopyMoveConstructible> is constructible from NotCopyMoveConstructible&&!");

  // Immovable items should fall back to copy
  static_assert(!std::is_move_constructible<NotMoveConstructible>::value, "NotMoveConstructible is move constructible!");
  static_assert(std::is_move_constructible<out::result<NotMoveConstructible>>::value, "result<NotMoveConstructible> is not move constructible!");
  static_assert(std::is_constructible<out::result<NotMoveConstructible>, const NotMoveConstructible &>::value, "result<NotMoveConstructible> is not constructible from NotMoveConstructible&&!");

  // Uncopyable items should never move (this was the bug report)
  static_assert(!std::is_copy_constructible<out::result<NotCopyConstructible>>::value, "result<NotCopyConstructible> is copy constructible!");
  static_assert(!std::is_constructible<out::result<NotCopyConstructible>, const NotCopyConstructible &>::value, "result<NotCopyConstructible> is constructible from const NotCopyConstructible&!");

  BOOST_CHECK(true);
}
