/*
 * Decompiled with CFR 0.152.
 */
package ch.randelshofer.quaqua.jaguar.filechooser;

import ch.randelshofer.quaqua.filechooser.QuaquaFileSystemView;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class OSXJaguarFileSystemView
extends QuaquaFileSystemView {
    private File volumesFolder = new File("/Volumes");
    private File networkFolder = new File("/Network");
    private static final File computer;
    private static final File systemVolume;
    private static final HashSet hiddenTopLevelNames;
    private static final HashSet hiddenDirectoryNames;

    public File getSystemVolume() {
        return systemVolume;
    }

    public File getComputer() {
        return computer;
    }

    public File getParentDirectory(File dir) {
        return this.isRoot(dir) ? null : super.getParentDirectory(dir);
    }

    public File[] getRoots() {
        ArrayList<File> roots = new ArrayList<File>();
        File[] fileArray = super.getRoots();
        if (fileArray != null) {
            roots.addAll(Arrays.asList(fileArray));
        }
        if ((fileArray = this.volumesFolder.listFiles()) != null) {
            roots.addAll(Arrays.asList(fileArray));
        }
        roots.add(this.networkFolder);
        return roots.toArray(new File[roots.size()]);
    }

    public boolean isHiddenFile(File f) {
        if (f.isHidden()) {
            return true;
        }
        String name = f.getName();
        if (name.length() == 0) {
            return false;
        }
        if (name.charAt(name.length() - 1) == '\r') {
            return true;
        }
        if (name.charAt(0) == '.') {
            return true;
        }
        if (hiddenTopLevelNames.contains(name) && (f.getParent() == null || this.isRoot(f.getParentFile()))) {
            return true;
        }
        return hiddenDirectoryNames.contains(name);
    }

    public boolean isRoot(File aFile) {
        return aFile.equals(computer) || aFile.equals(this.networkFolder) || aFile.getParentFile() != null && aFile.getParentFile().equals(this.volumesFolder);
    }

    public boolean isParent(File folder, File file) {
        if (folder == null || file == null) {
            return false;
        }
        return folder.equals(file.getParentFile());
    }

    public File getChild(File parent, String fileName) {
        return new File(parent, fileName);
    }

    public boolean isFileSystemRoot(File dir) {
        File parentFile = dir.getParentFile();
        return parentFile == null || parentFile.equals(this.volumesFolder);
    }

    public File getHomeDirectory() {
        return this.createFileObject(System.getProperty("user.home"));
    }

    public File getDefaultDirectory() {
        return this.getHomeDirectory();
    }

    static {
        systemVolume = computer = new File("/");
        hiddenTopLevelNames = new HashSet();
        hiddenDirectoryNames = new HashSet();
        String[] names = new String[]{"automount", "bin", "Cleanup At Startup", "cores", "Desktop DB", "Desktop DF", "Desktop Folder", "dev", "etc", "mach", "mach_kernel", "mach.sym", "private", "sbin", "Temporary Items", "TheVolumeSettingsFolder", "tmp", "Trash", "usr", "var", "Volumes"};
        hiddenTopLevelNames.addAll(Arrays.asList(names));
        names = new String[]{"$RECYCLE.BIN", "Thumbs.db", "desktop.ini"};
        hiddenDirectoryNames.addAll(Arrays.asList(names));
    }
}

