/*
 * Decompiled with CFR 0.152.
 */
package ihm.graphique;

import epp.OrdonnerPP;
import ihm.controle.JPanelEA;
import indice.Indice;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javalain.algorithmegenetique.ihm.composant.JCheckBoxMenuItemEA;
import javalain.math.Calcul;
import util.GuiUtils;

public class CourbeAtypique
extends JPanelEA {
    private ArrayList<OrdonnerPP> liste;
    private Indice I;
    private int nbEC = 0;
    private boolean[][] isAtypiques;
    private int indiceMin;
    private int indiceMax;
    private int indiceRunSelect;
    private int indiceRef;
    private int indiceObsSelect;
    private int largeur;
    private int hauteur;
    private int marge_haut = 20;
    private int marge_gauche = 25;
    private int marge_bas = 17;
    private int marge_droite = 25;
    private int taille_point = 3;
    private int decal_point = (this.taille_point - 1) / 2;
    private int centre_y;
    private final JCheckBoxMenuItemEA avecCumul;

    public CourbeAtypique(int l, int h) {
        this.largeur = l;
        this.hauteur = h;
        this.centre_y = this.hauteur - 1 - this.marge_bas;
        this.indiceMin = 0;
        this.indiceMax = -1;
        this.indiceRunSelect = 0;
        this.indiceObsSelect = 0;
        this.indiceRef = 0;
        this.setMinimumSize(new Dimension(this.largeur, this.hauteur));
        this.setPreferredSize(new Dimension(this.largeur, this.hauteur));
        this.avecCumul = new JCheckBoxMenuItemEA("Cumul");
        this.avecCumul.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CourbeAtypique.this.repaint();
            }
        });
        this.getMenuContextuel().addSeparator();
        this.getMenuContextuel().add(this.avecCumul);
    }

    public int getMargeGauche() {
        return this.marge_gauche;
    }

    public int getMargeDroite() {
        return this.marge_droite;
    }

    public int getMargeHaut() {
        return this.marge_haut;
    }

    public int getMargeBas() {
        return this.marge_bas;
    }

    public void raz() {
        this.indiceMin = 0;
        this.indiceMax = -1;
    }

    public void setIndiceMinimum(int i) {
    }

    public void setIndiceMaximum(int i) {
    }

    public void setIndiceRunSelect(int i) {
        this.indiceRunSelect = i;
    }

    public void setIndiceReference(int i) {
        this.indiceRef = i;
    }

    public void setIndiceObsSelect(int i) {
        this.indiceObsSelect = i;
    }

    public void setIndProjAndListeSimu(Indice i, ArrayList<OrdonnerPP> l) {
        this.I = i;
        this.liste = l;
        this.indiceMax = l.size() - 1;
        this.isAtypiques = new boolean[l.size()][i.getMatrice().nbLigne()];
    }

    public void setValeurAtypiques(int ec) {
        this.nbEC = ec;
        if (this.I != null && this.liste != null && this.nbEC != 0) {
            double[] donnees_x = new double[this.I.getMatrice().nbLigne()];
            int nbObs = this.I.getMatrice().nbLigne();
            int nbLancement = this.liste.size();
            for (int i = 0; i < nbLancement; ++i) {
                int j;
                for (j = 0; j < nbObs; ++j) {
                    donnees_x[j] = Calcul.produitScalaireVecteur(this.I.getMatrice().ligne(j), this.liste.get(i).getA());
                }
                double ecartType = Calcul.ecartType(donnees_x);
                double moyenne = Calcul.moyenne(donnees_x);
                for (j = 0; j < nbObs; ++j) {
                    this.isAtypiques[i][j] = donnees_x[j] < moyenne - ecartType * (double)this.nbEC || donnees_x[j] > moyenne + ecartType * (double)this.nbEC;
                }
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        int i;
        int i2;
        int nb_lancement = this.liste.size();
        int nb_obs = this.I.getMatrice().nbLigne();
        g.setColor(GuiUtils.blanc);
        g.fillRect(0, 0, this.largeur, this.hauteur);
        float echelleX = (float)(this.largeur - this.marge_gauche - this.marge_droite - this.taille_point) / (float)(this.indiceMax - this.indiceMin + 1);
        float echelleY = (float)(this.hauteur - this.marge_bas - this.marge_haut - this.taille_point) / (float)nb_obs;
        g.setColor(Color.GRAY);
        g.drawLine(this.marge_gauche, this.centre_y, this.largeur - 1 - this.marge_droite, this.centre_y);
        int pas = 1;
        int nb = this.indiceMax - this.indiceMin + 1;
        if (nb >= 10) {
            pas = nb >= 20 ? nb / 10 : 2;
        }
        for (i2 = this.indiceMin; i2 <= this.indiceMax; ++i2) {
            if ((i2 + 1) % pas != 0) continue;
            g.drawLine((int)((float)(i2 + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.centre_y, (int)((float)(i2 + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.centre_y + 3);
            g.drawString("" + (i2 + 1), (int)((float)(i2 + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.centre_y + 15);
        }
        g.drawLine(this.marge_gauche, this.marge_haut, this.marge_gauche, this.centre_y);
        pas = 1;
        nb = nb_obs;
        if (nb >= 10) {
            pas = nb >= 20 ? nb / 5 : 2;
        }
        for (i2 = 1; i2 <= nb_obs; ++i2) {
            if (i2 % pas != 0) continue;
            g.drawLine(this.marge_gauche - 3, (int)((float)(nb_obs - i2) * echelleY) + this.marge_haut, this.marge_gauche, (int)((float)(nb_obs - i2) * echelleY) + this.marge_haut);
            g.drawString("" + i2, this.marge_gauche - 25, (int)((float)(nb_obs - i2) * echelleY) + this.marge_haut);
        }
        g.setColor(Color.BLUE);
        g.setFont(GuiUtils.FONT_PARAMETRE);
        g.drawLine((int)((float)(this.indiceRunSelect + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.marge_haut, (int)((float)(this.indiceRunSelect + 1 - this.indiceMin) * echelleX) + this.marge_gauche, this.centre_y);
        g.drawString("" + (this.indiceRunSelect + 1), (int)((float)(this.indiceRunSelect + 1 - this.indiceMin) * echelleX) + this.marge_gauche + 4, this.centre_y + 10);
        g.drawLine(this.marge_gauche, (int)((float)(nb_obs - this.indiceObsSelect - 1) * echelleY) + this.marge_haut, this.largeur - 1 - this.marge_droite, (int)((float)(nb_obs - this.indiceObsSelect - 1) * echelleY) + this.marge_haut);
        g.drawString("" + (this.indiceObsSelect + 1), 0, (int)((float)(nb_obs - this.indiceObsSelect) * echelleY) + this.marge_haut);
        int[] nbAtypParRun = new int[nb_lancement];
        int[] nbAtypParObs = new int[nb_obs];
        g.setColor(Color.BLACK);
        for (int i3 = 0; i3 < nb_lancement; ++i3) {
            for (int j = 0; j < nb_obs; ++j) {
                if (!this.isAtypiques[i3][j]) continue;
                int n = i3;
                nbAtypParRun[n] = nbAtypParRun[n] + 1;
                int n2 = j;
                nbAtypParObs[n2] = nbAtypParObs[n2] + 1;
                if (this.avecCumul.isSelected() && i3 <= this.indiceRunSelect) {
                    g.fillRect((int)((float)nbAtypParObs[j] * echelleX) + this.marge_gauche - this.decal_point, (int)((float)(nb_obs - j - 1) * echelleY) + this.marge_haut - this.decal_point, this.taille_point, this.taille_point);
                    continue;
                }
                g.fillRect((int)((float)(i3 + 1) * echelleX) + this.marge_gauche - this.decal_point, (int)((float)(nb_obs - j - 1) * echelleY) + this.marge_haut - this.decal_point, this.taille_point, this.taille_point);
            }
        }
        if (this.indiceMin <= this.indiceRef && this.indiceRef <= this.indiceMax) {
            g.setColor(Color.RED);
            g.fillOval((int)((float)(this.indiceRef + 1 - this.indiceMin) * echelleX) + this.marge_gauche - 4, this.marge_haut - 4, 8, 8);
        }
        g.setColor(Color.YELLOW);
        int cpt = 0;
        for (i = 0; i < nb_lancement; ++i) {
            if (!this.isAtypiques[i][this.indiceObsSelect]) continue;
            ++cpt;
            if (this.avecCumul.isSelected() && i <= this.indiceRunSelect) {
                g.fillRect((int)((float)cpt * echelleX) + this.marge_gauche - this.decal_point, (int)((float)(nb_obs - this.indiceObsSelect - 1) * echelleY) + this.marge_haut - this.decal_point, this.taille_point, this.taille_point);
                continue;
            }
            g.fillRect((int)((float)(i + 1) * echelleX) + this.marge_gauche - this.decal_point, (int)((float)(nb_obs - this.indiceObsSelect - 1) * echelleY) + this.marge_haut - this.decal_point, this.taille_point, this.taille_point);
        }
        for (i = 0; i < nb_obs; ++i) {
            if (!this.isAtypiques[this.indiceRunSelect][i]) continue;
            if (this.avecCumul.isSelected()) {
                cpt = 0;
                for (int j = 0; j <= this.indiceRunSelect; ++j) {
                    if (!this.isAtypiques[j][i]) continue;
                    ++cpt;
                }
                g.fillRect((int)((float)cpt * echelleX) + this.marge_gauche - this.decal_point, (int)((float)(nb_obs - i - 1) * echelleY) + this.marge_haut - this.decal_point, this.taille_point, this.taille_point);
                continue;
            }
            g.fillRect((int)((float)(this.indiceRunSelect + 1) * echelleX) + this.marge_gauche - this.decal_point, (int)((float)(nb_obs - i - 1) * echelleY) + this.marge_haut - this.decal_point, this.taille_point, this.taille_point);
        }
        g.setColor(Color.BLUE);
        g.drawString("" + nbAtypParRun[this.indiceRunSelect], (int)((float)(this.indiceRunSelect + 1) * echelleX) + this.marge_gauche + 4, this.marge_haut - 3);
        g.drawString("" + nbAtypParObs[this.indiceObsSelect], this.largeur - this.marge_droite + 3, (int)((float)(nb_obs - this.indiceObsSelect - 1) * echelleY) + this.marge_haut);
    }
}

