/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Preprocess.Feature_Selection.nonevolutionary_algorithms.RELIEF;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.StringTokenizer;
import keel.Algorithms.Preprocess.Feature_Selection.Datos;
import keel.Dataset.Attributes;
import org.core.Files;
import org.core.Randomize;

public class ReliefDiff {
    private Datos data;
    private Parametros params;
    private boolean[] features;

    public ReliefDiff(String ficParametros) {
        this.params = new Parametros(ficParametros);
        Randomize.setSeed(this.params.seed);
        this.data = new Datos(this.params.trainFileNameInput, this.params.testFileNameInput, this.params.paramKNN);
    }

    private void relief() {
        int i;
        double[] w = new double[this.data.returnNumFeatures()];
        for (i = 0; i < this.params.numInstancesSampled; ++i) {
            int posI = Randomize.Randint(0, this.data.returnNumInstances());
            int posH = this.data.findNearestHit(posI);
            int posJ = this.data.findNearestMiss(posI);
            for (int j = 0; j < w.length; ++j) {
                w[j] = w[j] - Math.pow(this.data.diff(j, posI, posH), 2.0) / (double)this.params.numInstancesSampled + Math.pow(this.data.diff(j, posI, posJ), 2.0) / (double)this.params.numInstancesSampled;
            }
        }
        this.features = new boolean[this.data.returnNumFeatures()];
        for (i = 0; i < w.length; ++i) {
            if (!(w[i] > this.params.relevanceThreshold)) continue;
            this.features[i] = true;
        }
        boolean vacio = true;
        for (int i2 = 0; i2 < this.features.length && vacio; ++i2) {
            if (!this.features[i2]) continue;
            vacio = false;
        }
        if (vacio) {
            System.err.println("ERROR: It couldn't be possible to find any solution.");
            System.err.println("Please to reduce the relevance threshold parameter");
            System.exit(0);
        }
    }

    public void ejecutar() {
        Date d = new Date();
        String resultado = "RESULTS generated at " + String.valueOf(d) + " \n--------------------------------------------------\n";
        resultado = resultado + "Algorithm Name: " + this.params.nameAlgorithm + "\n";
        this.relief();
        resultado = resultado + "\nPARTITION Filename: " + this.params.trainFileNameInput + "\n---------------\n\n";
        resultado = resultado + "Features selected: \n";
        int numFeatures = 0;
        for (int i = 0; i < this.features.length; ++i) {
            if (!this.features[i]) continue;
            resultado = resultado + Attributes.getInputAttribute(i).getName() + " - ";
            ++numFeatures;
        }
        resultado = resultado + "\n\n" + String.valueOf(numFeatures) + " features of " + Attributes.getInputNumAttributes() + "\n\n";
        resultado = resultado + "Error in test (using train for prediction): " + String.valueOf(this.data.validacionCruzada(this.features)) + "\n";
        resultado = resultado + "Error in test (using test for prediction): " + String.valueOf(this.data.LVOTest(this.features)) + "\n";
        resultado = resultado + "---------------\n";
        System.out.println("Experiment completed successfully");
        Files.writeFile(this.params.extraFileNameOutput, resultado);
        this.data.generarFicherosSalida(this.params.trainFileNameOutput, this.params.testFileNameOutput, this.features);
    }

    private class Parametros {
        String nameAlgorithm;
        int paramKNN;
        String trainFileNameInput;
        String testFileNameInput;
        String testFileNameOutput;
        String trainFileNameOutput;
        String extraFileNameOutput;
        long seed;
        double relevanceThreshold;
        int numInstancesSampled;

        Parametros(String nombreFileParametros) {
            try {
                String fichero = Files.readFile(nombreFileParametros);
                fichero = fichero + "\n";
                fichero = fichero.replace('\r', ' ');
                StringTokenizer lineasFile = new StringTokenizer(fichero, "\n");
                int i = 0;
                while (lineasFile.hasMoreTokens()) {
                    String linea = lineasFile.nextToken();
                    ++i;
                    StringTokenizer tokens = new StringTokenizer(linea, " ,\t");
                    if (!tokens.hasMoreTokens()) continue;
                    String tok = tokens.nextToken();
                    if (tok.equalsIgnoreCase("algorithm")) {
                        this.nameAlgorithm = this.getParamString(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("inputdata")) {
                        this.getInputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("outputdata")) {
                        this.getOutputFiles(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("paramKNN")) {
                        this.paramKNN = this.getParamInt(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("seed")) {
                        this.seed = this.getParamLong(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("relevanceThreshold")) {
                        this.relevanceThreshold = this.getParamFloat(tokens);
                        continue;
                    }
                    if (tok.equalsIgnoreCase("numInstancesSampled")) {
                        this.numInstancesSampled = this.getParamInt(tokens);
                        continue;
                    }
                    throw new IOException("Syntax error on line " + i + ": [" + tok + "]\n");
                }
            }
            catch (FileNotFoundException e) {
                System.err.println(e + "Parameter file");
            }
            catch (IOException e) {
                System.err.println(e + "Aborting program");
                System.exit(-1);
            }
            String contents = "-- Parameters echo --- \n";
            contents = contents + "Algorithm name: " + this.nameAlgorithm + "\n";
            contents = contents + "Input Train File: " + this.trainFileNameInput + "\n";
            contents = contents + "Input Test File: " + this.testFileNameInput + "\n";
            contents = contents + "Output Train File: " + this.trainFileNameOutput + "\n";
            contents = contents + "Output Test File: " + this.testFileNameOutput + "\n";
            contents = contents + "Parameter k of KNN Algorithm: " + this.paramKNN + "\n";
            contents = contents + "Relevance Threshold: " + this.relevanceThreshold + "\n";
            contents = contents + "Number of Instances sampled: " + this.numInstancesSampled + "\n";
            contents = contents + "Seed: " + this.seed + "\n";
            System.out.println(contents);
        }

        private int getParamInt(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Integer.parseInt(val);
        }

        private float getParamFloat(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Float.parseFloat(val);
        }

        private long getParamLong(StringTokenizer s) {
            String val = s.nextToken();
            val = s.nextToken();
            return Long.parseLong(val);
        }

        private String getParamString(StringTokenizer s) {
            String contenido = "";
            String val = s.nextToken();
            while (s.hasMoreTokens()) {
                contenido = contenido + s.nextToken() + " ";
            }
            return contenido.trim();
        }

        private void getInputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameInput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameInput = s.nextToken().replace('\"', ' ').trim();
        }

        private void getOutputFiles(StringTokenizer s) {
            String val = s.nextToken();
            this.trainFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.testFileNameOutput = s.nextToken().replace('\"', ' ').trim();
            this.extraFileNameOutput = s.nextToken().replace('\"', ' ').trim();
        }
    }
}

