/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core;

import java.util.Enumeration;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Antd;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.AttributeWeka;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.FastVector;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instance;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Instances;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.NominalAntd;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.NumericAntd;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Rule;
import keel.Algorithms.Fuzzy_Rule_Learning.Hybrid.FURIA.core.Utils;

public class RipperRule
extends Rule {
    static final long serialVersionUID = -2410020717305262952L;
    public double m_Consequent = -1.0;
    public FastVector m_Antds = new FastVector();
    double m_MinNo = 2.0;
    protected boolean m_Debug = false;
    double[] aprioriDistribution;

    public RipperRule() {
    }

    public RipperRule(double[] aprioriClassDistribution) {
        this.aprioriDistribution = (double[])aprioriClassDistribution.clone();
    }

    public void setConsequent(double cl) {
        this.m_Consequent = cl;
    }

    @Override
    public double getConsequent() {
        return this.m_Consequent;
    }

    @Override
    public Object copy() {
        RipperRule copy = new RipperRule();
        copy.setConsequent(this.getConsequent());
        copy.m_Antds = (FastVector)this.m_Antds.copyElements();
        copy.aprioriDistribution = (double[])this.aprioriDistribution.clone();
        return copy;
    }

    public double coverageDegree(Instance datum) {
        double isCover = 1.0;
        for (int i = 0; i < this.m_Antds.size(); ++i) {
            Antd antd = (Antd)this.m_Antds.elementAt(i);
            isCover *= antd.covers(datum);
        }
        return isCover;
    }

    @Override
    public boolean covers(Instance datum) {
        return this.coverageDegree(datum) != 0.0;
    }

    @Override
    public boolean hasAntds() {
        if (this.m_Antds == null) {
            return false;
        }
        return this.m_Antds.size() > 0;
    }

    @Override
    public double size() {
        return this.m_Antds.size();
    }

    private double computeDefAccu(Instances data) {
        double defAccu = 0.0;
        for (int i = 0; i < data.numInstances(); ++i) {
            Instance inst = data.instance(i);
            if ((int)inst.classValue() != (int)this.m_Consequent) continue;
            defAccu += inst.weight();
        }
        return defAccu;
    }

    @Override
    public void grow(Instances data) throws Exception {
        if (this.m_Consequent == -1.0) {
            throw new Exception(" Consequent not set yet.");
        }
        Instances growData = data;
        double sumOfWeights = growData.sumOfWeights();
        if (!Utils.gr(sumOfWeights, 0.0)) {
            return;
        }
        double defAccu = this.computeDefAccu(growData);
        double defAcRt = (defAccu + 1.0) / (sumOfWeights + 1.0);
        boolean[] used = new boolean[growData.numAttributes()];
        for (int k = 0; k < used.length; ++k) {
            used[k] = false;
        }
        int numUnused = used.length;
        for (int j = 0; j < this.m_Antds.size(); ++j) {
            Antd antdj = (Antd)this.m_Antds.elementAt(j);
            if (antdj.getAttr().isNumeric()) continue;
            used[antdj.getAttr().index()] = true;
            --numUnused;
        }
        while (Utils.gr(growData.numInstances(), 0.0) && numUnused > 0 && Utils.sm(defAcRt, 1.0)) {
            double maxInfoGain = 0.0;
            Antd oneAntd = null;
            Instances coverData = null;
            Enumeration enumAttr = growData.enumerateAttributes();
            while (enumAttr.hasMoreElements()) {
                Instances coveredData;
                AttributeWeka att = (AttributeWeka)enumAttr.nextElement();
                if (this.m_Debug) {
                    System.err.println("\nOne condition: size = " + growData.sumOfWeights());
                }
                Antd antd = null;
                antd = att.isNumeric() ? new NumericAntd(att) : new NominalAntd(att);
                if (used[att.index()] || (coveredData = this.computeInfoGain(growData, defAcRt, antd)) == null) continue;
                double infoGain = antd.getMaxInfoGain();
                if (this.m_Debug) {
                    System.err.println("Test of '" + antd.toString() + "': infoGain = " + infoGain + " | Accuracy = " + antd.getAccuRate() + "=" + antd.getAccu() + "/" + antd.getCover() + " def. accuracy: " + defAcRt);
                }
                if (!(infoGain > maxInfoGain)) continue;
                oneAntd = antd;
                coverData = coveredData;
                maxInfoGain = infoGain;
            }
            if (oneAntd == null || Utils.sm(oneAntd.getAccu(), this.m_MinNo)) break;
            if (!oneAntd.getAttr().isNumeric()) {
                used[oneAntd.getAttr().index()] = true;
                --numUnused;
            }
            this.m_Antds.addElement(oneAntd);
            growData = coverData;
            defAcRt = oneAntd.getAccuRate();
        }
    }

    private Instances computeInfoGain(Instances instances, double defAcRt, Antd antd) {
        Instances data = instances;
        Instances[] splitData = antd.splitData(data, defAcRt, this.m_Consequent);
        if (splitData != null) {
            return splitData[(int)antd.getAttrValue()];
        }
        return null;
    }

    public void prune(Instances pruneData, boolean useWhole) {
        int size;
        Instances data = pruneData;
        double total = data.sumOfWeights();
        if (!Utils.gr(total, 0.0)) {
            return;
        }
        double defAccu = this.computeDefAccu(data);
        if (this.m_Debug) {
            System.err.println("Pruning with " + defAccu + " positive data out of " + total + " instances");
        }
        if ((size = this.m_Antds.size()) == 0) {
            return;
        }
        double[] worthRt = new double[size];
        double[] coverage = new double[size];
        double[] worthValue = new double[size];
        for (int w = 0; w < size; ++w) {
            worthValue[w] = 0.0;
            coverage[w] = 0.0;
            worthRt[w] = 0.0;
        }
        double tn = 0.0;
        for (int x = 0; x < size; ++x) {
            Antd antd = (Antd)this.m_Antds.elementAt(x);
            Instances newData = data;
            data = new Instances(newData, 0);
            for (int y = 0; y < newData.numInstances(); ++y) {
                Instance ins = newData.instance(y);
                if (antd.covers(ins) > 0.0) {
                    int n = x;
                    coverage[n] = coverage[n] + ins.weight();
                    data.add(ins);
                    if ((int)ins.classValue() != (int)this.m_Consequent) continue;
                    int n2 = x;
                    worthValue[n2] = worthValue[n2] + ins.weight();
                    continue;
                }
                if (!useWhole || (int)ins.classValue() == (int)this.m_Consequent) continue;
                tn += ins.weight();
            }
            if (useWhole) {
                int n = x;
                worthValue[n] = worthValue[n] + tn;
                worthRt[x] = worthValue[x] / total;
                continue;
            }
            worthRt[x] = (worthValue[x] + 1.0) / (coverage[x] + 2.0);
        }
        double maxValue = (defAccu + 1.0) / (total + 2.0);
        int maxIndex = -1;
        for (int i = 0; i < worthValue.length; ++i) {
            if (this.m_Debug) {
                double denom = useWhole ? total : coverage[i];
                System.err.println(i + "(useAccuray? " + !useWhole + "): " + worthRt[i] + "=" + worthValue[i] + "/" + denom);
            }
            if (!(worthRt[i] > maxValue)) continue;
            maxValue = worthRt[i];
            maxIndex = i;
        }
        if (maxIndex == -1) {
            return;
        }
        for (int z = size - 1; z > maxIndex; --z) {
            this.m_Antds.removeElementAt(z);
        }
    }

    public String toString(AttributeWeka classAttr) {
        StringBuffer text = new StringBuffer();
        if (this.m_Antds.size() > 0) {
            for (int j = 0; j < this.m_Antds.size() - 1; ++j) {
                text.append("(" + ((Antd)this.m_Antds.elementAt(j)).toString() + ") and ");
            }
            text.append("(" + ((Antd)this.m_Antds.lastElement()).toString() + ")");
        }
        text.append(" => " + classAttr.name() + "=" + classAttr.value((int)this.m_Consequent));
        return text.toString();
    }

    public void fitAndSetCoreBound(Instances instances) {
        if (this.m_Antds == null) {
            return;
        }
        boolean[] antExistingForDimension = new boolean[instances.numAttributes() - 1];
        for (int i = 0; i < this.m_Antds.size(); ++i) {
            antExistingForDimension[((Antd)this.m_Antds.elementAt((int)i)).att.index()] = true;
        }
        FastVector newAntds = new FastVector(10);
        for (int iterator = 0; iterator < this.m_Antds.size(); ++iterator) {
            int i = ((Antd)this.m_Antds.elementAt(iterator)).getAttr().index();
            if (!antExistingForDimension[i]) continue;
            Instances instancesWithoutMissingValues = new Instances(instances);
            instancesWithoutMissingValues.deleteWithMissing(i);
            if (instancesWithoutMissingValues.attribute(i).isNumeric() && instancesWithoutMissingValues.numInstances() > 0) {
                NumericAntd antd;
                boolean bag0AntdExists = false;
                boolean bag1AntdExists = false;
                for (int j = 0; j < this.m_Antds.size(); ++j) {
                    if (((Antd)this.m_Antds.elementAt((int)j)).att.index() != i) continue;
                    if (((Antd)this.m_Antds.elementAt((int)j)).value == 0.0) {
                        bag0AntdExists = true;
                    } else {
                        bag1AntdExists = true;
                    }
                    newAntds.addElement((Antd)this.m_Antds.elementAt(j));
                }
                double higherCore = Double.NaN;
                double lowerCore = Double.NaN;
                if (!bag0AntdExists) {
                    if (Double.isNaN(higherCore)) {
                        higherCore = instancesWithoutMissingValues.kthSmallestValue(i, instancesWithoutMissingValues.numInstances());
                    }
                    antd = new NumericAntd(instancesWithoutMissingValues.attribute(i));
                    antd.value = 0.0;
                    antd.splitPoint = higherCore;
                    newAntds.addElement(antd);
                }
                if (bag1AntdExists) continue;
                if (Double.isNaN(lowerCore)) {
                    lowerCore = instancesWithoutMissingValues.kthSmallestValue(i, 1);
                }
                antd = new NumericAntd(instancesWithoutMissingValues.attribute(i));
                antd.value = 1.0;
                antd.splitPoint = lowerCore;
                newAntds.addElement(antd);
                continue;
            }
            for (int j = 0; j < this.m_Antds.size(); ++j) {
                if (((Antd)this.m_Antds.elementAt((int)j)).att.index() != i) continue;
                newAntds.addElement(this.m_Antds.elementAt(j));
            }
        }
        this.m_Antds = newAntds;
    }

    public void findAndSetSupportBoundForKnownAntecedents(Instances thisClassifiersExtension, boolean allWeightsAreOne) {
        if (this.m_Antds == null) {
            return;
        }
        double maxPurity = Double.NEGATIVE_INFINITY;
        boolean[] finishedAntecedents = new boolean[this.m_Antds.size()];
        for (int numFinishedAntecedents = 0; numFinishedAntecedents < this.m_Antds.size(); ++numFinishedAntecedents) {
            double maxPurityOfAllAntecedents = Double.NEGATIVE_INFINITY;
            int bestAntecedentsIndex = -1;
            double bestSupportBoundForAllAntecedents = Double.NaN;
            Instances ext = new Instances(thisClassifiersExtension, 0);
            for (int j = 0; j < this.m_Antds.size(); ++j) {
                if (finishedAntecedents[j]) continue;
                ext = new Instances(thisClassifiersExtension);
                for (int k = 0; k < this.m_Antds.size(); ++k) {
                    if (k == j) continue;
                    Antd exclusionAntd = (Antd)this.m_Antds.elementAt(k);
                    for (int y = 0; y < ext.numInstances(); ++y) {
                        if (exclusionAntd.covers(ext.instance(y)) != 0.0) continue;
                        ext.delete(y--);
                    }
                }
                if (ext.attribute(((Antd)this.m_Antds.elementAt((int)j)).att.index()).isNumeric() && ext.numInstances() > 0) {
                    double purity;
                    double coverValue;
                    double[] coverArray;
                    double[] accuArray;
                    int k;
                    NumericAntd currentAntd = (NumericAntd)((NumericAntd)this.m_Antds.elementAt(j)).copy();
                    currentAntd.fuzzyYet = true;
                    ext.deleteWithMissing(currentAntd.att.index());
                    double sumOfWeights = ext.sumOfWeights();
                    if (!Utils.gr(sumOfWeights, 0.0)) {
                        return;
                    }
                    ext.sort(currentAntd.att.index());
                    double maxPurityForThisAntecedent = 0.0;
                    double bestFoundSupportBound = Double.NaN;
                    double lastAccu = 0.0;
                    double lastCover = 0.0;
                    if (currentAntd.value == 0.0) {
                        for (k = 1; !(k >= ext.numInstances() || (lastAccu + (double)(ext.numInstances() - k - 1)) / (lastCover + (double)(ext.numInstances() - k - 1)) < maxPurityForThisAntecedent && allWeightsAreOne); ++k) {
                            if (!(currentAntd.splitPoint < ext.instance(k).value(currentAntd.att.index())) || ext.instance(k).value(currentAntd.att.index()) == ext.instance(k - 1).value(currentAntd.att.index())) continue;
                            currentAntd.supportBound = ext.instance(k).value(currentAntd.att.index());
                            accuArray = new double[ext.numInstances()];
                            coverArray = new double[ext.numInstances()];
                            for (int i = 0; i < ext.numInstances(); ++i) {
                                coverArray[i] = ext.instance(i).weight();
                                coverValue = currentAntd.covers(ext.instance(i));
                                if (!(coverArray[i] >= coverValue * ext.instance(i).weight())) continue;
                                coverArray[i] = coverValue * ext.instance(i).weight();
                                if (ext.instance(i).classValue() != this.m_Consequent) continue;
                                accuArray[i] = coverValue * ext.instance(i).weight();
                            }
                            purity = Utils.sum(accuArray) / Utils.sum(coverArray);
                            if (purity >= maxPurityForThisAntecedent) {
                                maxPurityForThisAntecedent = purity;
                                bestFoundSupportBound = currentAntd.supportBound;
                            }
                            lastAccu = Utils.sum(accuArray);
                            lastCover = Utils.sum(coverArray);
                        }
                    } else {
                        for (k = ext.numInstances() - 2; !(k < 0 || (lastAccu + (double)k) / (lastCover + (double)k) < maxPurityForThisAntecedent && allWeightsAreOne); --k) {
                            if (!(currentAntd.splitPoint > ext.instance(k).value(currentAntd.att.index())) || ext.instance(k).value(currentAntd.att.index()) == ext.instance(k + 1).value(currentAntd.att.index())) continue;
                            currentAntd.supportBound = ext.instance(k).value(currentAntd.att.index());
                            accuArray = new double[ext.numInstances()];
                            coverArray = new double[ext.numInstances()];
                            for (int i = 0; i < ext.numInstances(); ++i) {
                                coverArray[i] = ext.instance(i).weight();
                                coverValue = currentAntd.covers(ext.instance(i));
                                if (!(coverArray[i] >= coverValue * ext.instance(i).weight())) continue;
                                coverArray[i] = coverValue * ext.instance(i).weight();
                                if (ext.instance(i).classValue() != this.m_Consequent) continue;
                                accuArray[i] = coverValue * ext.instance(i).weight();
                            }
                            purity = Utils.sum(accuArray) / Utils.sum(coverArray);
                            if (purity >= maxPurityForThisAntecedent) {
                                maxPurityForThisAntecedent = purity;
                                bestFoundSupportBound = currentAntd.supportBound;
                            }
                            lastAccu = Utils.sum(accuArray);
                            lastCover = Utils.sum(coverArray);
                        }
                    }
                    if (!(maxPurityForThisAntecedent > maxPurityOfAllAntecedents)) continue;
                    bestAntecedentsIndex = j;
                    bestSupportBoundForAllAntecedents = bestFoundSupportBound;
                    maxPurityOfAllAntecedents = maxPurityForThisAntecedent;
                    continue;
                }
                finishedAntecedents[j] = true;
                ++numFinishedAntecedents;
            }
            if (bestAntecedentsIndex == -1) {
                return;
            }
            if (maxPurity <= maxPurityOfAllAntecedents) {
                if (Double.isNaN(bestSupportBoundForAllAntecedents)) {
                    ((NumericAntd)this.m_Antds.elementAt((int)bestAntecedentsIndex)).supportBound = ((NumericAntd)this.m_Antds.elementAt((int)bestAntecedentsIndex)).splitPoint;
                } else {
                    ((NumericAntd)this.m_Antds.elementAt((int)bestAntecedentsIndex)).supportBound = bestSupportBoundForAllAntecedents;
                    ((NumericAntd)this.m_Antds.elementAt((int)bestAntecedentsIndex)).fuzzyYet = true;
                }
                maxPurity = maxPurityOfAllAntecedents;
            }
            finishedAntecedents[bestAntecedentsIndex] = true;
        }
    }

    public void calculateConfidences(Instances data) throws Exception {
        RipperRule tempRule = (RipperRule)this.copy();
        while (tempRule.hasAntds()) {
            double acc = 0.0;
            double cov = 0.0;
            for (int i = 0; i < data.numInstances(); ++i) {
                double membershipValue = tempRule.coverageDegree(data.instance(i));
                cov += membershipValue;
                if (this.m_Consequent != data.instance(i).classValue()) continue;
                acc += membershipValue;
            }
            double m = 2.0;
            ((Antd)this.m_Antds.elementAt((int)((int)tempRule.size() - 1))).m_confidence = (acc + m * (this.aprioriDistribution[(int)this.m_Consequent] / Utils.sum(this.aprioriDistribution))) / (cov + m);
            tempRule.m_Antds.removeElementAt(tempRule.m_Antds.size() - 1);
        }
    }

    public double getConfidence() {
        if (!this.hasAntds()) {
            return Double.NaN;
        }
        return ((Antd)this.m_Antds.lastElement()).m_confidence;
    }

    public String getRevision() {
        return "1.0";
    }
}

