/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA;

import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.Interval;
import keel.Algorithms.UnsupervisedLearning.AssociationRules.IntervalRuleLearning.EARMGA.myDataset;

public class DiscreteDataset {
    private int nVars;
    private int[] nPartitions;
    private Interval[][] discreteDataset;

    public DiscreteDataset() {
    }

    public DiscreteDataset(int nPartitions, myDataset dataset) {
        this.nVars = dataset.getnVars();
        this.nPartitions = new int[this.nVars];
        this.discreteDataset = new Interval[this.nVars][];
        for (int i = 0; i < this.nVars; ++i) {
            double value;
            int j;
            double rank = Math.abs(dataset.getMax(i) - dataset.getMin(i));
            this.nPartitions[i] = dataset.getAttributeType(i) == 0 ? (int)rank + 1 : nPartitions;
            this.discreteDataset[i] = new Interval[this.nPartitions[i]];
            if (dataset.getAttributeType(i) == 0) {
                for (j = 0; j < this.nPartitions[i]; ++j) {
                    this.discreteDataset[i][j] = new Interval();
                    value = dataset.getMin(i) + (double)j;
                    this.discreteDataset[i][j].setLeft(value);
                    this.discreteDataset[i][j].setRight(value);
                }
                continue;
            }
            double mark = rank / (double)this.nPartitions[i];
            for (j = 0; j < this.nPartitions[i]; ++j) {
                this.discreteDataset[i][j] = new Interval();
                value = dataset.getMin(i) + mark * (double)j;
                this.discreteDataset[i][j].setLeft(this.setValue(value, dataset.getMin(i)));
                value = dataset.getMin(i) + mark * (double)(j + 1);
                this.discreteDataset[i][j].setRight(this.setValue(value, dataset.getMax(i)));
            }
        }
    }

    public int numIntervals(int variable) {
        return this.nPartitions[variable];
    }

    public Interval getInterval(int variable, int interval) {
        return this.discreteDataset[variable][interval];
    }

    public boolean isCovered(int variable, int interval, double value) {
        return this.discreteDataset[variable][interval].isCovered(value);
    }

    private double setValue(double val, double tope) {
        if (val > -1.0E-4 && val < 1.0E-4) {
            return 0.0;
        }
        if (val > tope - 1.0E-4 && val < tope + 1.0E-4) {
            return tope;
        }
        return val;
    }
}

