/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.analysis.causality;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.XMLUtils;

public class CausalSGNode {
    private int hashCode = 0;
    private Set children = new HashSet();
    private Set parents = new HashSet();
    private Set approxEqualSubgroups = new HashSet();
    private Set cCAssociations = new HashSet();
    private int level = -1;
    private SG sg = null;
    private static boolean trace = true;

    protected CausalSGNode(SG sg) {
        this.sg = sg;
    }

    public void addChild(CausalSGNode node) {
        this.children.add(node);
        node.addParent(this);
        if (trace) {
            System.out.println("Added Causal Relation:\t" + this.sg.getSGDescription().getDescription() + " --> " + node.getSG().getSGDescription().getDescription());
            if (node.getChildren().contains(this)) {
                System.out.println("Cycle:\t" + this.sg.getSGDescription().getDescription() + " <<-->> " + node.getSG().getSGDescription().getDescription());
            }
        }
    }

    public void addCCAssociation(CausalSGNode node) {
        this.cCAssociations.add(node);
        node.cCAssociations.add(this);
        if (trace) {
            System.out.println("Added Association\t" + this.sg.getSGDescription().getDescription() + " --> " + node.getSG().getSGDescription().getDescription());
        }
    }

    private void addParent(CausalSGNode parent) {
        this.parents.add(parent);
    }

    public SG getSG() {
        return this.sg;
    }

    public Set getChildren() {
        return this.children;
    }

    public String toString() {
        return this.sg.getSGDescription().getDescription();
    }

    public String verbalize() {
        StringBuffer b = new StringBuffer("<html>");
        Iterator<SGSelector> iter = this.getSG().getSGDescription().iterator();
        while (iter.hasNext()) {
            SGNominalSelector select = (SGNominalSelector)iter.next();
            String selString = select.getDescription();
            b.append(XMLUtils.convertToHTMLCompliantText(selString));
            if (!iter.hasNext()) continue;
            b.append("<br>");
        }
        b.append("</html>");
        return b.toString();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = this.sg.hashCode();
        }
        return this.hashCode;
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int newLevel) {
        this.level = Math.max(newLevel, newLevel);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        return this.sg.equals(((CausalSGNode)other).getSG());
    }

    public Set getParents() {
        return this.parents;
    }

    public Set getApproxEqualSubgroups() {
        return this.approxEqualSubgroups;
    }

    public void setApproxEqualSubgroups(Set approxEqualSubgroups) {
        this.approxEqualSubgroups = approxEqualSubgroups;
    }

    public Set getCCAssociations() {
        return this.cCAssociations;
    }
}

