/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.DateAttribute;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.SingleValue;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.util.VKMUtil;

public abstract class AbstractDataRecord
implements DataRecord {
    protected IDataRecordSet recordSet;
    protected double weight;
    private volatile int hashCode = 0;
    private long id;

    public AbstractDataRecord() {
        this(1.0);
    }

    public AbstractDataRecord(double weight) {
        this.weight = weight;
    }

    @Override
    public final IDataRecordSet getDataset() {
        return this.recordSet;
    }

    @Override
    public final long getID() {
        return this.id;
    }

    public void setID(long id) {
        this.id = id;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AbstractDataRecord otherInstance = (AbstractDataRecord)other;
        return this.getID() == otherInstance.getID();
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            this.hashCode = Long.valueOf(this.getID()).hashCode();
        }
        return this.hashCode;
    }

    @Override
    public int getNumAttributes() {
        return this.getDataset().getNumAttributes();
    }

    @Override
    public final double getWeight() {
        return this.weight;
    }

    @Override
    public final void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        StringBuffer text = new StringBuffer();
        int i = 0;
        while (i < this.getNumAttributes()) {
            if (i > 0) {
                text.append(",");
            }
            text.append(this.toString(i));
            ++i;
        }
        return text.toString();
    }

    protected final String toString(int attIndex) {
        StringBuffer text = new StringBuffer();
        if (this.isMissing(attIndex)) {
            text.append("?");
        } else if (this.recordSet == null) {
            text.append(VKMUtil.doubleToString(this.getValue(attIndex), 6));
        } else if (this.recordSet.getAttribute(attIndex).isNominal() || this.recordSet.getAttribute(attIndex).isString() || this.recordSet.getAttribute(attIndex).isDate()) {
            text.append(VKMUtil.quote(this.getStringValue(attIndex)));
        } else if (this.recordSet.getAttribute(attIndex).isNumeric()) {
            text.append(VKMUtil.doubleToString(this.getValue(attIndex), 6));
        } else {
            throw new IllegalStateException("Unknown attribute type");
        }
        return text.toString();
    }

    @Override
    public final void setValue(int attIndex, String value) {
        if (this.recordSet == null) {
            throw new IllegalStateException("Instance doesn't have access to a dataset!");
        }
        if (!this.recordSet.getAttribute(attIndex).isNominal() && !this.recordSet.getAttribute(attIndex).isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        NominalAttribute nomOrStringAttr = (NominalAttribute)this.recordSet.getAttribute(attIndex);
        int valIndex = nomOrStringAttr.getIndexOfValue(value);
        if (valIndex == -1) {
            if (nomOrStringAttr.isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            nomOrStringAttr.addValue(value);
            valIndex = nomOrStringAttr.getIndexOfValue(value);
        }
        this.setValue(attIndex, (double)valIndex);
    }

    @Override
    public final void setValue(Value value) {
        if (value instanceof SingleValue) {
            ((SingleValue)value).setValue(this);
        }
    }

    @Override
    public final void setDataset(IDataRecordSet instances) {
        this.recordSet = instances;
    }

    @Override
    public final void setMissing(Attribute att) {
        this.setMissing(this.getDataset().getIndex(att));
    }

    @Override
    public final void setMissing(int attIndex) {
        this.setValue(attIndex, Double.NaN);
    }

    @Override
    public final void setValue(Attribute att, double value) {
        this.setValue(this.recordSet.getIndex(att), value);
    }

    @Override
    public final void setValue(Attribute att, String value) {
        if (!att.isNominal() && !att.isString()) {
            throw new IllegalArgumentException("Attribute neither nominal nor string!");
        }
        NominalAttribute basicAttribute = (NominalAttribute)att;
        int valIndex = basicAttribute.getIndexOfValue(value);
        if (valIndex == -1) {
            if (att.isNominal()) {
                throw new IllegalArgumentException("Value not defined for given nominal attribute!");
            }
            basicAttribute.addValue(value);
            valIndex = basicAttribute.getIndexOfValue(value);
        }
        this.setValue(this.getDataset().getIndex(basicAttribute), (double)valIndex);
    }

    @Override
    public final boolean isMissing(Attribute att) {
        return att.isMissingValue(this);
    }

    @Override
    public final boolean isMissing(int attIndex) {
        return Value.isMissingValue(this.getValue(attIndex));
    }

    @Override
    public final double getValue(Attribute att) {
        return att.getValue(this);
    }

    @Override
    public final String getStringValue(Attribute att) {
        double value = this.getValue(att);
        if (att.isNominal() || att.isString()) {
            return ((NominalAttribute)att).getNominalValue((int)value).getDescription();
        }
        if (att.isDate()) {
            return ((DateAttribute)att).formatDate(value);
        }
        if (att.isNumeric()) {
            return Value.isMissingValue(value) ? "?" : String.valueOf(value);
        }
        throw new IllegalArgumentException("Attribute isn't nominal, numeric, string or date!");
    }

    @Override
    public final String getStringValue(int attIndex) {
        if (this.recordSet == null) {
            throw new IllegalStateException("Instance doesn't have access to a dataset!");
        }
        return this.getStringValue(this.recordSet.getAttribute(attIndex));
    }
}

