/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula;

import java.util.LinkedList;
import java.util.List;

public class ParserElement {
    protected Object content;
    protected String token;
    protected List children = new LinkedList();
    protected boolean openingBrace = false;
    protected boolean closingBrace = false;
    protected int precedence;
    protected Class type;
    protected Class[] requiredArgumentTypes = new Class[0];

    public ParserElement() {
    }

    public ParserElement(boolean opening, boolean closing) {
        if (opening && closing) {
            throw new IllegalArgumentException("ParserElement can not be opening AND closing");
        }
        this.setOpeningBrace(opening);
        this.setClosingBrace(closing);
    }

    public List getChildren() {
        return this.children;
    }

    public void setChildren(List children) {
        this.children = children;
    }

    public Object getContent() {
        return this.content;
    }

    public void setContent(Object content, String token) {
        this.content = content;
        this.token = token;
    }

    public boolean isClosingBrace() {
        return this.closingBrace;
    }

    public boolean isOpeningBrace() {
        return this.openingBrace;
    }

    public void setClosingBrace(boolean closingBrace) {
        this.closingBrace = closingBrace;
    }

    public void setOpeningBrace(boolean openingBrace) {
        this.openingBrace = openingBrace;
    }

    public int getRequiredArgumentsCount() {
        return this.getRequiredArgumentTypes() == null ? 0 : this.getRequiredArgumentTypes().length;
    }

    public int getPrecedence() {
        return this.precedence;
    }

    public void setPrecedence(int precedence) {
        this.precedence = precedence;
    }

    public Class[] getRequiredArgumentTypes() {
        return this.requiredArgumentTypes;
    }

    public void setRequiredArgumentTypes(Class[] requiredArgumentTypes) {
        this.requiredArgumentTypes = requiredArgumentTypes;
    }

    public Class getType() {
        return this.type;
    }

    public void setType(Class type) {
        this.type = type;
    }

    public String getToken() {
        return this.token;
    }
}

