/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.formula.operators;

import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.formula.EvaluationData;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.vikamine.kernel.formula.constants.FormulaAttributePrimitive;
import org.vikamine.kernel.formula.operators.AbstractAttributeArgumentTerm;

public class MaxValue
extends AbstractAttributeArgumentTerm
implements FormulaNumberElement {
    public MaxValue() {
        super("maxValue");
    }

    public MaxValue(FormulaAttributePrimitive arg) {
        this();
        this.setArg1(arg);
    }

    @Override
    public synchronized Double eval(EvaluationData data) {
        if (this.getArg1() == null || data.getInstances() == null) {
            return null;
        }
        double max = Double.NaN;
        for (DataRecord inst : data.getInstances()) {
            EvaluationData d = new EvaluationData();
            d.setInstance(inst);
            double value = this.getArg1().eval(d);
            if (!Double.isNaN(max) && !(max > value)) continue;
            max = value;
        }
        return new Double(max);
    }
}

