/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.sampling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.vikamine.kernel.data.AttributeBuilder;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.IDataRecordSet;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Ontology;

public class SampleAttributeCreator {
    public static final String VALUE_NAME_TRUE = "true";
    public static final String VALUE_NAME_FALSE = "false";

    public static NominalAttribute getBinaryAttribute(String name) {
        ArrayList<String> rawValuesList = new ArrayList<String>();
        rawValuesList.add(VALUE_NAME_FALSE);
        rawValuesList.add(VALUE_NAME_TRUE);
        AttributeBuilder attBuilder = new AttributeBuilder();
        attBuilder.buildNominalAttribute(name, rawValuesList);
        attBuilder.buildNominalValues();
        NominalAttribute binAttribute = (NominalAttribute)attBuilder.getAttribute();
        binAttribute.setDescription(name);
        return binAttribute;
    }

    public static NominalAttribute addSampleAttribute(Ontology onto, String name, int sampleSize) {
        IDataRecordSet dataset = onto.getDataset();
        NominalAttribute sampleAtt = SampleAttributeCreator.getBinaryAttribute(name);
        onto.addAttribute(sampleAtt);
        dataset.insertAttributeAt(sampleAtt, dataset.getNumAttributes());
        int indexOfSampleAttribute = dataset.getIndex(sampleAtt);
        List<Integer> setIndices = SampleAttributeCreator.getSetIndizes(sampleSize, dataset.getNumInstances());
        Iterator<Integer> iterSetIndices = setIndices.iterator();
        int nextSetIndex = iterSetIndices.next();
        int currentIndex = 0;
        for (DataRecord dr : dataset) {
            if (currentIndex == nextSetIndex) {
                dr.setValue(indexOfSampleAttribute, VALUE_NAME_TRUE);
                if (!iterSetIndices.hasNext()) break;
                nextSetIndex = iterSetIndices.next();
            } else {
                dr.setValue(indexOfSampleAttribute, VALUE_NAME_FALSE);
            }
            ++currentIndex;
        }
        return sampleAtt;
    }

    private static List<Integer> getSetIndizes(int sampleSize, int numInstances) {
        ArrayList<Integer> listAll = new ArrayList<Integer>();
        int i = 0;
        while (i < numInstances) {
            listAll.add(i);
            ++i;
        }
        Collections.shuffle(listAll);
        ArrayList<Integer> result = new ArrayList<Integer>();
        int i2 = 0;
        while (i2 < sampleSize) {
            result.add((Integer)listAll.get(i2));
            ++i2;
        }
        Collections.sort(result);
        return result;
    }
}

