/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.extension.nary;

import java.util.Arrays;
import java.util.BitSet;
import org.chocosolver.memory.IStateInt;
import org.chocosolver.solver.constraints.Explained;
import org.chocosolver.solver.constraints.extension.Tuples;
import org.chocosolver.solver.constraints.extension.nary.FastBooleanValidityChecker;
import org.chocosolver.solver.constraints.extension.nary.PropLargeCSP;
import org.chocosolver.solver.constraints.extension.nary.RelationFactory;
import org.chocosolver.solver.constraints.extension.nary.TuplesList;
import org.chocosolver.solver.constraints.extension.nary.ValidityChecker;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.util.iterators.DisposableValueIterator;
import org.chocosolver.util.objects.setDataStructures.iterable.IntIterableBitSet;

@Explained(ignored=true, comment="Turned into clauses")
public class PropLargeGACSTRPos
extends PropLargeCSP<TuplesList> {
    private final ValidityChecker valcheck;
    private final int arity;
    private final int[] offsets;
    private final BitSet futureVars;
    private final BitSet[] gacValues;
    private final int[] nbGacValues;
    private final IStateInt last;
    private final int[] listuples;
    private final IntIterableBitSet vrms;

    private PropLargeGACSTRPos(IntVar[] vs, TuplesList relation) {
        super(vs, relation, false);
        int i;
        this.arity = vs.length;
        this.futureVars = new BitSet(this.arity);
        this.gacValues = new BitSet[this.arity];
        this.nbGacValues = new int[this.arity];
        this.offsets = new int[this.arity];
        int min = Integer.MAX_VALUE;
        for (i = 0; i < this.arity; ++i) {
            this.offsets[i] = vs[i].getLB();
            this.gacValues[i] = new BitSet(vs[i].getDomainSize());
            min = Math.min(min, this.offsets[i]);
        }
        this.vrms = new IntIterableBitSet();
        this.vrms.setOffset(min);
        this.listuples = new int[((TuplesList)this.relation).getTupleTable().length];
        for (i = 0; i < this.listuples.length; ++i) {
            this.listuples[i] = i;
        }
        this.last = this.model.getEnvironment().makeInt(this.listuples.length - 1);
        int[][] tt = ((TuplesList)this.relation).getTupleTable();
        boolean fastBooleanValidCheckAllowed = true;
        block2: for (int i2 = 0; i2 < tt.length; ++i2) {
            for (int j = 0; j < tt[i2].length; ++j) {
                int lb = vs[j].getLB();
                int ub = vs[j].getUB();
                if (lb >= 0 && ub <= 1) continue;
                fastBooleanValidCheckAllowed = false;
                break block2;
            }
        }
        this.valcheck = fastBooleanValidCheckAllowed ? new FastBooleanValidityChecker(this.arity, (IntVar[])this.vars) : new ValidityChecker(this.arity, (IntVar[])this.vars);
    }

    public PropLargeGACSTRPos(IntVar[] vs, Tuples tuples) {
        this(vs, RelationFactory.makeListBasedRelation(tuples, vs));
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        this.valcheck.sortvars();
        this.gacstr();
    }

    private void initializeData() {
        Arrays.fill(this.nbGacValues, 0);
        this.futureVars.set(0, this.arity);
        for (int i = 0; i < this.arity; ++i) {
            this.gacValues[i].clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruningPhase() throws ContradictionException {
        int i = this.futureVars.nextSetBit(0);
        while (i > -1) {
            IntVar v = ((IntVar[])this.vars)[i];
            DisposableValueIterator it3 = v.getValueIterator(true);
            this.vrms.clear();
            try {
                while (it3.hasNext()) {
                    int val = it3.next();
                    if (this.gacValues[i].get(val - this.offsets[i])) continue;
                    this.vrms.add(val);
                }
                v.removeValues(this.vrms, this);
            }
            finally {
                it3.dispose();
            }
            i = this.futureVars.nextSetBit(i + 1);
        }
    }

    private void maintainList() {
        int cidx = 0;
        int nLast = this.last.get();
        while (cidx <= nLast) {
            int idxt;
            int[] tuple;
            if (this.valcheck.isValid(tuple = ((TuplesList)this.relation).getTuple(idxt = this.listuples[cidx++]))) {
                int i = this.futureVars.nextSetBit(0);
                while (i > -1) {
                    if (!this.gacValues[i].get(tuple[i] - this.offsets[i])) {
                        this.gacValues[i].set(tuple[i] - this.offsets[i]);
                        int n = i;
                        this.nbGacValues[n] = this.nbGacValues[n] + 1;
                        if (this.nbGacValues[i] == ((IntVar[])this.vars)[i].getDomainSize()) {
                            this.futureVars.clear(i);
                        }
                    }
                    i = this.futureVars.nextSetBit(i + 1);
                }
                continue;
            }
            int temp = this.listuples[nLast];
            this.listuples[nLast] = this.listuples[--cidx];
            this.listuples[cidx] = temp;
            this.last.add(-1);
            --nLast;
        }
    }

    private void gacstr() throws ContradictionException {
        this.initializeData();
        this.maintainList();
        this.pruningPhase();
    }
}

