/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.search.restart;

import java.util.function.IntSupplier;
import org.chocosolver.solver.Solver;
import org.chocosolver.solver.search.restart.AbstractRestart;
import org.chocosolver.solver.search.restart.ICutoff;
import org.chocosolver.util.criteria.LongCriterion;

public final class Restarter
extends AbstractRestart {
    private final ICutoff restartStrategy;
    private final LongCriterion criterion;
    private int restartFromStrategyCount;
    private final int restartLimit;
    private long limit;
    private long solutions;
    private final boolean resetCutoffOnSolution;

    public Restarter(ICutoff restartStrategy, LongCriterion criterion, int restartLimit, boolean resetCutoffOnSolution) {
        this.restartStrategy = restartStrategy;
        this.criterion = criterion;
        this.restartLimit = restartLimit;
        this.resetCutoffOnSolution = resetCutoffOnSolution;
    }

    @Override
    public void init() {
        this.restartFromStrategyCount = 0;
        this.limit = this.restartStrategy.getNextCutoff();
        this.next.init();
    }

    @Override
    public boolean mustRestart(Solver solver) {
        if (this.resetCutoffOnSolution && this.solutions < solver.getSolutionCount()) {
            this.solutions = solver.getSolutionCount();
            this.restartStrategy.reset();
        }
        if (this.criterion.isMet(this.limit)) {
            ++this.restartFromStrategyCount;
            this.limit = this.restartFromStrategyCount >= this.restartLimit ? Long.MAX_VALUE : (this.limit += this.restartStrategy.getNextCutoff());
            return true;
        }
        return this.next.mustRestart(solver);
    }

    @Override
    public void setGrower(IntSupplier grower) {
        this.restartStrategy.setGrower(grower);
        this.next.setGrower(grower);
    }
}

