/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.util.ArrayList;
import java.util.List;
import org.apache.pdfbox.pdmodel.font.PDFont;
import technology.tabula.HasText;
import technology.tabula.Rectangle;
import technology.tabula.Ruling;
import technology.tabula.TextChunk;
import technology.tabula.Utils;

public class TextElement
extends Rectangle
implements HasText {
    private final String text;
    private final PDFont font;
    private float fontSize;
    private float widthOfSpace;
    private float dir;
    private static final float AVERAGE_CHAR_TOLERANCE = 0.3f;

    public TextElement(float y, float x, float width, float height, PDFont font, float fontSize, String c, float widthOfSpace) {
        this(y, x, width, height, font, fontSize, c, widthOfSpace, 0.0f);
    }

    public TextElement(float y, float x, float width, float height, PDFont font, float fontSize, String c, float widthOfSpace, float dir) {
        this.setRect(x, y, width, height);
        this.text = c;
        this.widthOfSpace = widthOfSpace;
        this.fontSize = fontSize;
        this.font = font;
        this.dir = dir;
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public String getText(boolean useLineReturns) {
        return this.text;
    }

    public float getDirection() {
        return this.dir;
    }

    public float getWidthOfSpace() {
        return this.widthOfSpace;
    }

    public PDFont getFont() {
        return this.font;
    }

    public float getFontSize() {
        return this.fontSize;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        String s = super.toString();
        sb.append(s.substring(0, s.length() - 1));
        sb.append(String.format(",text=\"%s\"]", this.getText()));
        return sb.toString();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + Float.floatToIntBits(this.dir);
        result = 31 * result + (this.font == null ? 0 : this.font.hashCode());
        result = 31 * result + Float.floatToIntBits(this.fontSize);
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        result = 31 * result + Float.floatToIntBits(this.widthOfSpace);
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TextElement other = (TextElement)obj;
        if (Float.floatToIntBits(this.dir) != Float.floatToIntBits(other.dir)) {
            return false;
        }
        if (this.font == null ? other.font != null : !this.font.equals(other.font)) {
            return false;
        }
        if (Float.floatToIntBits(this.fontSize) != Float.floatToIntBits(other.fontSize)) {
            return false;
        }
        if (this.text == null ? other.text != null : !this.text.equals(other.text)) {
            return false;
        }
        return Float.floatToIntBits(this.widthOfSpace) == Float.floatToIntBits(other.widthOfSpace);
    }

    public static List<TextChunk> mergeWords(List<TextElement> textElements) {
        return TextElement.mergeWords(textElements, new ArrayList<Ruling>());
    }

    public static List<TextChunk> mergeWords(List<TextElement> textElements, List<Ruling> verticalRulings) {
        ArrayList<TextChunk> textChunks = new ArrayList<TextChunk>();
        if (textElements.isEmpty()) {
            return textChunks;
        }
        ArrayList<TextElement> copyOfTextElements = new ArrayList<TextElement>(textElements);
        textChunks.add(new TextChunk((TextElement)copyOfTextElements.remove(0)));
        TextChunk firstTC = (TextChunk)textChunks.get(0);
        float previousAveCharWidth = (float)firstTC.getWidth();
        float endOfLastTextX = firstTC.getRight();
        float maxYForLine = firstTC.getBottom();
        float maxHeightForLine = (float)firstTC.getHeight();
        float minYTopForLine = firstTC.getTop();
        float lastWordSpacing = -1.0f;
        for (TextElement chr : copyOfTextElements) {
            Rectangle sp;
            TextChunk currentChunk = (TextChunk)textChunks.get(textChunks.size() - 1);
            TextElement prevChar = (TextElement)currentChunk.textElements.get(currentChunk.textElements.size() - 1);
            if (chr.getText().equals(prevChar.getText()) && (double)prevChar.overlapRatio(chr) > 0.5 || chr.getText().equals(" ") && Utils.feq(prevChar.getLeft(), chr.getLeft()) && Utils.feq(prevChar.getTop(), chr.getTop())) continue;
            if (chr.getFont() != prevChar.getFont() || !Utils.feq(chr.getFontSize(), prevChar.getFontSize())) {
                previousAveCharWidth = -1.0f;
            }
            boolean acrossVerticalRuling = false;
            for (Ruling r : verticalRulings) {
                if (!(TextElement.verticallyOverlapsRuling(prevChar, r) && TextElement.verticallyOverlapsRuling(chr, r) && prevChar.x < r.getPosition() && chr.x > r.getPosition()) && (!(prevChar.x > r.getPosition()) || !(chr.x < r.getPosition()))) continue;
                acrossVerticalRuling = true;
                break;
            }
            float wordSpacing = chr.getWidthOfSpace();
            float deltaSpace = 0.0f;
            deltaSpace = Float.isNaN(wordSpacing) || wordSpacing == 0.0f ? Float.MAX_VALUE : (lastWordSpacing < 0.0f ? wordSpacing * 0.5f : (wordSpacing + lastWordSpacing) / 2.0f * 0.5f);
            float averageCharWidth = previousAveCharWidth < 0.0f ? (float)(chr.getWidth() / (double)chr.getText().length()) : (float)(((double)previousAveCharWidth + chr.getWidth() / (double)chr.getText().length()) / 2.0);
            float deltaCharWidth = averageCharWidth * 0.3f;
            float expectedStartOfNextWordX = -3.4028235E38f;
            if (endOfLastTextX != -1.0f) {
                expectedStartOfNextWordX = endOfLastTextX + Math.min(deltaCharWidth, deltaSpace);
            }
            boolean sameLine = true;
            if (!Utils.overlap(chr.getBottom(), chr.height, maxYForLine, maxHeightForLine)) {
                endOfLastTextX = -1.0f;
                expectedStartOfNextWordX = -3.4028235E38f;
                maxYForLine = -3.4028235E38f;
                maxHeightForLine = -1.0f;
                minYTopForLine = Float.MAX_VALUE;
                sameLine = false;
            }
            endOfLastTextX = chr.getRight();
            if (!acrossVerticalRuling && sameLine && expectedStartOfNextWordX < chr.getLeft() && !prevChar.getText().endsWith(" ")) {
                sp = new TextElement(prevChar.getTop(), prevChar.getLeft(), expectedStartOfNextWordX - prevChar.getLeft(), (float)prevChar.getHeight(), prevChar.getFont(), prevChar.getFontSize(), " ", prevChar.getWidthOfSpace());
                currentChunk.add((TextElement)sp);
            } else {
                sp = null;
            }
            maxYForLine = Math.max(chr.getBottom(), maxYForLine);
            maxHeightForLine = (float)Math.max((double)maxHeightForLine, chr.getHeight());
            minYTopForLine = Math.min(minYTopForLine, chr.getTop());
            float dist = chr.getLeft() - (sp != null ? sp.getRight() : prevChar.getRight());
            if (!acrossVerticalRuling && sameLine && (dist < 0.0f ? currentChunk.verticallyOverlaps(chr) : dist < wordSpacing)) {
                currentChunk.add(chr);
            } else {
                textChunks.add(new TextChunk(chr));
            }
            lastWordSpacing = wordSpacing;
            previousAveCharWidth = (float)(sp != null ? ((double)averageCharWidth + sp.getWidth()) / 2.0 : (double)averageCharWidth);
        }
        ArrayList<TextChunk> textChunksSeparatedByDirectionality = new ArrayList<TextChunk>();
        for (TextChunk chunk : textChunks) {
            boolean isLtrDominant = chunk.isLtrDominant() != -1;
            TextChunk dirChunk = chunk.groupByDirectionality(isLtrDominant);
            textChunksSeparatedByDirectionality.add(dirChunk);
        }
        return textChunksSeparatedByDirectionality;
    }

    private static boolean verticallyOverlapsRuling(TextElement te, Ruling r) {
        return Math.max(0.0, Math.min((double)te.getBottom(), r.getY2()) - Math.max((double)te.getTop(), r.getY1())) > 0.0;
    }
}

