/*
 * Decompiled with CFR 0.152.
 */
package org.chocosolver.solver.constraints.set;

import org.chocosolver.solver.ICause;
import org.chocosolver.solver.Priority;
import org.chocosolver.solver.constraints.Propagator;
import org.chocosolver.solver.constraints.PropagatorPriority;
import org.chocosolver.solver.exception.ContradictionException;
import org.chocosolver.solver.variables.IntVar;
import org.chocosolver.solver.variables.SetVar;
import org.chocosolver.solver.variables.Variable;
import org.chocosolver.solver.variables.delta.IIntDeltaMonitor;
import org.chocosolver.solver.variables.delta.ISetDeltaMonitor;
import org.chocosolver.solver.variables.events.SetEventType;
import org.chocosolver.util.ESat;
import org.chocosolver.util.objects.setDataStructures.ISetIterator;
import org.chocosolver.util.procedure.IntProcedure;
import org.chocosolver.util.tools.ArrayUtils;

public class PropIntChannel
extends Propagator<Variable> {
    private final int nInts;
    private final int nSets;
    private int idx;
    private final SetVar[] sets;
    private final IntVar[] ints;
    private final int offSet1;
    private final int offSet2;
    private final ISetDeltaMonitor[] sdm;
    private final IIntDeltaMonitor[] idm;
    private final IntProcedure elementForced;
    private final IntProcedure elementRemoved;
    private final IntProcedure valRem;

    public PropIntChannel(SetVar[] setsV, IntVar[] intsV, int offSet1, int offSet2) {
        super(ArrayUtils.append(setsV, intsV), (Priority)PropagatorPriority.LINEAR, true);
        int i;
        this.nSets = setsV.length;
        this.nInts = intsV.length;
        this.sets = new SetVar[this.nSets];
        this.ints = new IntVar[this.nInts];
        this.idm = new IIntDeltaMonitor[this.nInts];
        this.sdm = new ISetDeltaMonitor[this.nSets];
        this.offSet1 = offSet1;
        this.offSet2 = offSet2;
        for (i = 0; i < this.nInts; ++i) {
            this.ints[i] = (IntVar)this.vars[i + this.nSets];
            this.idm[i] = this.ints[i].monitorDelta(this);
        }
        for (i = 0; i < this.nSets; ++i) {
            this.sets[i] = (SetVar)this.vars[i];
            this.sdm[i] = this.sets[i].monitorDelta(this);
        }
        this.elementForced = element -> this.ints[element - offSet2].instantiateTo(this.idx, (ICause)this);
        this.elementRemoved = element -> this.ints[element - offSet2].removeValue(this.idx, (ICause)this);
        this.valRem = element -> this.sets[element - offSet1].remove(this.idx, this);
    }

    @Override
    public void propagate(int evtmask) throws ContradictionException {
        int j;
        int i;
        for (i = 0; i < this.nInts; ++i) {
            this.ints[i].updateBounds(this.offSet1, this.nSets - 1 + this.offSet1, this);
        }
        for (i = 0; i < this.nInts; ++i) {
            int ub = this.ints[i].getUB();
            j = this.ints[i].getLB();
            while (j <= ub) {
                if (!this.sets[j - this.offSet1].getUB().contains(i + this.offSet2)) {
                    this.ints[i].removeValue(j, (ICause)this);
                }
                j = this.ints[i].nextValue(j);
            }
            if (!this.ints[i].isInstantiated()) continue;
            this.sets[this.ints[i].getValue() - this.offSet1].force(i + this.offSet2, this);
        }
        for (i = 0; i < this.nSets; ++i) {
            ISetIterator iter = this.sets[i].getUB().iterator();
            while (iter.hasNext()) {
                j = iter.nextInt();
                if (j >= this.offSet2 && j <= this.nInts - 1 + this.offSet2 && this.ints[j - this.offSet2].contains(i + this.offSet1)) continue;
                this.sets[i].remove(j, this);
            }
            iter = this.sets[i].getLB().iterator();
            while (iter.hasNext()) {
                this.ints[iter.nextInt() - this.offSet2].instantiateTo(i + this.offSet1, (ICause)this);
            }
        }
        for (i = 0; i < this.nSets; ++i) {
            this.sdm[i].startMonitoring();
        }
        for (i = 0; i < this.nInts; ++i) {
            this.idm[i].startMonitoring();
        }
    }

    @Override
    public void propagate(int idxVarInProp, int mask) throws ContradictionException {
        this.idx = idxVarInProp;
        if (this.idx < this.nSets) {
            this.idx += this.offSet1;
            this.sdm[idxVarInProp].forEach(this.elementForced, SetEventType.ADD_TO_KER);
            this.sdm[idxVarInProp].forEach(this.elementRemoved, SetEventType.REMOVE_FROM_ENVELOPE);
        } else {
            this.idx -= this.nSets;
            if (this.ints[this.idx].isInstantiated()) {
                this.sets[this.ints[this.idx].getValue() - this.offSet1].force(this.idx + this.offSet2, this);
            }
            this.idx += this.offSet2;
            this.idm[idxVarInProp - this.nSets].forEachRemVal(this.valRem);
        }
    }

    @Override
    public ESat isEntailed() {
        int i;
        for (i = 0; i < this.nInts; ++i) {
            int val;
            if (!this.ints[i].isInstantiated() || (val = this.ints[i].getValue()) >= this.offSet1 && val < this.nSets + this.offSet1 && this.sets[val - this.offSet1].getUB().contains(i + this.offSet2)) continue;
            return ESat.FALSE;
        }
        for (i = 0; i < this.nSets; ++i) {
            ISetIterator iter = this.sets[i].getLB().iterator();
            while (iter.hasNext()) {
                int j = iter.nextInt();
                if (j >= this.offSet2 && j < this.nInts + this.offSet2 && this.ints[j - this.offSet2].contains(i + this.offSet1)) continue;
                return ESat.FALSE;
            }
        }
        if (this.isCompletelyInstantiated()) {
            return ESat.TRUE;
        }
        return ESat.UNDEFINED;
    }
}

