/*
 * Decompiled with CFR 0.152.
 */
package technology.tabula;

import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public final class CohenSutherlandClipping {
    private double xMin;
    private double yMin;
    private double xMax;
    private double yMax;
    private static final int INSIDE = 0;
    private static final int LEFT = 1;
    private static final int RIGHT = 2;
    private static final int BOTTOM = 4;
    private static final int TOP = 8;
    private static final float MINIMUM_DELTA = 0.01f;

    public CohenSutherlandClipping() {
    }

    public CohenSutherlandClipping(Rectangle2D clipWindow) {
        this.setClip(clipWindow);
    }

    public void setClip(Rectangle2D clipWindow) {
        this.xMin = clipWindow.getX();
        this.xMax = this.xMin + clipWindow.getWidth();
        this.yMin = clipWindow.getY();
        this.yMax = this.yMin + clipWindow.getHeight();
    }

    public boolean clip(Line2D.Float line) {
        double lineSlope;
        Point point1 = new Point(line.getX1(), line.getY1());
        Point point2 = new Point(line.getX2(), line.getY2());
        Point outsidePoint = new Point(0.0, 0.0);
        boolean lineIsVertical = point1.x == point2.x;
        double d = lineSlope = lineIsVertical ? 0.0 : (point2.y - point1.y) / (point2.x - point1.x);
        while (point1.region != 0 || point2.region != 0) {
            if ((point1.region & point2.region) != 0) {
                return false;
            }
            int n = outsidePoint.region = point1.region == 0 ? point2.region : point1.region;
            if ((outsidePoint.region & 1) != 0) {
                outsidePoint.x = this.xMin;
                outsidePoint.y = CohenSutherlandClipping.delta(outsidePoint.x, point1.x) * lineSlope + point1.y;
            } else if ((outsidePoint.region & 2) != 0) {
                outsidePoint.x = this.xMax;
                outsidePoint.y = CohenSutherlandClipping.delta(outsidePoint.x, point1.x) * lineSlope + point1.y;
            } else if ((outsidePoint.region & 4) != 0) {
                outsidePoint.y = this.yMin;
                outsidePoint.x = lineIsVertical ? point1.x : CohenSutherlandClipping.delta(outsidePoint.y, point1.y) / lineSlope + point1.x;
            } else if ((outsidePoint.region & 8) != 0) {
                outsidePoint.y = this.yMax;
                double d2 = outsidePoint.x = lineIsVertical ? point1.x : CohenSutherlandClipping.delta(outsidePoint.y, point1.y) / lineSlope + point1.x;
            }
            if (outsidePoint.isInTheSameRegionAs(point1)) {
                point1.setPositionAndRegion(outsidePoint.x, outsidePoint.y);
                continue;
            }
            point2.setPositionAndRegion(outsidePoint.x, outsidePoint.y);
        }
        line.setLine(point1.x, point1.y, point2.x, point2.y);
        return true;
    }

    private static double delta(double value1, double value2) {
        return Math.abs(value1 - value2) < (double)0.01f ? 0.0 : value1 - value2;
    }

    class Point {
        double x;
        double y;
        int region;

        Point(double x, double y) {
            this.setPositionAndRegion(x, y);
        }

        void setPositionAndRegion(double x, double y) {
            this.x = x;
            this.y = y;
            int n = x < CohenSutherlandClipping.this.xMin ? 1 : (this.region = x > CohenSutherlandClipping.this.xMax ? 2 : 0);
            if (y < CohenSutherlandClipping.this.yMin) {
                this.region |= 4;
            } else if (y > CohenSutherlandClipping.this.yMax) {
                this.region |= 8;
            }
        }

        boolean isInTheSameRegionAs(Point otherPoint) {
            return this.region == otherPoint.region;
        }
    }
}

