## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.width = 8,
  fig.height = 6
)

## ----setup--------------------------------------------------------------------
library(QualityMeasure)

## -----------------------------------------------------------------------------
df <- colonoscopy
knitr::kable(head(df), 'simple')

## -----------------------------------------------------------------------------
BB.results <- calcBetaBin(df = df, df.aggregate = T, n = 'n', x = 'x')

## -----------------------------------------------------------------------------
summary(BB.results$est.BB)

## -----------------------------------------------------------------------------
plot.df <- data.frame(
  n = df$n,
  rel = BB.results$est.BB
)

fig <- ggplot(data = plot.df, aes(x = n, y = rel)) +
  geom_point(size = 3) +
  geom_hline(yintercept = median(BB.results$est.BB), linetype = 'dashed', col = 'red', linewidth = 2) +
  annotate('text', x = 1700, y = 0.92, label = 'Median reliability', size = 6, col = 'red') +
  xlab('Entity sample size') +
  ylab('Reliability') +
  theme_classic() +
  theme(
    panel.grid.major = element_line(),
    panel.grid.minor = element_line(),
    axis.text = element_text(size = 16),
    axis.ticks.length = unit(.25, 'cm'),
    axis.title = element_text(size = 18, face = 'bold')
  )
fig

