/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.data;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.IncludingDataRecordFilter;

public class FilteringDataRecordIterator
implements Iterator<DataRecord> {
    private final IncludingDataRecordFilter filter;
    private final Iterator<DataRecord> instanceIterator;
    private DataRecord nextInstance;

    public FilteringDataRecordIterator(Iterator<DataRecord> instanceIterator, IncludingDataRecordFilter includingInstanceFilter) {
        this.filter = includingInstanceFilter;
        this.instanceIterator = instanceIterator;
    }

    @Override
    public boolean hasNext() {
        while (this.nextInstance == null && this.instanceIterator.hasNext()) {
            DataRecord next = this.instanceIterator.next();
            if (!this.filter.isIncluded(next)) continue;
            this.nextInstance = next;
        }
        return this.nextInstance != null;
    }

    @Override
    public DataRecord next() {
        if (this.hasNext()) {
            DataRecord tmp = this.nextInstance;
            assert (tmp != null);
            this.nextInstance = null;
            return tmp;
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("FilteringDataRecordIterator can not remove Elements!");
    }
}

