/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.subgroup.selectors;

import java.util.Collection;
import java.util.Set;
import org.vikamine.kernel.Describer;
import org.vikamine.kernel.KernelResources;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.subgroup.selectors.SGNominalSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.util.IdentityLongDescriber;

public class NegatedSGSelector
implements SGNominalSelector,
Cloneable {
    private static String NEGATION_STRING = KernelResources.getInstance().getI18N().getString("vkmKernel.NegatedSGSelector.NegationString");
    private SGNominalSelector positiveSelector;

    public NegatedSGSelector(SGSelector positiveSGSelector) {
        if (positiveSGSelector == null) {
            throw new NullPointerException("Positive Selector must not be null");
        }
        if (!(positiveSGSelector instanceof SGNominalSelector)) {
            throw new IllegalArgumentException("Negated selectors are only implemented for NominalSelectors");
        }
        this.setPositiveSelector((SGNominalSelector)positiveSGSelector);
    }

    public SGNominalSelector getPositiveSelector() {
        return this.positiveSelector;
    }

    public void setPositiveSelector(SGNominalSelector positiveSelector) {
        this.positiveSelector = positiveSelector;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        NegatedSGSelector otherSGS = (NegatedSGSelector)object;
        return this.getPositiveSelector().equals(otherSGS.getPositiveSelector());
    }

    @Override
    public Attribute getAttribute() {
        return this.positiveSelector.getAttribute();
    }

    public int hashCode() {
        return this.positiveSelector.hashCode();
    }

    @Override
    public boolean isContainedInInstance(DataRecord instance) {
        return !this.positiveSelector.isContainedInInstance(instance);
    }

    public String toString() {
        return this.getId();
    }

    @Override
    public String getId() {
        return String.valueOf(NEGATION_STRING) + this.positiveSelector.getId();
    }

    @Override
    public String getDescription(Describer d) {
        return String.valueOf(NEGATION_STRING) + d.createDescription(this.positiveSelector);
    }

    @Override
    public String getDescription() {
        return this.getDescription(new IdentityLongDescriber());
    }

    @Override
    public boolean isMaybeRedundant() {
        return this.positiveSelector.isMaybeRedundant();
    }

    @Override
    public Set<Value> getValues() {
        return this.positiveSelector.getValues();
    }

    @Override
    public boolean addValue(Value val) {
        return this.positiveSelector.addValue(val);
    }

    @Override
    public boolean addAll(Collection values) {
        return this.positiveSelector.addAll(values);
    }

    @Override
    public boolean removeValue(Value val) {
        return this.positiveSelector.removeValue(val);
    }

    @Override
    public boolean removeAll(Collection values) {
        return this.positiveSelector.removeAll(values);
    }

    @Override
    public Object clone() {
        try {
            NegatedSGSelector sel = (NegatedSGSelector)super.clone();
            sel.positiveSelector = (SGNominalSelector)this.positiveSelector.clone();
            return sel;
        }
        catch (CloneNotSupportedException ex) {
            throw new Error("Assertion failure!");
        }
    }

    @Override
    public boolean includes(SGSelector sel) {
        throw new UnsupportedOperationException();
    }
}

