/*
 * Decompiled with CFR 0.152.
 */
package dr.inference.operators.hmc;

import dr.inference.hmc.GradientWrtParameterProvider;
import dr.inference.hmc.PathGradient;
import dr.inference.hmc.ReversibleHMCProvider;
import dr.inference.model.Likelihood;
import dr.inference.model.Parameter;
import dr.inference.operators.AbstractAdaptableOperator;
import dr.inference.operators.AdaptationMode;
import dr.inference.operators.GeneralOperator;
import dr.inference.operators.PathDependent;
import dr.inference.operators.hmc.MassPreconditionScheduler;
import dr.inference.operators.hmc.MassPreconditioner;
import dr.inference.operators.hmc.MassPreconditioningOptions;
import dr.math.MathUtils;
import dr.math.MultivariateFunction;
import dr.math.NumericalDerivative;
import dr.math.matrixAlgebra.ReadableVector;
import dr.math.matrixAlgebra.WrappedVector;
import dr.util.Transform;
import java.util.ArrayList;
import java.util.Iterator;

public class HamiltonianMonteCarloOperator
extends AbstractAdaptableOperator
implements GeneralOperator,
PathDependent,
ReversibleHMCProvider {
    final GradientWrtParameterProvider gradientProvider;
    protected double stepSize;
    LeapFrogEngine leapFrogEngine;
    protected final Parameter parameter;
    protected final MassPreconditioner preconditioning;
    protected final MassPreconditionScheduler preconditionScheduler;
    private final Options runtimeOptions;
    protected final double[] mask;
    protected final Transform transform;
    private static final boolean REJECT_ARITHMETIC_EXCEPTION = true;
    private static final boolean DEBUG = false;

    public HamiltonianMonteCarloOperator(AdaptationMode adaptationMode, double d, GradientWrtParameterProvider gradientWrtParameterProvider, Parameter parameter, Transform transform, Parameter parameter2, Options options, MassPreconditioner massPreconditioner) {
        this(adaptationMode, d, gradientWrtParameterProvider, parameter, transform, parameter2, options, massPreconditioner, MassPreconditionScheduler.Type.DEFAULT);
    }

    public HamiltonianMonteCarloOperator(AdaptationMode adaptationMode, double d, GradientWrtParameterProvider gradientWrtParameterProvider, Parameter parameter, Transform transform, Parameter parameter2, Options options, MassPreconditioner massPreconditioner, MassPreconditionScheduler.Type type) {
        super(adaptationMode, options.targetAcceptanceProbability);
        this.setWeight(d);
        this.gradientProvider = gradientWrtParameterProvider;
        this.runtimeOptions = options;
        this.stepSize = options.initialStepSize;
        this.preconditioning = massPreconditioner;
        this.preconditionScheduler = type.factory(options, this);
        this.parameter = parameter;
        this.mask = this.buildMask(parameter2);
        this.transform = transform;
        this.leapFrogEngine = this.constructLeapFrogEngine(transform);
    }

    protected LeapFrogEngine constructLeapFrogEngine(Transform transform) {
        return transform != null ? new LeapFrogEngine.WithTransform(this.parameter, transform, this.getDefaultInstabilityHandler(), this.preconditioning, this.mask) : new LeapFrogEngine.Default(this.parameter, this.getDefaultInstabilityHandler(), this.preconditioning, this.mask);
    }

    @Override
    public String getOperatorName() {
        return "VanillaHMC(" + this.parameter.getParameterName() + ")";
    }

    protected double[] buildMask(Parameter parameter) {
        if (parameter == null) {
            return null;
        }
        double[] dArray = new double[parameter.getDimension()];
        for (int i = 0; i < dArray.length; ++i) {
            dArray[i] = parameter.getParameterValue(i) == 0.0 ? 0.0 : 1.0;
        }
        return dArray;
    }

    @Override
    public double doOperation() {
        throw new RuntimeException("Should not be executed");
    }

    @Override
    public double doOperation(Likelihood likelihood) {
        if (this.shouldCheckStepSize()) {
            this.checkStepSize();
        }
        if (this.shouldCheckGradient()) {
            this.checkGradient(likelihood);
        }
        if (this.preconditionScheduler.shouldUpdatePreconditioning()) {
            this.updatePreconditioning();
        }
        try {
            return this.leapFrog();
        }
        catch (NumericInstabilityException numericInstabilityException) {
            return Double.NEGATIVE_INFINITY;
        }
        catch (ArithmeticException arithmeticException) {
            return Double.NEGATIVE_INFINITY;
        }
    }

    private void updatePreconditioning() {
        double[] dArray = this.leapFrogEngine.getLastGradient();
        double[] dArray2 = this.leapFrogEngine.getLastPosition();
        double[] dArray3 = this.leapFrogEngine.getInitialPosition();
        if (this.preconditionScheduler.shouldStoreSecant(dArray, dArray2)) {
            this.preconditioning.storeSecant(new WrappedVector.Raw(dArray), new WrappedVector.Raw(dArray3));
        }
        this.preconditioning.updateMass();
    }

    @Override
    public void setPathParameter(double d) {
        if (this.gradientProvider instanceof PathGradient) {
            ((PathGradient)this.gradientProvider).setPathParameter(d);
        }
    }

    private boolean shouldCheckStepSize() {
        return this.getCount() < 1L && this.getMode() == AdaptationMode.ADAPTATION_ON;
    }

    private void checkStepSize() {
        int n;
        double[] dArray = this.parameter.getParameterValues();
        boolean bl = false;
        for (n = 0; !bl && n < this.runtimeOptions.checkStepSizeMaxIterations; ++n) {
            try {
                this.leapFrog();
                double d = this.gradientProvider.getLikelihood().getLogLikelihood();
                if (!Double.isNaN(d) && !Double.isInfinite(d)) {
                    bl = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (!bl) {
                this.stepSize *= this.runtimeOptions.checkStepSizeReductionFactor;
            }
            ReadableVector.Utils.setParameter(dArray, this.parameter);
        }
        if (!bl && n < this.runtimeOptions.checkStepSizeMaxIterations) {
            throw new RuntimeException("Unable to find acceptable initial HMC step-size");
        }
    }

    boolean shouldCheckGradient() {
        return this.getCount() < (long)this.runtimeOptions.gradientCheckCount;
    }

    void checkGradient(final Likelihood likelihood) {
        if (this.parameter.getDimension() != this.gradientProvider.getDimension()) {
            throw new RuntimeException("Unequal dimensions");
        }
        MultivariateFunction multivariateFunction = new MultivariateFunction(){

            @Override
            public double evaluate(double[] dArray) {
                if (HamiltonianMonteCarloOperator.this.transform == null) {
                    ReadableVector.Utils.setParameter(dArray, HamiltonianMonteCarloOperator.this.parameter);
                    return likelihood.getLogLikelihood();
                }
                double[] dArray2 = HamiltonianMonteCarloOperator.this.transform.inverse(dArray, 0, dArray.length);
                ReadableVector.Utils.setParameter(dArray2, HamiltonianMonteCarloOperator.this.parameter);
                return likelihood.getLogLikelihood() - HamiltonianMonteCarloOperator.this.transform.logJacobian(dArray2, 0, dArray2.length);
            }

            @Override
            public int getNumArguments() {
                return HamiltonianMonteCarloOperator.this.parameter.getDimension();
            }

            @Override
            public double getLowerBound(int n) {
                return HamiltonianMonteCarloOperator.this.parameter.getBounds().getLowerLimit(n);
            }

            @Override
            public double getUpperBound(int n) {
                return HamiltonianMonteCarloOperator.this.parameter.getBounds().getUpperLimit(n);
            }
        };
        double[] dArray = this.gradientProvider.getGradientLogDensity();
        double[] dArray2 = this.parameter.getParameterValues();
        if (this.transform == null) {
            double[] dArray3 = NumericalDerivative.gradient(multivariateFunction, this.parameter.getParameterValues());
            if (!MathUtils.isClose(dArray, dArray3, this.runtimeOptions.gradientCheckTolerance)) {
                String string = "Gradients do not match:\n\tAnalytic: " + new WrappedVector.Raw(dArray) + "\n\tNumeric : " + new WrappedVector.Raw(dArray3) + "\n" + this.gradientMismatchInformation(dArray, dArray3);
                throw new RuntimeException(string);
            }
        } else {
            double[] dArray4 = this.transform.transform(this.parameter.getParameterValues(), 0, this.parameter.getParameterValues().length);
            double[] dArray5 = NumericalDerivative.gradient(multivariateFunction, dArray4);
            double[] dArray6 = this.transform.updateGradientLogDensity(dArray, this.parameter.getParameterValues(), 0, this.parameter.getParameterValues().length);
            if (!MathUtils.isClose(dArray6, dArray5, this.runtimeOptions.gradientCheckTolerance)) {
                String string = "Transformed Gradients do not match:\n\tAnalytic: " + new WrappedVector.Raw(dArray6) + "\n\tNumeric : " + new WrappedVector.Raw(dArray5) + "\n\tParameter : " + new WrappedVector.Raw(this.parameter.getParameterValues()) + "\n\tTransformed Parameter : " + new WrappedVector.Raw(dArray4) + "\n" + this.gradientMismatchInformation(dArray6, dArray5);
                throw new RuntimeException(string);
            }
        }
        ReadableVector.Utils.setParameter(dArray2, this.parameter);
    }

    private String gradientMismatchInformation(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        int n2 = -1;
        double d2 = 0.0;
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        double[] dArray3 = new double[n];
        for (int i = 0; i < n; ++i) {
            double d3;
            dArray3[i] = d3 = Math.abs(dArray[i] - dArray2[i]);
            d2 += d3;
            if (d3 > this.runtimeOptions.gradientCheckTolerance) {
                arrayList.add(i);
            }
            if (!(d3 > d)) continue;
            d = d3;
            n2 = i;
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("\tMaximum absolute difference: " + d + " (at index " + n2 + ")\n");
        stringBuilder.append("\tAverage absolute difference: " + (d2 /= (double)n) + "\n");
        stringBuilder.append("\tList of all values exceeding the tolerance:\n");
        stringBuilder.append("\t\tindex    analytic    numeric    absolute difference\n");
        int n3 = 0;
        String string = "    ";
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            int n4 = (Integer)iterator.next();
            stringBuilder.append("\t\t" + arrayList.get(n3) + string + dArray[n4] + string + dArray2[n4] + string + dArray3[n4] + "\n");
            ++n3;
        }
        return stringBuilder.toString();
    }

    static double[] mask(double[] dArray, double[] dArray2) {
        assert (dArray2 == null || dArray2.length == dArray.length);
        if (dArray2 != null) {
            for (int i = 0; i < dArray.length; ++i) {
                if (dArray2[i] != 0.0) continue;
                dArray[i] = 0.0;
            }
        }
        return dArray;
    }

    static WrappedVector mask(WrappedVector wrappedVector, double[] dArray) {
        assert (dArray == null || dArray.length == wrappedVector.getDim());
        if (dArray != null) {
            for (int i = 0; i < wrappedVector.getDim(); ++i) {
                if (dArray[i] != 0.0) continue;
                wrappedVector.set(i, 0.0);
            }
        }
        return wrappedVector;
    }

    private int getNumberOfSteps() {
        int n = this.runtimeOptions.nSteps;
        if (this.runtimeOptions.randomStepCountFraction > 0.0) {
            double d = (double)n * (1.0 + this.runtimeOptions.randomStepCountFraction * (MathUtils.nextDouble() - 0.5));
            n = Math.max(1, (int)d);
        }
        return n;
    }

    @Override
    public double getKineticEnergy(ReadableVector readableVector) {
        int n = readableVector.getDim();
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += readableVector.get(i) * this.preconditioning.getVelocity(i, readableVector);
        }
        return d / 2.0;
    }

    private double leapFrog() throws NumericInstabilityException {
        WrappedVector wrappedVector = HamiltonianMonteCarloOperator.mask(this.preconditioning.drawInitialMomentum(), this.mask);
        return this.leapFrogGivenMomentum(wrappedVector);
    }

    protected double leapFrogGivenMomentum(WrappedVector wrappedVector) throws NumericInstabilityException {
        this.leapFrogEngine.updateMask();
        double[] dArray = this.leapFrogEngine.getInitialPosition();
        this.leapFrogEngine.projectMomentum(wrappedVector.getBuffer(), dArray);
        double d = this.getKineticEnergy(wrappedVector) + this.leapFrogEngine.getParameterLogJacobian();
        this.leapFrogEngine.updateMomentum(dArray, wrappedVector.getBuffer(), HamiltonianMonteCarloOperator.mask(this.gradientProvider.getGradientLogDensity(), this.mask), this.stepSize / 2.0);
        int n = this.getNumberOfSteps();
        for (int i = 0; i < n; ++i) {
            try {
                this.leapFrogEngine.updatePosition(dArray, wrappedVector, this.stepSize);
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericInstabilityException();
            }
            if (i >= n - 1) continue;
            try {
                this.leapFrogEngine.updateMomentum(dArray, wrappedVector.getBuffer(), HamiltonianMonteCarloOperator.mask(this.gradientProvider.getGradientLogDensity(), this.mask), this.stepSize);
                continue;
            }
            catch (ArithmeticException arithmeticException) {
                throw new NumericInstabilityException();
            }
        }
        this.leapFrogEngine.updateMomentum(dArray, wrappedVector.getBuffer(), HamiltonianMonteCarloOperator.mask(this.gradientProvider.getGradientLogDensity(), this.mask), this.stepSize / 2.0);
        double d2 = this.getKineticEnergy(wrappedVector) + this.leapFrogEngine.getParameterLogJacobian();
        return d - d2;
    }

    @Override
    protected double getAdaptableParameterValue() {
        return Math.log(this.stepSize);
    }

    @Override
    public void setAdaptableParameterValue(double d) {
        this.stepSize = Math.exp(d);
    }

    @Override
    public double getRawParameter() {
        return this.stepSize;
    }

    protected InstabilityHandler getDefaultInstabilityHandler() {
        return this.runtimeOptions.instabilityHandler;
    }

    @Override
    public String getAdaptableParameterName() {
        return "stepSize";
    }

    @Override
    public void reversiblePositionMomentumUpdate(WrappedVector wrappedVector, WrappedVector wrappedVector2, WrappedVector wrappedVector3, int n, double d) {
        this.preconditionScheduler.forceUpdateCount();
        try {
            this.leapFrogEngine.updateMomentum(wrappedVector.getBuffer(), wrappedVector2.getBuffer(), HamiltonianMonteCarloOperator.mask(wrappedVector3.getBuffer(), this.mask), d * (double)n / 2.0);
            this.leapFrogEngine.updatePosition(wrappedVector.getBuffer(), wrappedVector2, d * (double)n);
            this.updateGradient(wrappedVector3);
            this.leapFrogEngine.updateMomentum(wrappedVector.getBuffer(), wrappedVector2.getBuffer(), HamiltonianMonteCarloOperator.mask(wrappedVector3.getBuffer(), this.mask), d * (double)n / 2.0);
        }
        catch (NumericInstabilityException numericInstabilityException) {
            this.handleInstability();
        }
    }

    @Override
    public void providerUpdatePreconditioning() {
        this.updatePreconditioning();
    }

    public void updateGradient(WrappedVector wrappedVector) {
        double[] dArray = this.gradientProvider.getGradientLogDensity();
        for (int i = 0; i < dArray.length; ++i) {
            wrappedVector.set(i, dArray[i]);
        }
    }

    @Override
    public double[] getInitialPosition() {
        return this.leapFrogEngine.getInitialPosition();
    }

    @Override
    public double getParameterLogJacobian() {
        return this.leapFrogEngine.getParameterLogJacobian();
    }

    @Override
    public Transform getTransform() {
        return this.transform;
    }

    @Override
    public GradientWrtParameterProvider getGradientProvider() {
        return this.gradientProvider;
    }

    @Override
    public void setParameter(double[] dArray) {
        this.leapFrogEngine.setParameter(dArray);
    }

    @Override
    public WrappedVector drawMomentum() {
        return HamiltonianMonteCarloOperator.mask(this.preconditioning.drawInitialMomentum(), this.mask);
    }

    @Override
    public double getJointProbability(WrappedVector wrappedVector) {
        return this.gradientProvider.getLikelihood().getLogLikelihood() - this.getKineticEnergy(wrappedVector) - this.getParameterLogJacobian();
    }

    @Override
    public double getLogLikelihood() {
        return this.gradientProvider.getLikelihood().getLogLikelihood();
    }

    @Override
    public double getStepSize() {
        return this.stepSize;
    }

    @Override
    public int getNumGradientEvent() {
        return 0;
    }

    @Override
    public int getNumBoundaryEvent() {
        return 0;
    }

    @Override
    public double[] getMask() {
        return this.mask;
    }

    protected void handleInstability() {
        throw new RuntimeException("Numerical instability; need to handle");
    }

    public static class Options
    implements MassPreconditioningOptions {
        final double initialStepSize;
        final int nSteps;
        final double randomStepCountFraction;
        final int gradientCheckCount;
        final MassPreconditioningOptions preconditioningOptions;
        final double gradientCheckTolerance;
        final int checkStepSizeMaxIterations;
        final double checkStepSizeReductionFactor;
        final double targetAcceptanceProbability;
        final InstabilityHandler instabilityHandler;

        public Options(double d, int n, double d2, MassPreconditioningOptions massPreconditioningOptions, int n2, double d3, int n3, double d4, double d5, InstabilityHandler instabilityHandler) {
            this.initialStepSize = d;
            this.nSteps = n;
            this.randomStepCountFraction = d2;
            this.gradientCheckCount = n2;
            this.gradientCheckTolerance = d3;
            this.checkStepSizeMaxIterations = n3;
            this.checkStepSizeReductionFactor = d4;
            this.targetAcceptanceProbability = d5;
            this.instabilityHandler = instabilityHandler;
            this.preconditioningOptions = massPreconditioningOptions;
        }

        @Override
        public int preconditioningUpdateFrequency() {
            return this.preconditioningOptions.preconditioningUpdateFrequency();
        }

        @Override
        public int preconditioningDelay() {
            return this.preconditioningOptions.preconditioningDelay();
        }

        @Override
        public int preconditioningMaxUpdate() {
            return this.preconditioningOptions.preconditioningMaxUpdate();
        }

        @Override
        public int preconditioningMemory() {
            return this.preconditioningOptions.preconditioningMemory();
        }

        @Override
        public Parameter preconditioningEigenLowerBound() {
            throw new RuntimeException("Not yet implemented.");
        }

        @Override
        public Parameter preconditioningEigenUpperBound() {
            throw new RuntimeException("Not yet implemented.");
        }
    }

    static interface LeapFrogEngine {
        public double[] getInitialPosition();

        public double getParameterLogJacobian();

        public void updateMomentum(double[] var1, double[] var2, double[] var3, double var4) throws NumericInstabilityException;

        public void updatePosition(double[] var1, WrappedVector var2, double var3) throws NumericInstabilityException;

        public void setParameter(double[] var1);

        public double[] getLastGradient();

        public double[] getLastPosition();

        public void projectMomentum(double[] var1, double[] var2);

        public void updateMask();

        public static class WithTransform
        extends Default {
            protected final Transform transform;
            double[] unTransformedPosition;

            WithTransform(Parameter parameter, Transform transform, InstabilityHandler instabilityHandler, MassPreconditioner massPreconditioner, double[] dArray) {
                super(parameter, instabilityHandler, massPreconditioner, dArray);
                this.transform = transform;
            }

            @Override
            public double getParameterLogJacobian() {
                return this.transform.logJacobian(this.unTransformedPosition, 0, this.unTransformedPosition.length);
            }

            @Override
            public double[] getInitialPosition() {
                this.unTransformedPosition = super.getInitialPosition();
                return this.transform.transform(this.unTransformedPosition, 0, this.unTransformedPosition.length);
            }

            @Override
            public void updateMomentum(double[] dArray, double[] dArray2, double[] dArray3, double d) throws NumericInstabilityException {
                dArray3 = this.transform.updateGradientLogDensity(dArray3, this.unTransformedPosition, 0, this.unTransformedPosition.length);
                HamiltonianMonteCarloOperator.mask(dArray3, this.mask);
                super.updateMomentum(dArray, dArray2, dArray3, d);
            }

            @Override
            public void updatePosition(double[] dArray, WrappedVector wrappedVector, double d) throws NumericInstabilityException {
                super.updatePosition(dArray, wrappedVector, d);
                if (this.instabilityHandler.checkPositionTransform()) {
                    this.checkPosition(this.unTransformedPosition);
                }
            }

            @Override
            public void setParameter(double[] dArray) {
                this.unTransformedPosition = this.transform.inverse(dArray, 0, dArray.length);
                super.setParameter(this.unTransformedPosition);
            }

            private void checkPosition(double[] dArray) throws NumericInstabilityException {
                this.instabilityHandler.checkPosition(this.transform, dArray);
            }
        }

        public static class Default
        implements LeapFrogEngine {
            protected final Parameter parameter;
            final InstabilityHandler instabilityHandler;
            private final MassPreconditioner preconditioning;
            final double[] mask;
            double[] lastGradient;
            double[] lastPosition;

            Default(Parameter parameter, InstabilityHandler instabilityHandler, MassPreconditioner massPreconditioner, double[] dArray) {
                this.parameter = parameter;
                this.instabilityHandler = instabilityHandler;
                this.preconditioning = massPreconditioner;
                this.mask = dArray;
            }

            @Override
            public double[] getInitialPosition() {
                return this.parameter.getParameterValues();
            }

            @Override
            public double getParameterLogJacobian() {
                return 0.0;
            }

            @Override
            public double[] getLastGradient() {
                return this.lastGradient;
            }

            @Override
            public double[] getLastPosition() {
                return this.lastPosition;
            }

            @Override
            public void projectMomentum(double[] dArray, double[] dArray2) {
            }

            @Override
            public void updateMask() {
            }

            @Override
            public void updateMomentum(double[] dArray, double[] dArray2, double[] dArray3, double d) throws NumericInstabilityException {
                int n = dArray2.length;
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    dArray2[n2] = dArray2[n2] + d * dArray3[i];
                    this.instabilityHandler.checkValue(dArray2[i]);
                }
                this.lastGradient = dArray3;
                this.lastPosition = dArray;
            }

            @Override
            public void updatePosition(double[] dArray, WrappedVector wrappedVector, double d) throws NumericInstabilityException {
                int n = wrappedVector.getDim();
                for (int i = 0; i < n; ++i) {
                    int n2 = i;
                    dArray[n2] = dArray[n2] + d * this.preconditioning.getVelocity(i, wrappedVector);
                    this.instabilityHandler.checkValue(dArray[i]);
                }
                this.setParameter(dArray);
            }

            @Override
            public void setParameter(double[] dArray) {
                ReadableVector.Utils.setParameter(dArray, this.parameter);
            }
        }
    }

    public static enum InstabilityHandler {
        REJECT("reject"){

            @Override
            void checkValue(double d) throws NumericInstabilityException {
                if (Double.isNaN(d)) {
                    throw new NumericInstabilityException();
                }
            }

            @Override
            void checkPosition(Transform transform, double[] dArray) throws NumericInstabilityException {
                if (!transform.isInInteriorDomain(dArray, 0, dArray.length)) {
                    throw new NumericInstabilityException();
                }
            }

            @Override
            boolean checkPositionTransform() {
                return true;
            }
        }
        ,
        DEBUG("debug"){

            @Override
            void checkValue(double d) throws NumericInstabilityException {
                if (Double.isNaN(d)) {
                    System.err.println("Numerical instability in HMC momentum; throwing exception");
                    throw new NumericInstabilityException();
                }
            }

            @Override
            void checkPosition(Transform transform, double[] dArray) throws NumericInstabilityException {
                if (!transform.isInInteriorDomain(dArray, 0, dArray.length)) {
                    System.err.println("Numerical instability in HMC momentum; throwing exception");
                    throw new NumericInstabilityException();
                }
            }

            @Override
            boolean checkPositionTransform() {
                return true;
            }
        }
        ,
        IGNORE("ignore"){

            @Override
            void checkValue(double d) {
            }

            @Override
            void checkPosition(Transform transform, double[] dArray) throws NumericInstabilityException {
            }

            @Override
            boolean checkPositionTransform() {
                return false;
            }
        };

        private final String name;

        private InstabilityHandler(String string2) {
            this.name = string2;
        }

        public static InstabilityHandler factory(String string) {
            for (InstabilityHandler instabilityHandler : InstabilityHandler.values()) {
                if (!string.equalsIgnoreCase(instabilityHandler.name)) continue;
                return instabilityHandler;
            }
            return null;
        }

        abstract void checkValue(double var1) throws NumericInstabilityException;

        abstract void checkPosition(Transform var1, double[] var2) throws NumericInstabilityException;

        abstract boolean checkPositionTransform();
    }

    public static class NumericInstabilityException
    extends Exception {
    }
}

