/*
 * Decompiled with CFR 0.152.
 */
package dr.xml;

import dr.xml.XMLDocumentationHandler;
import dr.xml.XMLObject;
import dr.xml.XMLParseException;
import dr.xml.XMLSyntaxRule;
import java.util.Collections;
import java.util.Set;

public class AttributeRule
implements XMLSyntaxRule {
    private String name;
    private Class c;
    private boolean optional;
    private String description;

    AttributeRule() {
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public void setAttributeClass(Class clazz) {
        this.c = clazz;
    }

    public void setOptional(boolean bl) {
        this.optional = bl;
    }

    public boolean getOptional() {
        return this.optional;
    }

    private AttributeRule(String string, Class clazz) {
        this.name = string;
        this.c = clazz;
        this.optional = false;
    }

    private AttributeRule(String string, Class clazz, boolean bl) {
        this.name = string;
        this.c = clazz;
        this.optional = bl;
    }

    private AttributeRule(String string, Class clazz, boolean bl, String string2) {
        this.name = string;
        this.c = clazz;
        this.optional = bl;
        this.description = string2;
    }

    public static AttributeRule newIntegerRule(String string) {
        return new AttributeRule(string, Integer.class);
    }

    public static AttributeRule newLongIntegerRule(String string) {
        return new AttributeRule(string, Long.class);
    }

    public static AttributeRule newDoubleRule(String string) {
        return new AttributeRule(string, Double.class);
    }

    public static AttributeRule newDoubleArrayRule(String string) {
        return new AttributeRule(string, Double[].class);
    }

    public static AttributeRule newBooleanRule(String string) {
        return new AttributeRule(string, Boolean.class);
    }

    public static AttributeRule newStringRule(String string) {
        return new AttributeRule(string, String.class);
    }

    public static AttributeRule newStringArrayRule(String string) {
        return new AttributeRule(string, String[].class);
    }

    public static AttributeRule newIntegerRule(String string, boolean bl) {
        return new AttributeRule(string, Integer.class, bl);
    }

    public static AttributeRule newIntegerArrayRule(String string, boolean bl) {
        return new AttributeRule(string, Integer[].class, bl);
    }

    public static AttributeRule newLongIntegerRule(String string, boolean bl) {
        return new AttributeRule(string, Long.class, bl);
    }

    public static AttributeRule newDoubleRule(String string, boolean bl) {
        return new AttributeRule(string, Double.class, bl);
    }

    public static AttributeRule newDoubleArrayRule(String string, boolean bl) {
        return new AttributeRule(string, Double[].class, bl);
    }

    public static AttributeRule newBooleanRule(String string, boolean bl) {
        return new AttributeRule(string, Boolean.class, bl);
    }

    public static AttributeRule newStringRule(String string, boolean bl) {
        return new AttributeRule(string, String.class, bl);
    }

    public static AttributeRule newStringArrayRule(String string, boolean bl) {
        return new AttributeRule(string, String[].class, bl);
    }

    public static AttributeRule newIntegerRule(String string, boolean bl, String string2) {
        return new AttributeRule(string, Integer.class, bl, string2);
    }

    public static AttributeRule newLongIntegerRule(String string, boolean bl, String string2) {
        return new AttributeRule(string, Long.class, bl, string2);
    }

    public static AttributeRule newDoubleRule(String string, boolean bl, String string2) {
        return new AttributeRule(string, Double.class, bl, string2);
    }

    public static AttributeRule newDoubleArrayRule(String string, boolean bl, String string2) {
        return new AttributeRule(string, Double[].class, bl, string2);
    }

    public static AttributeRule newBooleanRule(String string, boolean bl, String string2) {
        return new AttributeRule(string, Boolean.class, bl, string2);
    }

    public static AttributeRule newStringRule(String string, boolean bl, String string2) {
        return new AttributeRule(string, String.class, bl, string2);
    }

    public static AttributeRule newStringArrayRule(String string, boolean bl, String string2) {
        return new AttributeRule(string, String[].class, bl, string2);
    }

    public String getName() {
        return this.name;
    }

    public Class getAttributeClass() {
        return this.c;
    }

    public String getDescription() {
        return this.description;
    }

    public Object getAttribute(XMLObject xMLObject) throws XMLParseException {
        return xMLObject.getAttribute(this.name);
    }

    public boolean hasDescription() {
        return this.description != null;
    }

    public boolean hasExample() {
        return false;
    }

    public String getExample() {
        return null;
    }

    @Override
    public boolean isSatisfied(XMLObject xMLObject) {
        if (xMLObject.hasAttribute(this.name)) {
            try {
                Object object = xMLObject.getAttribute(this.name);
                return this.isCompatible(object);
            }
            catch (XMLParseException xMLParseException) {
                return false;
            }
        }
        return this.optional;
    }

    @Override
    public boolean containsAttribute(String string) {
        return string.equals(this.getName());
    }

    @Override
    public String ruleString() {
        String string = "ATTRIBUTE " + this.getTypeName() + " " + this.name;
        string = this.optional ? string + " OPTIONAL" : string + " REQUIRED";
        return string;
    }

    @Override
    public String htmlRuleString(XMLDocumentationHandler xMLDocumentationHandler) {
        String string = "<div class=\"" + (this.optional ? "optional" : "required") + "rule\"> Attribute <span class=\"attrname\">" + this.name + "</span> is " + xMLDocumentationHandler.getHTMLForClass(this.c) + " " + (this.hasDescription() ? "<div class=\"description\">" + this.description + "</div>" : "") + "</div>";
        return string;
    }

    @Override
    public String wikiRuleString(XMLDocumentationHandler xMLDocumentationHandler, String string) {
        String string2 = string + "Attribute " + (this.optional ? "(optional) " : "") + "<code>" + this.name + "</code> is " + xMLDocumentationHandler.getHTMLForClass(this.c) + "\n" + string + ":" + (this.hasDescription() ? "\"" + this.description + "\"" : "") + "\n";
        return string2;
    }

    @Override
    public String markdownRuleString(XMLDocumentationHandler xMLDocumentationHandler, String string) {
        String string2 = string + "* <code>" + this.name + "</code> " + (this.optional ? "(optional)" : "") + " is of type " + xMLDocumentationHandler.getHTMLForClass(this.c) + "\n: " + (this.hasDescription() ? "\"" + this.description + "\"" : "") + "\n\n";
        return string2;
    }

    @Override
    public String ruleString(XMLObject xMLObject) {
        if (xMLObject.hasAttribute(this.name)) {
            try {
                Object object = xMLObject.getAttribute(this.name);
                boolean bl = this.isCompatible(object);
                if (bl) {
                    return this.ruleString();
                }
                return "ATTRIBUTE " + this.name + " expected to be of type " + this.getTypeName();
            }
            catch (XMLParseException xMLParseException) {
                return xMLParseException.toString();
            }
        }
        return this.ruleString();
    }

    @Override
    public Set<Class> getRequiredTypes() {
        return Collections.singleton(this.c);
    }

    @Override
    public boolean isLegalElementName(String string) {
        return false;
    }

    @Override
    public boolean isLegalElementClass(Class clazz) {
        return false;
    }

    @Override
    public boolean isLegalSubelementName(String string) {
        return false;
    }

    public boolean isAttributeRule() {
        return true;
    }

    private boolean isCompatible(Object object) {
        if (this.c == null) {
            return true;
        }
        if (this.c.isInstance(object)) {
            return true;
        }
        if (object instanceof String) {
            if (this.c == Double[].class) {
                return XMLObject.isDoubleArray((String)object, null);
            }
            if (this.c == Integer[].class) {
                return XMLObject.isIntegerArray((String)object, null);
            }
            if (this.c == String[].class) {
                return true;
            }
            if (this.c == Double.class) {
                try {
                    Double.parseDouble((String)object);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (this.c == Integer.class) {
                try {
                    Integer.parseInt((String)object);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (this.c == Long.class) {
                try {
                    Long.parseLong((String)object);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (this.c == Float.class) {
                try {
                    Float.parseFloat((String)object);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
            if (this.c == Boolean.class) {
                return object.equals("true") || object.equals("false");
            }
            if (this.c == Number.class) {
                try {
                    Double.parseDouble((String)object);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    return false;
                }
            }
        }
        return false;
    }

    private String getTypeName() {
        if (this.c == null) {
            return "Object";
        }
        String string = this.c.getName();
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        if (this.c.isArray()) {
            return "Array of " + string2;
        }
        return string2;
    }
}

