/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel._examples;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.math3.stat.descriptive.moment.StandardDeviation;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.DataRecord;
import org.vikamine.kernel.data.NominalAttribute;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.creators.DataFactory;
import org.vikamine.kernel.subgroup.SG;
import org.vikamine.kernel.subgroup.SGSet;
import org.vikamine.kernel.subgroup.quality.IQualityFunctionStatisticBased;
import org.vikamine.kernel.subgroup.quality.functions.DyadicWeightedLiftCompletedQF;
import org.vikamine.kernel.subgroup.search.MiningTask;
import org.vikamine.kernel.subgroup.search.SDMapNumeric;
import org.vikamine.kernel.subgroup.selectors.SGSelector;
import org.vikamine.kernel.subgroup.selectors.SGSelectorGeneratorFactory;
import org.vikamine.kernel.subgroup.selectors.SelectorGeneratorUtils;
import org.vikamine.kernel.subgroup.target.NumericTarget;
import org.vikamine.kernel.util.VKMUtil;

public class DyadicCompletedSimpleTaskRunnerExample {
    public static IQualityFunctionStatisticBased qualityFunction;

    private DyadicCompletedSimpleTaskRunnerExample() {
    }

    public static void main(String[] args) throws IOException {
        String filepath = "/Users/mat/Documents/mat-tmp/ds2018SI-ht2011-dyadic-data-aggregated-completed.arff";
        Ontology onto = DataFactory.createOntology(new File(filepath));
        System.out.println("DyadicSimpleTaskRunner");
        System.out.println("Filepath: " + filepath);
        System.out.println("Attributes in dataset: " + onto.getNumAttributes());
        System.out.println("Instances in dataset: " + onto.getNumInstances());
        DyadicCompletedSimpleTaskRunnerExample.runWeightAnalysis(onto);
    }

    private static double computeReferenceFromRandomSample(SG referenceSG, double sgMean) {
        int NTIMES = 10000;
        HashSet<String> nodes = new HashSet<String>();
        ArrayList<Double> edgeWeights = new ArrayList<Double>();
        for (DataRecord record : referenceSG.getPopulation()) {
            String valSrc = ((NominalAttribute)record.getDataset().getAttribute(0)).getNominalValue(record).getId();
            String valDst = ((NominalAttribute)record.getDataset().getAttribute(1)).getNominalValue(record).getId();
            nodes.add(valSrc);
            nodes.add(valDst);
            double weight = record.getValue(2);
            edgeWeights.add(weight);
        }
        int count = nodes.size();
        double allDyads = (double)count * (double)(count - 1) / 2.0;
        int missingWeights = (int)allDyads - edgeWeights.size();
        int i = 0;
        while (i < missingWeights) {
            edgeWeights.add(0.0);
            ++i;
        }
        int positiveWeightSubgroupSize = 0;
        HashSet<String> sgNodes = new HashSet<String>();
        for (DataRecord record : referenceSG) {
            String valSrc = ((NominalAttribute)record.getDataset().getAttribute(0)).getNominalValue(record).getId();
            String valDst = ((NominalAttribute)record.getDataset().getAttribute(1)).getNominalValue(record).getId();
            sgNodes.add(valSrc);
            sgNodes.add(valDst);
            double weight = record.getValue(2);
            if (!(weight > 0.0)) continue;
            ++positiveWeightSubgroupSize;
        }
        int ncount = sgNodes.size();
        double expectedDyads = VKMUtil.asList(referenceSG.iterator()).size();
        double mean = 0.0;
        double[] sampledMeans = new double[NTIMES];
        int i2 = 0;
        while (i2 < NTIMES) {
            ArrayList random = new ArrayList(edgeWeights);
            Collections.shuffle(random);
            double val = 0.0;
            int j = 0;
            while (j < positiveWeightSubgroupSize) {
                val += ((Double)random.get(j)).doubleValue();
                ++j;
            }
            sampledMeans[i2] = val /= expectedDyads;
            mean += val;
            ++i2;
        }
        StandardDeviation stddev = new StandardDeviation();
        double sampleStdDev = stddev.evaluate(sampledMeans);
        return (sgMean - (mean /= (double)NTIMES)) / (sampleStdDev + 1.0E-9);
    }

    public static void runWeightAnalysis(Ontology onto) {
        MiningTask task = new MiningTask(onto);
        task.setTarget(new NumericTarget(onto, "weight"));
        LinkedList<Attribute> attributes = new LinkedList<Attribute>(onto.getAttributes());
        attributes.remove(0);
        attributes.remove(0);
        attributes.remove(0);
        List<SGSelector> selectors = SelectorGeneratorUtils.generateSelectors(SGSelectorGeneratorFactory.createStandardGenerator(false), attributes, onto.getDataView());
        task.setSearchSpace(selectors);
        qualityFunction = new DyadicWeightedLiftCompletedQF();
        task.setQualityFunction(qualityFunction);
        task.setMethodType(SDMapNumeric.class);
        task.setMaxSGDSize(3);
        task.setMaxSGCount(200);
        SGSet result = task.performSubgroupDiscovery();
        System.out.println("\n\nWeighted Dyadic Analysis");
        System.out.println("Description\tSize\tLength\t ToNullModel (Z)");
        for (SG sg : result.toSortedList(false)) {
            double sgMean = qualityFunction.evaluate(sg.getStatistics());
            System.out.println(String.valueOf(SG.verbalizeSGDescriptionAsPrologLikeRuleBodyCSV(sg)) + "\t" + VKMUtil.formatDoubleToMinDigitsOrExponentialString(sg.getStatistics().getSubgroupSize(), 2) + "\t" + VKMUtil.formatDoubleToMinDigitsOrExponentialString(sgMean, 2) + "\t" + VKMUtil.formatDoubleToMinDigitsOrExponentialString(DyadicCompletedSimpleTaskRunnerExample.computeReferenceFromRandomSample(sg, sgMean), 2));
        }
        SG empty = new SG(onto.getDataView(), task.getTarget());
        empty.createStatistics();
        double emptyMean = qualityFunction.evaluate(empty.getStatistics());
        System.out.println("\nPopulation reference subgroup:");
        System.out.println(String.valueOf(SG.verbalizeSGDescriptionAsPrologLikeRuleBodyCSV(empty)) + "\t" + VKMUtil.formatDoubleToMinDigitsOrExponentialString(empty.getStatistics().getSubgroupSize(), 2) + "\t" + VKMUtil.formatDoubleToMinDigitsOrExponentialString(emptyMean, 2) + "\t" + VKMUtil.formatDoubleToMinDigitsOrExponentialString(DyadicCompletedSimpleTaskRunnerExample.computeReferenceFromRandomSample(empty, emptyMean), 2));
    }
}

