/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.persistence;

import java.text.ParseException;
import java.util.logging.Logger;
import org.vikamine.kernel.data.Attribute;
import org.vikamine.kernel.data.AttributeProvider;
import org.vikamine.kernel.data.Ontology;
import org.vikamine.kernel.data.Value;
import org.vikamine.kernel.formula.FormulaBoolean;
import org.vikamine.kernel.formula.FormulaBooleanElement;
import org.vikamine.kernel.formula.FormulaElement;
import org.vikamine.kernel.formula.FormulaNumber;
import org.vikamine.kernel.formula.FormulaNumberElement;
import org.vikamine.kernel.formula.constants.Fn;
import org.vikamine.kernel.formula.constants.FormulaAttributePrimitive;
import org.vikamine.kernel.formula.constants.FormulaAttributeValuePrimitive;
import org.vikamine.kernel.formula.constants.Fp;
import org.vikamine.kernel.formula.constants.Negatives;
import org.vikamine.kernel.formula.constants.PopulationSize;
import org.vikamine.kernel.formula.constants.Positives;
import org.vikamine.kernel.formula.constants.SubgroupSize;
import org.vikamine.kernel.formula.constants.Tn;
import org.vikamine.kernel.formula.constants.Tp;
import org.vikamine.kernel.formula.operators.AbstractAttributeArgumentTerm;
import org.vikamine.kernel.formula.operators.AbstractBooleanArgumentTerm;
import org.vikamine.kernel.formula.operators.AbstractNumberArgumentTerm;
import org.vikamine.kernel.formula.operators.AbstractTwoBooleanArgumentsTerm;
import org.vikamine.kernel.formula.operators.AbstractTwoNumberArgumentsTerm;
import org.vikamine.kernel.formula.operators.Add;
import org.vikamine.kernel.formula.operators.And;
import org.vikamine.kernel.formula.operators.Average;
import org.vikamine.kernel.formula.operators.Div;
import org.vikamine.kernel.formula.operators.EqualsNumber;
import org.vikamine.kernel.formula.operators.Greater;
import org.vikamine.kernel.formula.operators.GreaterEquals;
import org.vikamine.kernel.formula.operators.Lower;
import org.vikamine.kernel.formula.operators.LowerEquals;
import org.vikamine.kernel.formula.operators.MatchingAttributeValue;
import org.vikamine.kernel.formula.operators.Max;
import org.vikamine.kernel.formula.operators.MaxValue;
import org.vikamine.kernel.formula.operators.Min;
import org.vikamine.kernel.formula.operators.MinValue;
import org.vikamine.kernel.formula.operators.Mult;
import org.vikamine.kernel.formula.operators.Not;
import org.vikamine.kernel.formula.operators.Or;
import org.vikamine.kernel.formula.operators.Pow;
import org.vikamine.kernel.formula.operators.Sqrt;
import org.vikamine.kernel.formula.operators.Sub;
import org.vikamine.kernel.formula.operators.UnaryMinus;
import org.vikamine.kernel.formula.operators.Xor;
import org.vikamine.kernel.persistence.ValuesMarshaller;
import org.vikamine.kernel.util.DOMAccessor;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FormulaUnmarshaller {
    private Ontology ontology;

    public FormulaUnmarshaller(Ontology ontology) {
        this.ontology = ontology;
    }

    public FormulaElement unmarshal(Element elem, AttributeProvider attributeProvider) {
        FormulaElement op;
        String symb = elem.getAttribute("symbol");
        if ("fn".equals(symb)) {
            return new Fn();
        }
        if ("fp".equals(symb)) {
            return new Fp();
        }
        if ("negatives".equals(symb)) {
            return new Negatives();
        }
        if ("populationSize".equals(symb)) {
            return new PopulationSize();
        }
        if ("positives".equals(symb)) {
            return new Positives();
        }
        if ("subgroupSize".equals(symb)) {
            return new SubgroupSize();
        }
        if ("tn".equals(symb)) {
            return new Tn();
        }
        if ("tp".equals(symb)) {
            return new Tp();
        }
        if ("attribute".equals(symb)) {
            return this.createAttributePrimitive(elem, attributeProvider);
        }
        if ("attributeValue".equals(symb)) {
            return this.createAttributeValuePrimitive(elem, attributeProvider);
        }
        if ("number".equals(symb)) {
            return new FormulaNumber(new Double(elem.getAttribute("value")));
        }
        if ("boolean".equals(symb)) {
            boolean flag = Boolean.valueOf(elem.getAttribute("value"));
            return flag ? FormulaBoolean.TRUE : FormulaBoolean.FALSE;
        }
        if ("!".equals(symb)) {
            op = new Not();
        } else if ("&".equals(symb)) {
            op = new And();
        } else if ("|".equals(symb)) {
            op = new Or();
        } else if ("^".equals(symb)) {
            op = new Xor();
        } else if ("sqrt".equals(symb)) {
            op = new Sqrt();
        } else if ("unaryMinus".equals(symb)) {
            op = new UnaryMinus();
        } else if ("+".equals(symb)) {
            op = new Add();
        } else if ("/".equals(symb)) {
            op = new Div();
        } else if ("=".equals(symb)) {
            op = "true".equals(elem.getAttribute("attributeValue")) ? new MatchingAttributeValue() : new EqualsNumber();
        } else if (">".equals(symb)) {
            op = new Greater();
        } else if (">=".equals(symb)) {
            op = new GreaterEquals();
        } else if ("<".equals(symb)) {
            op = new Lower();
        } else if ("<=".equals(symb)) {
            op = new LowerEquals();
        } else if ("max".equals(symb)) {
            op = new Max();
        } else if ("min".equals(symb)) {
            op = new Min();
        } else if ("*".equals(symb)) {
            op = new Mult();
        } else if ("**".equals(symb)) {
            op = new Pow();
        } else if ("-".equals(symb)) {
            op = new Sub();
        } else if ("minValue".equals(symb)) {
            op = new MinValue();
        } else if ("maxValue".equals(symb)) {
            op = new MaxValue();
        } else if ("average".equals(symb)) {
            op = new Average();
        } else {
            throw new IllegalArgumentException("unknown symbol: " + symb);
        }
        this.fillOperator(op, elem, attributeProvider);
        return op;
    }

    private FormulaElement createAttributePrimitive(Element elem, AttributeProvider attributeProvider) {
        String attName = elem.getAttribute("attribute");
        Attribute att = attributeProvider.getAttribute(attName);
        return new FormulaAttributePrimitive(att);
    }

    private FormulaElement createAttributeValuePrimitive(Element elem, AttributeProvider attributeProvider) {
        Element valueElement = DOMAccessor.getFirstChildElement(elem, "attributeValue");
        Element valueContainingElement = DOMAccessor.getFirstChildElement(valueElement);
        try {
            Value value = new ValuesMarshaller().parseValueNode(attributeProvider, this.ontology, valueContainingElement);
            return new FormulaAttributeValuePrimitive(value);
        }
        catch (ParseException ex) {
            Logger.getLogger(this.getClass().getName()).throwing(this.getClass().getName(), "createAttributeValuePrimitive", ex);
            throw new IllegalStateException("Error in parsing the formula value ", ex);
        }
    }

    private void fillOperator(FormulaElement op, Element elem, AttributeProvider attributeProvider) {
        FormulaElement term;
        if (op instanceof AbstractAttributeArgumentTerm) {
            term = (AbstractAttributeArgumentTerm)op;
            ((AbstractAttributeArgumentTerm)term).setArg1((FormulaAttributePrimitive)this.getArgument("1", elem, attributeProvider));
        }
        if (op instanceof AbstractBooleanArgumentTerm) {
            term = (AbstractBooleanArgumentTerm)op;
            ((AbstractBooleanArgumentTerm)term).setArg1((FormulaBooleanElement)this.getArgument("1", elem, attributeProvider));
        }
        if (op instanceof AbstractTwoBooleanArgumentsTerm) {
            term = (AbstractTwoBooleanArgumentsTerm)op;
            ((AbstractTwoBooleanArgumentsTerm)term).setArg2((FormulaBooleanElement)this.getArgument("2", elem, attributeProvider));
        }
        if (op instanceof AbstractNumberArgumentTerm) {
            term = (AbstractNumberArgumentTerm)op;
            ((AbstractNumberArgumentTerm)term).setArg1((FormulaNumberElement)this.getArgument("1", elem, attributeProvider));
        }
        if (op instanceof AbstractTwoNumberArgumentsTerm) {
            term = (AbstractTwoNumberArgumentsTerm)op;
            ((AbstractTwoNumberArgumentsTerm)term).setArg2((FormulaNumberElement)this.getArgument("2", elem, attributeProvider));
        }
        if (op instanceof MatchingAttributeValue) {
            term = (MatchingAttributeValue)op;
            ((MatchingAttributeValue)term).setArg1((FormulaAttributePrimitive)this.getArgument("1", elem, attributeProvider));
            ((MatchingAttributeValue)term).setArg2((FormulaAttributeValuePrimitive)this.getArgument("2", elem, attributeProvider));
        }
    }

    private FormulaElement getArgument(String argIndex, Element elem, AttributeProvider attributeProvider) {
        NodeList args = elem.getChildNodes();
        int i = 0;
        while (i < args.getLength()) {
            Element childEl;
            String arg;
            Node child = args.item(i);
            if (child instanceof Element && "formula".equals(child.getNodeName()) && argIndex.equals(arg = (childEl = (Element)child).getAttribute("argIndex"))) {
                return this.unmarshal(childEl, attributeProvider);
            }
            ++i;
        }
        throw new RuntimeException("missing argument " + argIndex);
    }
}

