/*
 * Decompiled with CFR 0.152.
 */
package org.vikamine.kernel.util;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.rmi.server.UID;
import java.util.ResourceBundle;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class Logging {
    private static boolean initialized = false;
    private static final File TEMP_DIR = new File(System.getProperty("java.io.tmpdir"));
    private static final long TIME_DIFF = 604800000L;
    private static final String PREFIX = "_vikamine_";
    private static final String SUFFIX = ".log";
    private static final String LOCK = ".lck";
    private static String logFile = TEMP_DIR + File.separator + "_vikamine_" + new UID().toString().replaceAll("\\W", "_") + ".log";
    private static FileHandler fileHandler;
    private static Logger logger;
    public static final Level DEFAULT_CONSOLE_LEVEL;
    public static final Level DEFAULT_FILE_LEVEL;
    public static final int DEFAULT_CONSOLE_STACK_TRACE_LENGTH = 5;
    public static final int DEFAULT_FILE_STACK_TRACE_LENGTH = 1;
    private static String osVersion;
    private static String javaVersion;
    private static Level c_level;
    private static int c_stackTraceLength;
    private static Level f_level;
    private static int f_stackTraceLength;

    static {
        DEFAULT_CONSOLE_LEVEL = Level.FINEST;
        DEFAULT_FILE_LEVEL = Level.SEVERE;
        osVersion = String.valueOf(System.getProperty("os.name")) + " / " + System.getProperty("os.arch") + " / " + System.getProperty("os.version");
        javaVersion = System.getProperty("java.version");
        c_level = DEFAULT_CONSOLE_LEVEL;
        c_stackTraceLength = 5;
        f_level = DEFAULT_FILE_LEVEL;
        f_stackTraceLength = 1;
    }

    private static void deleteOldLogFiles() {
        FilenameFilter filter = new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.startsWith(Logging.PREFIX) && (name.endsWith(Logging.SUFFIX) || name.endsWith(".log.lck"));
            }
        };
        File[] files = TEMP_DIR.listFiles(filter);
        if (files == null) {
            return;
        }
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File file = fileArray[n2];
            if (System.currentTimeMillis() - file.lastModified() > 604800000L && !file.delete()) {
                Logger.getLogger(Logging.class.getName()).warning("Error while deleting log-File : " + file.toString());
            }
            ++n2;
        }
    }

    public static void init(String resbundlename) {
        if (!initialized) {
            logger = Logger.getLogger("org.vikamine");
            logger.setUseParentHandlers(false);
            logger.setLevel(Level.ALL);
            Logging.deleteOldLogFiles();
            ResourceBundle bundle = ResourceBundle.getBundle(resbundlename);
            c_level = Level.parse(bundle.getString("console.level"));
            c_stackTraceLength = Integer.parseInt(bundle.getString("console.stacktracelength"));
            f_level = Level.parse(bundle.getString("file.level"));
            f_stackTraceLength = Integer.parseInt(bundle.getString("file.stacktracelength"));
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setLevel(c_level);
            consoleHandler.setFormatter(new Formatter(c_stackTraceLength));
            logger.addHandler(consoleHandler);
            try {
                FileHandler fileHandler = Logging.getFileHandler();
                fileHandler.setLevel(f_level);
                fileHandler.setFormatter(new Formatter(f_stackTraceLength));
                logger.addHandler(fileHandler);
            }
            catch (SecurityException e) {
                Logger.getLogger(Logging.class.getName()).throwing(Logging.class.getName(), "init", e);
            }
            initialized = true;
        }
    }

    public static FileHandler getFileHandler() {
        if (fileHandler == null) {
            try {
                fileHandler = new FileHandler(logFile);
                fileHandler.setLevel(f_level);
                fileHandler.setFormatter(new Formatter(f_stackTraceLength));
            }
            catch (IOException e) {
                Logger.getLogger(Logging.class.getName()).throwing(Logging.class.getName(), "init", e);
            }
        }
        return fileHandler;
    }

    public static String getInitText() {
        return "++++++++++++++++ Logger for org.vikamine.* ++++++++++++++++\n  Operating System is " + osVersion + "\n" + "  Java Version is " + javaVersion + "\n" + "  Console.Level is " + c_level.getName() + "\n" + "  Console.StackTraceLength is " + c_stackTraceLength + "\n" + "  File.Level is " + f_level.getName() + "\n" + "  File.StackTraceLength is " + f_stackTraceLength + "\n" + "  File output set to: " + logFile + "\n" + "+++++++++++++++++++++++++++++++++++++++++++++++++++++++";
    }

    public static String getLoggingFilename() {
        return logFile;
    }

    private static class Formatter
    extends SimpleFormatter {
        private final int stackTraceLength;

        public Formatter(int stackTraceLength) {
            this.stackTraceLength = stackTraceLength;
        }

        @Override
        public synchronized String format(LogRecord record) {
            if (record.getThrown() != null) {
                StackTraceElement[] ste = record.getThrown().getStackTrace();
                int stackSize = Math.min(this.stackTraceLength, ste.length);
                StackTraceElement[] newSTE = new StackTraceElement[stackSize];
                int i = 0;
                while (i < stackSize) {
                    newSTE[i] = ste[i];
                    ++i;
                }
                record.getThrown().setStackTrace(newSTE);
            }
            return super.format(record);
        }
    }
}

