/*
 * Decompiled with CFR 0.152.
 */
package keel.Algorithms.Genetic_Rule_Learning.PSO_ACO;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;
import java.util.Vector;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Atributo;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.ComparadorParticulas;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Condicion;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.ConjuntoDatos;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Muestra;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Particula;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.Regla;
import keel.Algorithms.Genetic_Rule_Learning.PSO_ACO.myDataset;
import keel.Dataset.Attribute;
import keel.Dataset.Attributes;
import org.core.Randomize;

public class PsoAco {
    private Vector particulas;
    private ConjuntoDatos cTrain;
    private ConjuntoDatos cTrainC;
    private ConjuntoDatos cTest;
    private long semilla;
    private String fInTrain;
    private String fInTrainC;
    private String fInTest;
    private String fOutTrain;
    private String fOutTest;
    private String fOutResult;
    private String cabeceraTrain;
    private String cabeceraTest;
    private Vector listaCondicionesNominales;
    private Vector listaCondicionesVacias;
    private float[][] intervalos;
    private int numCondicionesContinuas;
    private float[][] heuristica;
    private Vector listaClases;
    private Vector reglasDescubiertas;
    private int maxCasosSinCubrir;
    private int numParticulas;
    private Randomize generadorA;
    private int tamEntorno;
    private int maxIteraciones;
    private int minimoCasosCubiertos;
    private float x;
    private float c1;
    private float c2;
    private boolean poblacionInicializada;
    private Regla generica;
    private float porcentajeTrain;
    private float porcentajeTest;
    private int bandera;

    public PsoAco() {
    }

    public PsoAco(String fTrainPrep, String fTrain, String fTestOriginal, String fSalidaTrain, String fSalidaTest, String fSalidaResult, long semillaOriginal, int maxCasosSinCubrirO, int numParticulasO, int tamEntornoO, int maxIteracionesO, int minimoCasosCubiertosO, float xO, float c1O, float c2O, int banderaO) {
        this.semilla = semillaOriginal;
        this.fInTrain = new String(fTrainPrep);
        this.fInTrainC = new String(fTrain);
        this.fInTest = new String(fTestOriginal);
        this.fOutTrain = new String(fSalidaTrain);
        this.fOutTest = new String(fSalidaTest);
        this.fOutResult = new String(fSalidaResult);
        this.cabeceraTest = new String("");
        this.cabeceraTrain = new String("");
        this.bandera = banderaO;
        this.generadorA = new Randomize();
        Randomize.setSeed(this.semilla);
        this.listaCondicionesNominales = new Vector();
        this.listaCondicionesVacias = new Vector();
        this.listaClases = new Vector();
        this.reglasDescubiertas = new Vector();
        this.maxCasosSinCubrir = maxCasosSinCubrirO;
        this.numParticulas = numParticulasO;
        this.tamEntorno = tamEntornoO;
        this.maxIteraciones = maxIteracionesO;
        this.minimoCasosCubiertos = minimoCasosCubiertosO;
        this.x = xO;
        this.c1 = c1O;
        this.c2 = c2O;
        this.poblacionInicializada = false;
        this.extraeDatos();
    }

    private void extraeDatos() {
        myDataset dTrain = new myDataset();
        myDataset dTrainC = new myDataset();
        myDataset dTest = new myDataset();
        try {
            dTrain.readClassificationSet(this.fInTrain, true);
            dTrainC.readClassificationSet(this.fInTrainC, false);
            dTest.readClassificationSet(this.fInTest, false);
        }
        catch (IOException e) {
            System.err.println("There was a problem while reading the input data-sets:");
            System.err.println("-> " + e);
            System.exit(0);
        }
        this.creaDatos();
        this.cTrain = this.extraeMuestras(dTrain);
        this.cTrainC = this.extraeMuestras(dTrainC);
        this.cTest = this.extraeMuestras(dTest);
        this.cabeceraTrain = dTrainC.copyHeader();
        this.cabeceraTest = dTest.copyHeader();
    }

    private void creaDatos() {
        Atributo insertar;
        Vector nombres;
        Attribute actual;
        int i;
        int RealesInsertados = 0;
        Attribute[] listaAtributos = Attributes.getInputAttributes();
        this.intervalos = new float[Attributes.getNumAttributes() * 2][];
        for (i = 0; i < Attributes.getNumAttributes() * 2; ++i) {
            this.intervalos[i] = new float[3];
        }
        block8: for (i = 0; i < listaAtributos.length; ++i) {
            Vector<Atributo> valores = new Vector<Atributo>();
            actual = listaAtributos[i];
            switch (this.bandera) {
                case 1: {
                    Condicion insertarCon;
                    int j;
                    System.out.println("Atributos Nominales1");
                    Vector<Condicion> condicionesIgual = new Vector<Condicion>();
                    valores = new Vector();
                    nombres = actual.getNominalValuesList();
                    condicionesIgual = new Vector();
                    for (j = 0; j < nombres.size(); ++j) {
                        insertar = new Atributo(j, i, 1);
                        insertarCon = new Condicion(insertar, 0);
                        condicionesIgual.addElement(insertarCon);
                        valores.addElement(insertar);
                    }
                    this.listaCondicionesNominales.addElement(condicionesIgual);
                    Atributo atributoVacio = new Atributo(-1.0f, i, 1);
                    Condicion vacia = new Condicion(atributoVacio, 0);
                    this.listaCondicionesVacias.addElement(vacia);
                    this.numCondicionesContinuas = 0;
                    continue block8;
                }
                case 2: {
                    System.out.println("Atributos continuos2");
                    nombres = actual.getNominalValuesList();
                    this.intervalos[RealesInsertados][0] = 0.0f;
                    this.intervalos[RealesInsertados][1] = nombres.size() - 1;
                    this.intervalos[RealesInsertados][2] = i;
                    ++RealesInsertados;
                    continue block8;
                }
                case 3: {
                    Condicion insertarCon;
                    int j;
                    if (i < listaAtributos.length / 2) {
                        System.out.println("Atributos continuos3");
                        nombres = actual.getNominalValuesList();
                        this.intervalos[RealesInsertados][0] = 0.0f;
                        this.intervalos[RealesInsertados][1] = nombres.size() - 1;
                        this.intervalos[RealesInsertados][2] = i;
                        ++RealesInsertados;
                        continue block8;
                    }
                    System.out.println("Atributos Nominales3");
                    Vector<Condicion> condicionesIgual = new Vector();
                    valores = new Vector();
                    nombres = actual.getNominalValuesList();
                    condicionesIgual = new Vector();
                    for (j = 0; j < nombres.size(); ++j) {
                        insertar = new Atributo(j, i, 1);
                        insertarCon = new Condicion(insertar, 0);
                        condicionesIgual.addElement(insertarCon);
                        valores.addElement(insertar);
                    }
                    this.listaCondicionesNominales.addElement(condicionesIgual);
                    Atributo atributoVacio = new Atributo(-1.0f, i, 1);
                    Condicion vacia = new Condicion(atributoVacio, 0);
                    this.listaCondicionesVacias.addElement(vacia);
                    continue block8;
                }
                case 4: {
                    Condicion insertarCon;
                    int j;
                    if (i >= listaAtributos.length / 2) {
                        System.out.println("Atributos continuos4");
                        nombres = actual.getNominalValuesList();
                        this.intervalos[RealesInsertados][0] = 0.0f;
                        this.intervalos[RealesInsertados][1] = nombres.size() - 1;
                        this.intervalos[RealesInsertados][2] = i;
                        ++RealesInsertados;
                        continue block8;
                    }
                    System.out.println("Atributos Nominales4");
                    Vector<Condicion> condicionesIgual = new Vector();
                    valores = new Vector();
                    nombres = actual.getNominalValuesList();
                    condicionesIgual = new Vector();
                    for (j = 0; j < nombres.size(); ++j) {
                        insertar = new Atributo(j, i, 1);
                        insertarCon = new Condicion(insertar, 0);
                        condicionesIgual.addElement(insertarCon);
                        valores.addElement(insertar);
                    }
                    this.listaCondicionesNominales.addElement(condicionesIgual);
                    Atributo atributoVacio = new Atributo(-1.0f, i, 1);
                    Condicion vacia = new Condicion(atributoVacio, 0);
                    this.listaCondicionesVacias.addElement(vacia);
                    continue block8;
                }
                case 10: {
                    System.out.println("Atributos Reales");
                    float Rmin = (float)actual.getMinAttribute();
                    float Rmax = (float)actual.getMaxAttribute();
                    this.intervalos[RealesInsertados][0] = Rmin;
                    this.intervalos[RealesInsertados][1] = Rmax;
                    this.intervalos[RealesInsertados][2] = i;
                    ++RealesInsertados;
                    continue block8;
                }
                default: {
                    Condicion insertarCon;
                    int j;
                    System.out.println("Atributos NominalesD");
                    Vector<Condicion> condicionesIgual = new Vector();
                    valores = new Vector();
                    nombres = actual.getNominalValuesList();
                    condicionesIgual = new Vector();
                    for (j = 0; j < nombres.size(); ++j) {
                        insertar = new Atributo(j, i, 1);
                        insertarCon = new Condicion(insertar, 0);
                        condicionesIgual.addElement(insertarCon);
                        valores.addElement(insertar);
                    }
                    this.listaCondicionesNominales.addElement(condicionesIgual);
                    Atributo atributoVacio = new Atributo(-1.0f, i, 1);
                    Condicion vacia = new Condicion(atributoVacio, 0);
                    this.listaCondicionesVacias.addElement(vacia);
                }
            }
        }
        actual = Attributes.getOutputAttribute(0);
        nombres = actual.getNominalValuesList();
        for (i = 0; i < nombres.size(); ++i) {
            insertar = new Atributo(i, -1, 1);
            this.listaClases.addElement(insertar);
        }
        this.numCondicionesContinuas = RealesInsertados * 2;
        this.heuristica = new float[this.listaCondicionesNominales.size()][];
        for (int i2 = 0; i2 < this.listaCondicionesNominales.size(); ++i2) {
            Vector condiciones = (Vector)this.listaCondicionesNominales.get(i2);
            this.heuristica[i2] = new float[condiciones.size() + 1];
        }
    }

    private ConjuntoDatos extraeMuestras(myDataset original) {
        Vector<Muestra> muestras = new Vector<Muestra>();
        double[][] X = original.getX();
        int[] C = original.getC();
        int nDatos = original.getndatos();
        int nAtributos = original.getnentradas();
        Attribute[] atv = Attributes.getInputAttributes();
        muestras = new Vector();
        for (int i = 0; i < nDatos; ++i) {
            Atributo at;
            Muestra mt = new Muestra();
            for (int j = 0; j < nAtributos; ++j) {
                at = X[i][j] == -1.0 ? new Atributo(-1.0f, 0, 0) : new Atributo((float)X[i][j], 0, 0);
                mt.insertarAtributo(at);
            }
            at = (Atributo)this.listaClases.get(C[i]);
            mt.insertaPosicion(i);
            mt.insertarClase(at);
            muestras.addElement(mt);
        }
        ConjuntoDatos devolver = new ConjuntoDatos(muestras);
        return devolver;
    }

    private Atributo elegirClaseAsignar() {
        double probabilidadAcumulada = 0.0;
        Atributo clase = null;
        int i = 0;
        PsoAco psoAco = this;
        double probabilidadEscoger = psoAco.generadorA.Rand();
        while (probabilidadAcumulada < probabilidadEscoger) {
            clase = (Atributo)this.listaClases.get(i);
            probabilidadAcumulada += (double)this.cTrain.porcentajeMuestrasClase(clase);
            ++i;
        }
        return clase;
    }

    private Condicion escogeRuletaCondicion(int index) {
        Vector condiciones = (Vector)this.listaCondicionesNominales.get(index);
        PsoAco psoAco = this;
        double aleatorio = psoAco.generadorA.Rand();
        double acumulado = 0.0;
        double porcentaje = 0.9 / (double)condiciones.size();
        int contador = -1;
        while (acumulado < aleatorio) {
            acumulado += porcentaje;
            ++contador;
        }
        Condicion devolver = contador >= condiciones.size() ? (Condicion)this.listaCondicionesVacias.get(index) : (Condicion)condiciones.get(contador);
        return devolver;
    }

    private void inicializaPosicion(Vector pos, Atributo clase) {
        int numCondiciones = this.listaCondicionesNominales.size();
        for (int i = 0; i < numCondiciones; ++i) {
            Condicion insertar = this.escogeRuletaCondicion(i);
            pos.addElement(insertar);
        }
        this.podaRegla(pos, clase);
    }

    private float calculaCalidad(Regla regla) {
        float calidad = 0.0f;
        float TP = 0.0f;
        float TN = 0.0f;
        float FP = 0.0f;
        float FN = 0.0f;
        float k = this.listaClases.size();
        Atributo clasePredicha = regla.obtenerReglaPredicha();
        for (int i = 0; i < this.cTrain.tamanio(); ++i) {
            Muestra mt = this.cTrain.obtenerMuestra(i);
            Atributo claseReal = mt.getClase();
            if (regla.estanCondicionesEn(mt)) {
                if (claseReal.esIgual(clasePredicha)) {
                    TP += 1.0f;
                    continue;
                }
                FP += 1.0f;
                continue;
            }
            if (claseReal.esIgual(clasePredicha)) {
                FN += 1.0f;
                continue;
            }
            TN += 1.0f;
        }
        calidad = TP < 10.0f ? 0.0f : 1.0f + TP / (1.0f + k + TP + FP);
        if (TP == 0.0f || TP + FN == 0.0f || TN == 0.0f || TN + FP == 0.0f) {
            calidad = 0.0f;
        }
        return calidad;
    }

    private void podaRegla(Vector regla, Atributo clase) {
        int tamanio = regla.size();
        boolean parada = false;
        int numAtributosReglas = regla.size();
        Vector original = new Vector(regla);
        for (int vueltas = 0; !parada && vueltas < numAtributosReglas; ++vueltas) {
            Vector subregla;
            int i;
            Vector<Vector> subReglas = new Vector<Vector>();
            for (i = 0; i < numAtributosReglas; ++i) {
                subregla = new Vector(original);
                Condicion vacia = (Condicion)this.listaCondicionesVacias.get(i);
                subregla.set(i, vacia);
                subReglas.addElement(subregla);
            }
            float confidenciaOriginal = this.calculaConfidencia(regla, clase);
            int mejor = -1;
            for (i = 0; i < numAtributosReglas; ++i) {
                subregla = (Vector)subReglas.get(i);
                float confidenciaSubRegla = this.calculaConfidencia(subregla, clase);
                if (!(confidenciaSubRegla >= confidenciaOriginal)) continue;
                mejor = i;
            }
            if (mejor == -1) {
                parada = true;
                continue;
            }
            subregla = (Vector)subReglas.get(mejor);
            original = new Vector(subregla);
        }
        regla = new Vector(original);
    }

    private void podaReglaContinua(Vector regla, Atributo clase) {
        int tamanio = regla.size();
        boolean parada = false;
        int numAtributosReglas = regla.size();
        Vector original = new Vector(regla);
        for (int vueltas = 0; !parada && vueltas < numAtributosReglas; ++vueltas) {
            Vector subregla;
            int i;
            Vector<Vector> subReglas = new Vector<Vector>();
            for (i = 0; i < numAtributosReglas; ++i) {
                subregla = new Vector(original);
                Condicion vacia = (Condicion)subregla.get(i);
                int atributo = vacia.getIndice();
                if (vacia.getOperador() == 1) {
                    vacia.setValor(this.intervalos[atributo][1]);
                } else {
                    vacia.setValor(this.intervalos[atributo][0]);
                }
                subregla.set(i, vacia);
                subReglas.addElement(subregla);
            }
            float confidenciaOriginal = this.calculaConfidencia(regla, clase);
            int mejor = -1;
            for (i = 0; i < numAtributosReglas; ++i) {
                subregla = (Vector)subReglas.get(i);
                float confidenciaSubRegla = this.calculaConfidencia(subregla, clase);
                if (!(confidenciaSubRegla >= confidenciaOriginal)) continue;
                mejor = i;
            }
            if (mejor == -1) {
                parada = true;
                continue;
            }
            subregla = (Vector)subReglas.get(mejor);
            original = new Vector(subregla);
        }
        regla = new Vector(original);
    }

    private float calculaConfidencia(Vector condiciones, Atributo clase) {
        float calidad = 0.0f;
        boolean cubierta = false;
        float tamanio = 0.0f;
        float cubiertas = 0.0f;
        Regla hormiga = new Regla(new Vector(), condiciones, clase);
        for (int i = 0; i < this.cTrain.tamanio(); ++i) {
            Muestra mt = this.cTrain.obtenerMuestra(i);
            if (!hormiga.estanCondicionesEn(mt)) continue;
            tamanio += 1.0f;
            if (!hormiga.obtenerReglaPredicha().esIgual(mt.getClase())) continue;
            cubiertas += 1.0f;
        }
        if (cubiertas == 0.0f || tamanio == 0.0f) {
            return 0.0f;
        }
        calidad = cubiertas / tamanio;
        return calidad;
    }

    private Vector PSOACO(Vector particulas) {
        int numeroMuestrasCubiertas;
        float calidad;
        Regla regla;
        Particula p;
        int i;
        System.out.println("Executing PSO-ACO");
        Atributo claseAsignar = this.elegirClaseAsignar();
        this.calculaHeuristicasCondiciones(claseAsignar);
        int numeroIteraciones = 0;
        int numCondiciones = this.listaCondicionesNominales.size();
        for (i = 0; i < this.numParticulas; ++i) {
            p = new Particula(numCondiciones);
            p.inicializaFeromona(this.listaCondicionesNominales);
            Vector posicion = new Vector();
            this.inicializaPosicion(posicion, claseAsignar);
            p.inicializaPosicionActualNominal(posicion);
            p.inicializaMejorPosicionNominal(posicion);
            p.asignarClasePosicionActual(claseAsignar);
            p.asignarClasePosicionMejor(claseAsignar);
            regla = p.getPosActual();
            calidad = this.calculaCalidad(regla);
            numeroMuestrasCubiertas = this.cTrain.numeroMuestrasCubiertasSinClase(regla);
            p.asignarCalidadMPosicion(calidad);
            p.asignarMuestrasCubiertasActual(numeroMuestrasCubiertas);
            p.asignarMuestrasCubiertasPasado(numeroMuestrasCubiertas);
            p.asignarCalidadPosActual(calidad);
            particulas.addElement(p);
        }
        System.out.println("Poblacion inicializada");
        for (i = 0; i < numeroIteraciones; ++i) {
            p = (Particula)particulas.get(i);
            p.actualizaFeromona(particulas, i, this.tamEntorno, this.listaCondicionesNominales);
        }
        System.out.println("Comienzo de la busqueda");
        for (int it = 0; it < this.maxIteraciones; ++it) {
            int i2;
            for (i2 = 0; i2 < this.numParticulas; ++i2) {
                p = (Particula)particulas.get(i2);
                p.generaPosicion(this.listaCondicionesNominales, this.listaCondicionesVacias, this.minimoCasosCubiertos, this.cTrain, this.generadorA, this.heuristica);
                regla = p.getPosActual();
                calidad = this.calculaCalidad(regla);
                numeroMuestrasCubiertas = this.cTrain.numeroMuestrasCubiertasSinClase(regla);
                p.asignarMuestrasCubiertasActual(numeroMuestrasCubiertas);
                p.asignarCalidadPosActual(calidad);
                float calidadPasado = p.obtenerCalidadMejorPosicion();
                if (!(calidad > calidadPasado)) continue;
                p.copiaPosicionMejorPosicion();
            }
            for (i2 = 0; i2 < numeroIteraciones; ++i2) {
                p = (Particula)particulas.get(i2);
                p.actualizaFeromona(particulas, i2, this.tamEntorno, this.listaCondicionesNominales);
            }
        }
        return particulas;
    }

    private Vector generaPosicionContinua(Atributo clase) {
        Condicion coMin;
        Condicion coMax;
        Atributo at;
        int indice;
        float maximo;
        float minimo;
        Vector<Condicion> devolver = new Vector<Condicion>();
        Regla rule = new Regla(new Vector(), new Vector(), clase);
        for (int i = 0; this.cTrain.cubreMinimo(rule, this.minimoCasosCubiertos) && i < this.numCondicionesContinuas / 2; ++i) {
            float aleatoreo;
            minimo = this.intervalos[i][0];
            maximo = this.intervalos[i][1];
            indice = (int)this.intervalos[i][2];
            float velocidad = aleatoreo = (float)Randomize.Randdouble(minimo, maximo);
            at = new Atributo(velocidad, indice, 0);
            coMax = new Condicion(at, 2);
            velocidad = aleatoreo = (float)Randomize.Randdouble(velocidad, maximo);
            at = new Atributo(velocidad, indice, 0);
            coMin = new Condicion(at, 1);
            devolver.addElement(coMax);
            devolver.addElement(coMin);
            rule.insertarCondicionContinua(coMax);
            rule.insertarCondicionContinua(coMin);
        }
        for (int j = i; j < this.numCondicionesContinuas / 2; ++j) {
            minimo = this.intervalos[j][0];
            maximo = this.intervalos[j][1];
            indice = (int)this.intervalos[j][2];
            at = new Atributo(minimo, indice, 0);
            coMax = new Condicion(at, 2);
            at = new Atributo(maximo, indice, 0);
            coMin = new Condicion(at, 1);
            devolver.addElement(coMax);
            devolver.addElement(coMin);
        }
        return devolver;
    }

    private Vector psoNormal(Vector particulas) {
        int numeroMuestrasCubiertas;
        float calidad;
        Particula p;
        int i;
        int numParticulas = particulas.size();
        for (i = 0; i < numParticulas; ++i) {
            p = (Particula)particulas.get(i);
            Atributo clase = p.getPosActual().obtenerReglaPredicha();
            Vector condicionesContinuas = this.generaPosicionContinua(clase);
            p.reservaVelocidad(this.numCondicionesContinuas);
            p.inicializaPosicionActualContinua(condicionesContinuas);
            p.inicializaMejorPosicionContinua(condicionesContinuas);
            Regla regla = p.getPosActual();
            calidad = this.calculaCalidad(regla);
            numeroMuestrasCubiertas = this.cTrain.numeroMuestrasCubiertasSinClase(regla);
            p.asignarMuestrasCubiertasActual(numeroMuestrasCubiertas);
            p.asignarMuestrasCubiertasPasado(numeroMuestrasCubiertas);
            p.asignarCalidadMPosicion(calidad);
            p.asignarCalidadPosActual(calidad);
            p.inicializaVelocidad(this.intervalos, this.numCondicionesContinuas, this.generadorA);
        }
        for (i = 0; i < this.maxIteraciones; ++i) {
            for (int j = 0; j < numParticulas; ++j) {
                float calidadAnterior;
                p = (Particula)particulas.get(j);
                calidad = p.obtenerCalidadPosicionActual();
                if (calidad > (calidadAnterior = p.obtenerCalidadMejorPosicion())) {
                    p.copiaPosicionMejorPosicion();
                }
                p.calculaVelocidad(this.numCondicionesContinuas, particulas, this.tamEntorno, j, this.intervalos, this.x, this.c1, this.c2, this.generadorA);
                p.moverParticula(this.numCondicionesContinuas, this.intervalos);
                calidad = this.calculaCalidad(p.getPosActual());
                numeroMuestrasCubiertas = this.cTrain.numeroMuestrasCubiertasSinClase(p.getPosActual());
                p.asignarMuestrasCubiertasActual(numeroMuestrasCubiertas);
                p.asignarCalidadPosActual(calidad);
            }
        }
        return particulas;
    }

    private void calculaHeuristicasCondiciones(Atributo clase) {
        float porcentaje = 0.0f;
        for (int i = 0; i < this.listaCondicionesNominales.size(); ++i) {
            Vector condiciones = (Vector)this.listaCondicionesNominales.get(i);
            float sumatoria = 0.0f;
            for (int j = 0; j < condiciones.size(); ++j) {
                Condicion co = (Condicion)condiciones.get(j);
                this.heuristica[i][j] = porcentaje = this.cTrain.porcentajeMuestrasCondicion(co, clase);
                sumatoria += porcentaje;
            }
            this.heuristica[i][condiciones.size()] = this.cTrain.porcentajeMuestrasClase(clase);
        }
    }

    public Regla creaReglaGenerica() {
        int mayor = this.cTrain.obtenerMayorClase(this.listaClases);
        Atributo clase = (Atributo)this.listaClases.get(mayor);
        Regla devolver = new Regla(new Vector(), new Vector(), clase);
        return devolver;
    }

    private void podaParticulaActual(Particula p) {
        Regla condiciones = p.getPosActual();
        Vector nominales = condiciones.listaCondicionesNominales();
        Atributo clase = condiciones.obtenerReglaPredicha();
        this.podaRegla(nominales, clase);
        condiciones.insertaCondicionesNominales(nominales);
    }

    private void podaParticulaPasada(Particula p) {
        Regla condiciones = p.getMejorPosicion();
        Vector nominales = condiciones.listaCondicionesNominales();
        Atributo clase = condiciones.obtenerReglaPredicha();
        this.podaRegla(nominales, clase);
        condiciones.insertaCondicionesNominales(nominales);
    }

    public void run() {
        int iteraciones = 0;
        Vector particulas = new Vector();
        Vector<Regla> particulasDescubiertas = new Vector<Regla>();
        Particula p = new Particula();
        ComparadorParticulas c = p.getComparadorParticulas();
        for (int i = 0; i < this.numCondicionesContinuas; ++i) {
            System.out.println(this.intervalos[i][0] + "  " + this.intervalos[i][1]);
        }
        while (this.cTrain.tamanio() > this.maxCasosSinCubrir) {
            particulas = new Vector();
            ++iteraciones;
            particulas = this.PSOACO(particulas);
            System.out.println("PASOACO");
            particulas = this.psoNormal(particulas);
            System.out.println("PSONormal");
            Collections.sort(particulas, c);
            p = (Particula)particulas.get(0);
            this.podaParticulaActual(p);
            this.podaParticulaPasada(p);
            float calidad1 = this.calculaCalidad(p.getPosActual());
            float calidad2 = this.calculaCalidad(p.getMejorPosicion());
            Regla regla = calidad2 > calidad1 ? p.getMejorPosicion() : p.getPosActual();
            regla.imprime(this.numCondicionesContinuas);
            System.out.println("Quedan " + this.cTrain.tamanio());
            int tamanioAntes = this.cTrain.tamanio();
            this.cTrain.eliminaMuestrasCubiertas(regla);
            int tamanioDespues = this.cTrain.tamanio();
            if (tamanioDespues >= tamanioAntes) continue;
            particulasDescubiertas.addElement(regla);
        }
        this.generica = this.creaReglaGenerica();
        this.sacaResultadosAFicheros(particulasDescubiertas);
        this.imprimeReglasDescubiertas(particulasDescubiertas);
    }

    private void imprimeReglasDescubiertas(Vector reglas) {
        Atributo claseReal;
        int numRegla;
        Atributo clasePrediccion;
        Muestra mt;
        Regla regla;
        PrintStream salida = null;
        try {
            File fichero = new File(this.fOutResult);
            FileOutputStream flujo = new FileOutputStream(fichero);
            salida = new PrintStream(flujo);
        }
        catch (FileNotFoundException e) {
            System.err.println("El fichero " + this.fOutResult + " no se pudo crear");
            System.exit(0);
        }
        salida.println("Reglas: ");
        for (int i = 0; i < reglas.size(); ++i) {
            regla = (Regla)reglas.get(i);
            regla.imprime(this.numCondicionesContinuas);
            regla.imprimeFichero(this.numCondicionesContinuas, salida);
        }
        Atributo claseGenerica = this.generica.obtenerReglaPredicha();
        Attribute[] listaAtributos = Attributes.getInputAttributes();
        listaAtributos = Attributes.getOutputAttributes();
        Attribute actual = listaAtributos[0];
        Vector nombresClases = actual.getNominalValuesList();
        String nombre = (String)nombresClases.get((int)claseGenerica.getValor());
        claseGenerica.imprime("Generica ==> " + nombre);
        salida.println("Generica ==> " + nombre);
        float tamTrain = this.cTrainC.tamanio();
        float acertadas = 0.0f;
        int i = 0;
        while ((float)i < tamTrain) {
            mt = this.cTrainC.obtenerMuestra(i);
            clasePrediccion = null;
            for (numRegla = 0; clasePrediccion == null && numRegla < reglas.size(); ++numRegla) {
                regla = (Regla)reglas.get(numRegla);
                clasePrediccion = regla.prediccion(mt);
            }
            if (clasePrediccion == null) {
                clasePrediccion = this.generica.obtenerReglaPredicha();
            }
            if (clasePrediccion.esIgual(claseReal = mt.getClase())) {
                acertadas += 1.0f;
            }
            ++i;
        }
        float accuracyTrain = acertadas / tamTrain;
        float tamTest = this.cTest.tamanio();
        acertadas = 0.0f;
        i = 0;
        while ((float)i < tamTest) {
            mt = this.cTest.obtenerMuestra(i);
            clasePrediccion = null;
            for (numRegla = 0; clasePrediccion == null && numRegla < reglas.size(); ++numRegla) {
                regla = (Regla)reglas.get(numRegla);
                clasePrediccion = regla.prediccion(mt);
            }
            if (clasePrediccion == null) {
                clasePrediccion = this.generica.obtenerReglaPredicha();
            }
            if (clasePrediccion.esIgual(claseReal = mt.getClase())) {
                acertadas += 1.0f;
            }
            ++i;
        }
        float accuracyTest = acertadas / tamTest;
        System.out.println("Accuracy Train " + accuracyTrain);
        salida.println("Accuracy Train " + accuracyTrain);
        System.out.println("Accuracy Test " + accuracyTest);
        salida.println("Accuracy Test " + accuracyTest);
    }

    private void imprimeVector(Vector total) {
        for (int i = 0; i < total.size(); ++i) {
            Vector condiciones = (Vector)total.get(i);
            for (int j = 0; j < condiciones.size(); ++j) {
                Condicion co = (Condicion)condiciones.get(j);
                co.imprime();
            }
            System.out.println("**********************************************************");
        }
    }

    public void sacaResultadosAFicheros(Vector reglasDescubiertas) {
        Atributo claseOriginal;
        Regla regla;
        int j;
        Muestra mt;
        int i;
        int tamanioConjunto;
        int tamanioReglas;
        PrintStream salida;
        FileOutputStream flujo;
        File fichero;
        Atributo clasePredicha = null;
        boolean terminado = false;
        boolean numRegla = false;
        this.porcentajeTrain = 0.0f;
        this.porcentajeTest = 0.0f;
        Attribute[] listaAtributos = Attributes.getInputAttributes();
        listaAtributos = Attributes.getOutputAttributes();
        Attribute actual = listaAtributos[0];
        Vector nombresClases = actual.getNominalValuesList();
        try {
            fichero = new File(this.fOutTrain);
            flujo = new FileOutputStream(fichero);
            salida = new PrintStream(flujo);
            salida.print(this.cabeceraTrain);
            tamanioReglas = reglasDescubiertas.size();
            tamanioConjunto = this.cTrainC.tamanio();
            for (i = 0; i < tamanioConjunto; ++i) {
                mt = this.cTrainC.obtenerMuestra(i);
                terminado = false;
                for (j = 0; j < tamanioReglas && !terminado; ++j) {
                    regla = (Regla)reglasDescubiertas.get(j);
                    clasePredicha = regla.prediccion(mt);
                    if (clasePredicha == null) continue;
                    terminado = true;
                }
                claseOriginal = mt.getClase();
                salida.print((String)nombresClases.get((int)claseOriginal.getValor()) + " ");
                if (clasePredicha == null) {
                    clasePredicha = this.generica.obtenerReglaPredicha();
                }
                salida.println((String)nombresClases.get((int)clasePredicha.getValor()));
                if (!claseOriginal.equals(clasePredicha)) continue;
                this.porcentajeTrain += 1.0f;
            }
            this.porcentajeTrain /= (float)tamanioConjunto;
        }
        catch (FileNotFoundException e) {
            System.err.println("El fichero " + this.fOutTrain + " no se pudo crear");
            System.exit(0);
        }
        try {
            fichero = new File(this.fOutTest);
            flujo = new FileOutputStream(fichero);
            salida = new PrintStream(flujo);
            salida.print(this.cabeceraTest);
            tamanioReglas = reglasDescubiertas.size();
            tamanioConjunto = this.cTest.tamanio();
            for (i = 0; i < tamanioConjunto; ++i) {
                mt = this.cTest.obtenerMuestra(i);
                terminado = false;
                for (j = 0; j < tamanioReglas && !terminado; ++j) {
                    regla = (Regla)reglasDescubiertas.get(j);
                    clasePredicha = regla.prediccion(mt);
                    if (clasePredicha == null) continue;
                    terminado = true;
                }
                claseOriginal = mt.getClase();
                salida.print((String)nombresClases.get((int)claseOriginal.getValor()) + " ");
                if (clasePredicha == null) {
                    clasePredicha = this.generica.obtenerReglaPredicha();
                }
                salida.println((String)nombresClases.get((int)clasePredicha.getValor()));
                if (!clasePredicha.equals(claseOriginal)) continue;
                this.porcentajeTest += 1.0f;
            }
            this.porcentajeTest /= (float)tamanioConjunto;
        }
        catch (FileNotFoundException e) {
            System.err.println("El fichero " + this.fOutTest + " no se pudo crear");
            System.exit(0);
        }
    }
}

