/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jclec.base;

import java.util.ArrayList;
import java.util.List;
import net.sf.jclec.IIndividual;
import net.sf.jclec.ISystem;
import net.sf.jclec.base.DecoratedRecombinator;
import net.sf.jclec.util.random.IRandGen;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.builder.EqualsBuilder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilteredRecombinator<I extends IIndividual>
extends DecoratedRecombinator<I> {
    private static final long serialVersionUID = 9168537902966940372L;
    protected double recProb;
    protected IRandGen randgen;
    protected transient List<I> fertile = new ArrayList<I>();
    protected transient List<I> sterile = new ArrayList<I>();

    public FilteredRecombinator() {
    }

    public FilteredRecombinator(ISystem<I> context) {
        this.contextualize(context);
    }

    public final double getRecProb() {
        return this.recProb;
    }

    public final void setRecProb(double recProb) {
        this.recProb = recProb;
    }

    @Override
    public void contextualize(ISystem<I> context) {
        super.contextualize(context);
        this.randgen = context.createRandGen();
    }

    @Override
    public List<I> recombine(List<I> parents) {
        this.fertile.clear();
        this.sterile.clear();
        for (IIndividual ind : parents) {
            if (this.randgen.coin(this.recProb)) {
                this.fertile.add(ind);
                continue;
            }
            this.sterile.add(ind);
        }
        int rest = this.fertile.size() % this.decorated.getPpl();
        if (rest != 0) {
            int i = 0;
            int j = this.fertile.size() - 1;
            while (i < rest) {
                this.sterile.add((IIndividual)this.fertile.remove(j));
                ++i;
                --j;
            }
        }
        return this.decorated.recombine(this.fertile);
    }

    public List<I> getSterile() {
        return this.sterile;
    }

    public List<I> getFertile() {
        return this.fertile;
    }

    @Override
    public void configure(Configuration settings) {
        super.configure(settings);
        double recProb = settings.getDouble("recombination-prob", 0.5);
        this.setRecProb(recProb);
    }

    public boolean equals(Object other) {
        if (other instanceof FilteredRecombinator) {
            FilteredRecombinator o = (FilteredRecombinator)other;
            EqualsBuilder eb = new EqualsBuilder();
            eb.append(this.decorated, o.decorated);
            eb.append(this.recProb, o.recProb);
            return eb.isEquals();
        }
        return false;
    }
}

