/*
 * Decompiled with CFR 0.152.
 */
package gov.nih.ncats.ifx.qhts.utils;

import gov.nih.ncats.ifx.qhts.utils.HillConstants;
import gov.nih.ncats.ifx.qhts.utils.Stat;
import gov.nih.ncats.ifx.qhts.utils.Util;
import java.util.ArrayList;
import org.apache.commons.math3.distribution.FDistribution;

public class HillStat {
    public static double LN10 = Math.log(10.0);
    public static double DELTA = 0.1;
    public static boolean debug = false;

    public static void main(String[] args) {
        double f = Stat.calcF(5.0, 5.0, 10.967);
        System.out.println(f);
    }

    public static double calcPValue(double y0min, double ymin, double xmin, double smin, double[] xs, double[] ys, boolean[] flags) {
        boolean[] flags2 = null;
        int no = xs.length;
        if (HillConstants.USE_MASKED_POINT_OPTION.equals("No for All")) {
            flags2 = flags;
            no = 0;
            for (int i = 0; i < flags.length; ++i) {
                if (!flags[i]) continue;
                ++no;
            }
        } else if (HillConstants.USE_MASKED_POINT_OPTION.equals("No for Bell")) {
            int i;
            int k = -1;
            for (i = flags.length - 1; i >= 0; --i) {
                if (!flags[i]) continue;
                k = i;
                break;
            }
            if (k > 0) {
                no = k + 1;
                flags2 = new boolean[flags.length];
                for (i = 0; i <= k; ++i) {
                    flags2[i] = true;
                }
                for (i = k + 1; i < flags.length; ++i) {
                    flags2[i] = false;
                }
            }
        }
        if (no <= 3) {
            return 1.0;
        }
        double bestSS = HillStat.calcHillDeviation(xmin, y0min, ymin, smin, flags2, null, xs, ys);
        double flatSS = HillStat.calcConstantDeviation(flags2, null, xs, ys);
        double ratio = flatSS / (double)(no - 1) / (bestSS / (double)(no - 3));
        double pvalue = Stat.calcF(no - 1, no - 3, ratio);
        return pvalue;
    }

    public static double calcHillDeviation(double x05, double y0, double yinf, double slope, double sym, boolean[] flags, double[] ws, double[] xs, double[] ys) {
        double dev = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            if (flags != null && !flags[i]) continue;
            double y = y0 + (yinf - y0) / Math.pow(1.0 + Math.exp(LN10 * slope * (x05 - xs[i])), sym);
            double delta = y - ys[i];
            if (ws != null) {
                dev += ws[i] * delta * delta;
                continue;
            }
            dev += delta * delta;
        }
        return dev;
    }

    public static double calcPValue(double y0min, double ymin, double xmin, double smin, double sym, double[] xs, double[] ys, boolean[] flags) {
        int no = xs.length;
        if (no <= 3) {
            return 1.0;
        }
        double bestSS = HillStat.calcHillDeviation(xmin, y0min, ymin, smin, sym, flags, null, xs, ys);
        double flatSS = HillStat.calcConstantDeviation(flags, null, xs, ys);
        double ratio = flatSS / (double)(no - 1) / (bestSS / (double)(no - 3));
        double pvalue = Stat.calcF(no - 1, no - 3, ratio);
        return pvalue;
    }

    public static double calcSS(ArrayList list) {
        double ss = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double td = Double.parseDouble((String)list.get(i));
            ss += td * td;
        }
        return ss;
    }

    public static double calcPValueKW(double y0min, double ymin, double xmin, double smin, double[] xs, double[] ys, boolean[] flags) {
        double[] hs = HillStat.calcHillDeviations(xmin, y0min, ymin, smin, flags, null, xs, ys);
        double[] fs = HillStat.calcConstantDeviations(flags, null, xs, ys);
        double[][] xys = new double[][]{xs, ys};
        double p = Stat.kwRankTest(xys);
        return p;
    }

    public static boolean calcPValueMWU(double y0min, double ymin, double xmin, double smin, double[] xs, double[] ys, boolean[] flags) {
        double[] hs = HillStat.calcHillDeviations(xmin, y0min, ymin, smin, flags, null, xs, ys);
        double[] fs = HillStat.calcConstantDeviations(flags, null, xs, ys);
        return Stat.mwuTest(hs, fs);
    }

    public static double[] calcCI(boolean p4Flag, double y0min, double ymin, double xmin, double smin, double p, double[] xs, double[] ys, boolean[] flags) {
        double[] values;
        p4Flag = false;
        double dfp = 3.0;
        if (p4Flag) {
            dfp = 4.0;
        }
        double dfnp = (double)xs.length - dfp;
        double bestSS = HillStat.calcHillDeviation(xmin, y0min, ymin, smin, flags, null, xs, ys);
        if (dfnp <= 0.0) {
            double[] values3 = new double[]{y0min, y0min, ymin, ymin, xmin, xmin, smin, smin, bestSS, -bestSS};
            return values3;
        }
        FDistribution fd = new FDistribution(dfp, dfnp);
        double f = fd.inverseCumulativeProbability(1.0 - p);
        double allowedSS = bestSS * (f * dfp / dfnp + 1.0);
        double y0l = y0min - Math.max(0.5 * y0min, 20.0);
        double y0r = y0min + Math.max(0.5 * y0min, 20.0);
        double y0d = 2.0;
        if (!p4Flag) {
            y0l = y0min;
            y0r = y0min;
        }
        double yl = ymin - Math.max(0.5 * ymin, 20.0);
        double yr = ymin + Math.max(0.5 * ymin, 20.0);
        double yd = 2.0;
        double xl = xmin - 4.0;
        double xr = xmin + 4.0;
        double xd = 0.1;
        double sl = smin - 2.0;
        if (sl < 0.2) {
            sl = 0.2;
        }
        double sr = smin + 2.0;
        double sd = 0.2;
        if (debug) {
            System.out.println(p4Flag + "\t" + bestSS + "\t" + allowedSS);
        }
        if ((values = HillStat.calcCI(bestSS, allowedSS, p4Flag, y0min, ymin, xmin, smin, y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, flags, xs, ys)) == null) {
            double[] values3 = new double[]{y0min, y0min, ymin, ymin, xmin, xmin, smin, smin, bestSS, allowedSS};
            return values3;
        }
        if (debug) {
            String info = Util.formatDouble(y0min, 2, 2) + "\t";
            info = info + Util.formatDouble(values[0], 2, 2) + "\t";
            info = info + Util.formatDouble(values[1], 2, 2) + "\t";
            info = info + Util.formatDouble(ymin, 2, 2) + "\t";
            info = info + Util.formatDouble(values[2], 2, 2) + "\t";
            info = info + Util.formatDouble(values[3], 2, 2) + "\t";
            info = info + Util.formatDouble(xmin, 2, 2) + "\t";
            info = info + Util.formatDouble(values[4], 2, 2) + "\t";
            info = info + Util.formatDouble(values[5], 2, 2) + "\t";
            info = info + Util.formatDouble(smin, 2, 2) + "\t";
            info = info + Util.formatDouble(values[6], 2, 2) + "\t";
            info = info + Util.formatDouble(values[7], 2, 2);
            System.out.println(info);
        }
        return values;
    }

    public static double[] calcCI(double bestSS, double allowedSS, boolean p4Flag, double y0min, double ymin, double xmin, double smin, double y0l, double y0r, double y0d, double yl, double yr, double yd, double xl, double xr, double xd, double sl, double sr, double sd, boolean[] flags, double[] xs, double[] ys) {
        double y0_left = 0.0;
        double yinf_left = 0.0;
        double slope_left = 0.0;
        double x05_left = 0.0;
        double y0_right = 0.0;
        double yinf_right = 0.0;
        double slope_right = 0.0;
        double x05_right = 0.0;
        boolean flag = false;
        double maxSS = 0.0;
        for (double yinf = yl; yinf <= yr; yinf += yd) {
            for (double x05 = xl; x05 <= xr; x05 += xd) {
                block2: for (double slope = sl; slope <= sr; slope += sd) {
                    for (double y0 = y0l; y0 <= y0r; y0 += y0d) {
                        double dev = HillStat.calcHillDeviation(x05, y0, yinf, slope, flags, null, xs, ys);
                        if (dev > maxSS) {
                            maxSS = dev;
                        }
                        if (!(Math.abs(dev - allowedSS) < DELTA * allowedSS)) continue;
                        flag = true;
                        if (y0 > y0min && y0 - y0min > y0_right) {
                            y0_right = y0 - y0min;
                        }
                        if (y0 < y0min && y0min - y0 > y0_left) {
                            y0_left = y0min - y0;
                        }
                        if (yinf > ymin && yinf - ymin > yinf_right) {
                            yinf_right = yinf - ymin;
                        }
                        if (yinf < ymin && ymin - yinf > yinf_left) {
                            yinf_left = ymin - yinf;
                        }
                        if (x05 > xmin && x05 - xmin > x05_right) {
                            x05_right = x05 - xmin;
                        }
                        if (x05 < xmin && xmin - x05 > x05_left) {
                            x05_left = xmin - x05;
                        }
                        if (slope > smin && slope - smin > slope_right) {
                            slope_right = slope - smin;
                        }
                        if (!(slope < smin) || !(smin - slope > slope_left)) continue;
                        slope_left = smin - slope;
                        if (p4Flag) continue;
                        continue block2;
                    }
                }
            }
        }
        if (debug) {
            System.out.println(maxSS);
        }
        if (!flag) {
            return null;
        }
        double[] values = new double[]{y0min - y0_left, y0min + y0_right, ymin - yinf_left, ymin + yinf_right, xmin - x05_left, xmin + x05_right, smin - slope_left, smin + slope_right, bestSS, allowedSS};
        return values;
    }

    public static double calcHillDeviation(double x05, double y0, double yinf, double slope, boolean[] flags, double[] ws, double[] xs, double[] ys) {
        double dev = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            if (flags != null && !flags[i]) continue;
            double y = y0 + (yinf - y0) / (1.0 + Math.exp(LN10 * slope * (x05 - xs[i])));
            double delta = y - ys[i];
            if (ws != null) {
                dev += ws[i] * delta * delta;
                continue;
            }
            dev += delta * delta;
        }
        return dev;
    }

    public static double[] calcHillDeviations(double x05, double y0, double yinf, double slope, boolean[] flags, double[] ws, double[] xs, double[] ys) {
        double[] ds = new double[xs.length];
        for (int i = 0; i < xs.length; ++i) {
            if (flags != null && !flags[i]) continue;
            double y = y0 + (yinf - y0) / (1.0 + Math.exp(LN10 * slope * (x05 - xs[i])));
            double delta = y - ys[i];
            ds[i] = Math.abs(delta);
        }
        return ds;
    }

    public static double[] calcCI1(boolean p4Flag, double y0min, double ymin, double xmin, double smin, double p, double[] xs, double[] ys) {
        boolean noFlag;
        double[] values;
        double sd;
        double sr;
        double sl;
        double xd;
        double xr;
        double xl;
        double yd;
        double yr;
        double yl;
        double y0d;
        double y0r;
        double y0l;
        double allowedSS;
        double bestSS;
        block8: {
            double coef2;
            p4Flag = false;
            double dfp = 3.0;
            if (p4Flag) {
                dfp = 4.0;
            }
            double dfnp = (double)xs.length - dfp;
            FDistribution fd = new FDistribution(dfp, dfnp);
            double f = fd.inverseCumulativeProbability(1.0 - p);
            bestSS = HillStat.calcHillDeviation(xmin, y0min, ymin, smin, null, null, xs, ys);
            allowedSS = bestSS * (f * dfp / dfnp + 1.0);
            y0l = y0min - 20.0;
            if (y0l < 0.0) {
                y0l = 0.0;
            }
            y0r = y0min + 20.0;
            y0d = 5.0;
            if (!p4Flag) {
                y0l = y0min;
                y0r = y0min;
            }
            if ((yl = ymin - 20.0) < 0.0) {
                yl = 0.0;
            }
            yr = ymin + 20.0;
            yd = 5.0;
            xl = xmin - 2.0;
            xr = xmin + 2.0;
            xd = 0.5;
            sl = smin - 2.0;
            if (sl < 0.1) {
                sl = 0.1;
            }
            sr = smin + 2.0;
            sd = 0.5;
            double coef = 1.0;
            values = null;
            System.out.println(p4Flag + "\t" + bestSS + "\t" + allowedSS);
            noFlag = false;
            while ((values = HillStat.calcCI(bestSS, allowedSS, p4Flag, y0min, ymin, xmin, smin, (coef2 = 1.0 + coef * 0.1) * y0l, coef2 * y0r, y0d / coef, coef2 * yl, coef2 * yr, yd / coef, coef2 * xl, coef2 * xr, xd / coef, sl, sr, sd, null, xs, ys)) == null) {
                System.out.println(coef += 1.0);
                if (!(coef > 10.0)) continue;
                noFlag = true;
                break block8;
            }
            String info = Util.formatDouble(y0min, 2, 2) + "\t";
            info = info + Util.formatDouble(values[0], 2, 2) + "\t";
            info = info + Util.formatDouble(values[1], 2, 2) + "\t";
            info = info + Util.formatDouble(ymin, 2, 2) + "\t";
            info = info + Util.formatDouble(values[2], 2, 2) + "\t";
            info = info + Util.formatDouble(values[3], 2, 2) + "\t";
            info = info + Util.formatDouble(xmin, 2, 2) + "\t";
            info = info + Util.formatDouble(values[4], 2, 2) + "\t";
            info = info + Util.formatDouble(values[5], 2, 2) + "\t";
            info = info + Util.formatDouble(smin, 2, 2) + "\t";
            info = info + Util.formatDouble(values[6], 2, 2) + "\t";
            info = info + Util.formatDouble(values[7], 2, 2);
            System.out.println(info);
        }
        if (noFlag) {
            double[] values3 = new double[]{y0min, y0min, ymin, ymin, xmin, xmin, smin, smin, 0.0, 0.0};
            return values3;
        }
        y0l = values[0];
        y0r = values[1];
        y0d = 0.5;
        yl = values[2];
        yr = values[3];
        yd = 0.5;
        xl = values[4];
        xr = values[5];
        xd = 0.05;
        sl = values[6];
        sr = values[7];
        sd = 0.1;
        double[] values2 = HillStat.calcCI(bestSS, allowedSS, p4Flag, y0min, ymin, xmin, smin, y0l, y0r, y0d, yl, yr, yd, xl, xr, xd, sl, sr, sd, null, xs, ys);
        if (values2 != null) {
            values = values2;
        }
        String info = Util.formatDouble(y0min, 2, 2) + "\t";
        info = info + Util.formatDouble(values[0], 2, 2) + "\t";
        info = info + Util.formatDouble(values[1], 2, 2) + "\t";
        info = info + Util.formatDouble(ymin, 2, 2) + "\t";
        info = info + Util.formatDouble(values[2], 2, 2) + "\t";
        info = info + Util.formatDouble(values[3], 2, 2) + "\t";
        info = info + Util.formatDouble(xmin, 2, 2) + "\t";
        info = info + Util.formatDouble(values[4], 2, 2) + "\t";
        info = info + Util.formatDouble(values[5], 2, 2) + "\t";
        info = info + Util.formatDouble(smin, 2, 2) + "\t";
        info = info + Util.formatDouble(values[6], 2, 2) + "\t";
        info = info + Util.formatDouble(values[7], 2, 2);
        System.out.println(info);
        return values;
    }

    public static double calcConstantDeviation(boolean[] flags, double[] ws, double[] xs, double[] ys) {
        double mean = 0.0;
        int no = 0;
        for (int i = 0; i < xs.length; ++i) {
            if (flags != null && !flags[i]) continue;
            mean += ys[i];
            ++no;
        }
        mean /= (double)no;
        double dev = 0.0;
        for (int i = 0; i < xs.length; ++i) {
            if (flags != null && !flags[i]) continue;
            double delta = ys[i] - mean;
            if (ws != null) {
                dev += ws[i] * delta * delta;
                continue;
            }
            dev += delta * delta;
        }
        return dev;
    }

    public static double[] calcConstantDeviations(boolean[] flags, double[] ws, double[] xs, double[] ys) {
        double mean = 0.0;
        int no = 0;
        for (int i = 0; i < xs.length; ++i) {
            if (flags != null && !flags[i]) continue;
            mean += ys[i];
            ++no;
        }
        mean /= (double)no;
        double[] ds = new double[xs.length];
        for (int i = 0; i < xs.length; ++i) {
            if (flags != null && !flags[i]) continue;
            double delta = ys[i] - mean;
            ds[i] = Math.abs(delta);
        }
        return ds;
    }
}

