## ----setup_ops, include = FALSE-----------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>",
  fig.path = "figures/plots-",
  fig.width = 7,
  fig.height = 5,
  dpi = 150,
  message = FALSE,
  warning = FALSE
)

LOCAL <- identical(Sys.getenv("LOCAL"), "TRUE")
set.seed(2025)

## ----setup--------------------------------------------------------------------
library(bigPLSR)
set.seed(101)

## ----data---------------------------------------------------------------------
n <- 80; p <- 6
X <- matrix(rnorm(n * p), n, p)
Y <- scale(X[, 1:2] %*% matrix(c(0.7, -0.4, 0.5, 0.8), 2, 2) + rnorm(n * 2, sd = 0.15))

groups <- factor(rep(LETTERS[1:4], length.out = n))
fit <- pls_fit(X, Y, ncomp = 3, scores = "r")

## ----scores-ellipse, eval=LOCAL, cache=TRUE-----------------------------------
plot_pls_individuals(fit, comps = c(1, 2), groups = groups,
                     ellipse = TRUE, ellipse_level = 0.90, 
                     main="Component scores with 90% ellipses")

## ----variables, eval=LOCAL, cache=TRUE----------------------------------------
plot_pls_variables(fit, comps = c(1, 2), main="Variable plot")

## ----biplot, eval=LOCAL, cache=TRUE-------------------------------------------
plot_pls_biplot(fit, comps = c(1, 2), groups = groups,
                ellipse = TRUE, ellipse_level = 0.90, 
                main="Biplot with grouped individuals")

## ----bootstrap, eval=LOCAL, cache=TRUE----------------------------------------
boot <- pls_bootstrap(X, Y, ncomp = 2, R = 30, type = "xy",
                      parallel = "none", seed = 99)
summary_boot <- summarise_pls_bootstrap(boot)
summary_boot

## ----bootstrap-coef, eval=LOCAL, cache=TRUE-----------------------------------
plot_pls_bootstrap_coefficients(boot, main="Bootstrap coefficient intervals")

## ----bootstrap-scores, eval=LOCAL, cache=TRUE---------------------------------
boot <- pls_bootstrap(X, Y, ncomp = 2, R = 30, type = "xy", 
                      parallel = "none", seed = 99, return_scores = TRUE)
plot_pls_bootstrap_scores(boot,main="Bootstrap score dispersion")

