/*
 * Decompiled with CFR 0.152.
 */
package org.corehunter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.corehunter.CoreHunterMeasure;
import org.corehunter.CoreHunterObjective;
import org.corehunter.CoreHunterObjectiveType;
import org.corehunter.data.CoreHunterData;

public class CoreHunterArguments {
    private final int subsetSize;
    private final CoreHunterData data;
    private final List<CoreHunterObjective> objectives;
    private final boolean normalize;
    private final Set<Integer> alwaysSelected;
    private final Set<Integer> neverSelected;

    public CoreHunterArguments(CoreHunterData data, int subsetSize, CoreHunterObjectiveType objective) {
        this(data, subsetSize, objective, null);
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, CoreHunterObjectiveType objective, CoreHunterMeasure measure) {
        this(data, subsetSize, Collections.singletonList(new CoreHunterObjective(objective, measure)));
        if (objective == null) {
            throw new IllegalArgumentException("Objective not defined.");
        }
        if (measure == null) {
            throw new IllegalArgumentException("Measure not defined.");
        }
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, List<CoreHunterObjective> objectives) {
        this(data, subsetSize, objectives, Collections.emptySet());
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, List<CoreHunterObjective> objectives, Set<Integer> alwaysSelected) {
        this(data, subsetSize, objectives, alwaysSelected, Collections.emptySet());
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, List<CoreHunterObjective> objectives, Set<Integer> alwaysSelected, Set<Integer> neverSelected) {
        this(data, subsetSize, objectives, alwaysSelected, neverSelected, true);
    }

    public CoreHunterArguments(CoreHunterData data, int subsetSize, List<CoreHunterObjective> objectives, Set<Integer> alwaysSelected, Set<Integer> neverSelected, boolean normalize) {
        block12: {
            block11: {
                if (data == null) {
                    throw new IllegalArgumentException("Data undefined.");
                }
                if (subsetSize < 2) {
                    throw new IllegalArgumentException("Requested subset size must at least be 2 or more.");
                }
                if (subsetSize >= data.getSize()) {
                    throw new IllegalArgumentException(String.format("Requested subset size must be less than total data size %d.", data.getSize()));
                }
                this.data = data;
                this.subsetSize = subsetSize;
                if (objectives == null || objectives.isEmpty()) {
                    throw new IllegalArgumentException("Objectives not defined.");
                }
                this.objectives = Collections.unmodifiableList(new ArrayList<CoreHunterObjective>(objectives));
                if (alwaysSelected == null) {
                    throw new IllegalArgumentException("Set of always selected IDs can not be null.");
                }
                if (neverSelected == null) {
                    throw new IllegalArgumentException("Set of never selected IDs can not be null.");
                }
                if (alwaysSelected.stream().anyMatch(neverSelected::contains)) break block11;
                if (!neverSelected.stream().anyMatch(alwaysSelected::contains)) break block12;
            }
            throw new IllegalArgumentException("Sets of always and never selected IDs should be disjoint.");
        }
        if (alwaysSelected.size() > subsetSize) {
            throw new IllegalArgumentException("Set of always selected IDs can not be larger than subset size.");
        }
        if (data.getSize() - neverSelected.size() < subsetSize) {
            throw new IllegalArgumentException("Too many never selected IDs: can not obtain requested subset size.");
        }
        this.alwaysSelected = Collections.unmodifiableSet(new HashSet<Integer>(alwaysSelected));
        this.neverSelected = Collections.unmodifiableSet(new HashSet<Integer>(neverSelected));
        this.normalize = objectives.size() > 1 && normalize;
    }

    public final CoreHunterData getData() {
        return this.data;
    }

    public final List<CoreHunterObjective> getObjectives() {
        return this.objectives;
    }

    public final int getSubsetSize() {
        return this.subsetSize;
    }

    public final Set getAlwaysSelected() {
        return this.alwaysSelected;
    }

    public final Set getNeverSelected() {
        return this.neverSelected;
    }

    public final boolean isNormalized() {
        return this.normalize;
    }
}

