% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.info.function.R
\name{distance.info}
\alias{distance.info}
\title{Pairwise distances of spatial coordinates}
\usage{
distance.info(data)
}
\arguments{
\item{data}{data A data frame or matrix containing
the x-coordinates in meters in the first column,
the y-coordinates in meters in the second column,
and the values of the attribute of interest in the third column.
Additional columns are ignored.}
}
\value{
A list containing:

\item{distmatrix}{A matrix containing the pairwise Euclidean distances between
      all given locations.}
\item{distset}{A vector containing the pairwise Euclidean distances.
      The elements equal the upper (or lower) triangle minus the diagonal
      of the distance matrix. If the input dataset has n rows, \code{distset} contains \eqn{n(n-1)/2} distances.}
\item{distsummary}{A summary containing the minimum, 1st quartile, median, mean,
      3rd quartile and maximum of the \code{distset}.}
\item{maxdist}{The maximal distance.}

Moreover, the function prints a histogram of the pairwise distances saved in the list entry \code{distset}.
}
\description{
A range of descriptive statistics on the distribution of the pairwise distances between observations.
}
\examples{
## Example 1
x = c(1,3,7,10,15)
y = c(5,19,8,3,11)
z = rnorm(5, mean = 20, sd = 40)
dataset = as.data.frame(cbind(x,y,z))
distance.info(data = dataset)

## Example 2
distance.info(birth)


}
