% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EigenR.R
\name{Eigen_UtDU}
\alias{Eigen_UtDU}
\title{'UtDU' decomposition of a matrix}
\usage{
Eigen_UtDU(M)
}
\arguments{
\item{M}{a square symmetric/Hermitian positive or negative semidefinite 
matrix, real/complex}
}
\value{
The Cholesky-'UtDU' decomposition of \code{M} in a list 
  (see example).
}
\description{
Cholesky-'UtDU' decomposition of a symmetric or Hermitian matrix.
}
\details{
Symmetry is not checked; only the lower triangular part of 
  \code{M} is used.
}
\examples{
x <- matrix(c(1:5, (1:5)^2), 5, 2)
x <- cbind(x, x[, 1] + 3*x[, 2])
M <- crossprod(x)
UtDU <- Eigen_UtDU(M)
U <- UtDU$U
D <- UtDU$D
perm <- UtDU$perm
UP <- U[, perm]
t(UP) \%*\% diag(D) \%*\% UP # this is `M`
}
