% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gcurve.r
\name{gcurve}
\alias{gcurve}
\title{gcurve}
\usage{
gcurve(
  expr,
  from = NULL,
  to = NULL,
  n = 101,
  add = FALSE,
  type = "l",
  xname = "x",
  xlab = xname,
  ylab = NULL,
  log = NULL,
  xlim = NULL,
  category = NULL,
  ...
)
}
\arguments{
\item{expr}{expression to be plotted}

\item{from}{lower bound of x-values}

\item{to}{upper bound of x-values}

\item{n}{number of points to plot}

\item{add}{logical; if TRUE add to an already existing plot; if NA start a new plot taking the defaults for the limits and log-scaling of the x-axis from the previous plot. Taken as FALSE (with a warning if a different value is supplied) if no graphics device is open.}

\item{type}{plot type: see plot.default.}

\item{xname}{character string giving the name to be used for the x axis}

\item{xlab}{labels and graphical parameters can also be specified as arguments.}

\item{ylab}{For the "function" method of plot, ... can include any of the other arguments of curve, except expr}

\item{log}{For the "function" method of plot, ... can include any of the other arguments of curve, except expr}

\item{xlim}{NULL or a numeric vector of length 2; if non-NULL it provides the defaults for c(from, to) and, unless add = TRUE, selects the x-limits of the plot – see plot.window.}

\item{category}{optional text column appends to data.frame returned}

\item{...}{additional items passed to curve}
}
\value{
A data.frame is returned with x and y-values and an optional column called category
}
\description{
Returns a data.frame associated with a call to base::curve.
}
\examples{
my.gcurve <- gcurve(expr = dnorm(x, mean=0, sd=1),from=-4, to = 4, n= 1001,
category= "Standard Normal")
head(my.gcurve)
}
