% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotDataSetList.R
\name{Plot.Parameters}
\alias{Plot.Parameters}
\alias{Plot.Parameters.DataSetList}
\title{Plot the parameter values recorded in a DataSetList}
\usage{
Plot.Parameters(dsList, f_min = NULL, f_max = NULL, algids = "all",
  scale.xlog = F, scale.ylog = F, show.mean = T, show.median = F)

\method{Plot.Parameters}{DataSetList}(dsList, f_min = NULL,
  f_max = NULL, algids = "all", scale.xlog = F, scale.ylog = F,
  show.mean = T, show.median = F)
}
\arguments{
\item{dsList}{A DataSetList (should consist of only one function and dimension).}

\item{f_min}{The starting function value.}

\item{f_max}{The final function value.}

\item{algids}{Which algorithms from dsList to use}

\item{scale.xlog}{Whether or not to scale the x-axis logaritmically}

\item{scale.ylog}{Whether or not to scale the y-axis logaritmically}

\item{show.mean}{Whether or not to show the mean parameter values}

\item{show.median}{Whether or not to show the median parameter values}
}
\value{
A plot of for every recorded parameter in the DataSetList
}
\description{
Plot the parameter values recorded in a DataSetList
}
\examples{
Plot.Parameters(subset(dsl, funcId == 1))
}
