% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stats.R
\name{seq_FV}
\alias{seq_FV}
\title{Function for generating sequences of function values}
\usage{
seq_FV(
  FV,
  from = NULL,
  to = NULL,
  by = NULL,
  length.out = NULL,
  scale = NULL,
  force_limits = FALSE
)
}
\arguments{
\item{FV}{A list of function values}

\item{from}{Starting function value. Will be replaced by min(FV) if it is NULL or too small}

\item{to}{Stopping function value. Will be replaced by max(FV) if it is NULL or too large}

\item{by}{Stepsize of the sequence. Will be replaced if it is too small}

\item{length.out}{Number of values in the sequence.
'by' takes preference if both it and length.out are provided.}

\item{scale}{Scaling of the sequence. Can be either 'linear' or 'log', indicating a
linear or log-linear spacing respectively. If NULL, the scale will be predicted
based on FV}

\item{force_limits}{Whether the from and to values are hard, or should be modified
based on detected FV values (default False)}
}
\value{
A sequence of function values
}
\description{
Function for generating sequences of function values
}
\examples{
FVall <- get_runtimes(dsl)
seq_FV(FVall, 10, 16, 1, scale='linear')
}
