% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_data.R
\name{import_actigraph_csv_chunked}
\alias{import_actigraph_csv_chunked}
\title{Import large raw multi-channel accelerometer data stored in Actigraph raw csv
format in chunks}
\usage{
import_actigraph_csv_chunked(
  filepath,
  in_voltage = FALSE,
  has_ts = TRUE,
  header = TRUE,
  chunk_samples = 180000
)
}
\arguments{
\item{filepath}{string. The filepath of the input data.}

\item{in_voltage}{set as TRUE only when the input Actigraph csv file is in
analog quantized format and need to be converted into g value}

\item{has_ts}{set as TRUE only when timestamp is provided as the first column}

\item{header}{boolean. If TRUE, the input csv file will have column names in
the first row.}

\item{chunk_samples}{number. The number of samples in each chunk. Default is
180000.}
}
\value{
list. The list contains two items. The first item is a generator
  function that each time it is called, it will return a data.frame of the
  imported chunk. The second item is a \code{close} function which you can
  call at any moment to close the file loading.
}
\description{
\code{import_actigraph_csv_chunked} imports the raw multi-channel accelerometer data
stored in Actigraph raw csv format. It supports files from the following
devices: GT3X, GT3X+, GT3X+BT, GT9X, and GT9X-IMU.
}
\details{
For old device (GT3X) that stores accelerometer values as digital voltage.
The function will convert the values to \eqn{g} unit using the following
equation.

\deqn{x_g = \frac{x_{voltage}r}{(2 ^ r) - \frac{v}{2}}}

Where \eqn{v} is the max voltage corresponding to the max accelerometer value
that can be found in the meta section in the csv file; \eqn{r} is the
resolution level which is the number of bits used to store the voltage
values. \eqn{r} can also be found in the meta section in the csv file.
}
\section{How is it used in MIMS-unit algorithm?}{
 This function is a File IO
  function that is used to import data from Actigraph devices during
  algorithm validation.
}

\examples{
  default_ops = options()
  options(digits.secs=3)

  # Use the actigraph csv file shipped with the package
  filepath = system.file('extdata', 'actigraph.csv', package='MIMSunit')

  # Check original file format
  readLines(filepath)[1:15]

  # Example 1: Load chunks every 2000 samples
  results = import_actigraph_csv_chunked(filepath, has_ts=FALSE, chunk_samples=2000)
  next_chunk = results[[1]]
  close_connection = results[[2]]
  # Check data as chunks, you can see chunks are shifted at each iteration.
  n = 1
  repeat {
    df = next_chunk()
    if (nrow(df) > 0) {
      print(paste('chunk', n))
      print(paste("df:", df[1, 1], '-', df[nrow(df),1]))
      n = n + 1
    }
    else {
      break
    }
  }

  # Close connection after reading all the data
  close_connection()

  # Example 2: Close loading early
  results = import_actigraph_csv_chunked(filepath, has_ts=FALSE, chunk_samples=2000)
  next_chunk = results[[1]]
  close_connection = results[[2]]
  # Check data as chunks, you can see chunk time is shifting forward at each iteration.
  n = 1
  repeat {
    df = next_chunk()
    if (nrow(df) > 0) {
      print(paste('chunk', n))
      print(paste("df:", df[1, 1], '-', df[nrow(df),1]))
      n = n + 1
      close_connection()
    }
    else {
      break
    }
  }

  # Restore default options
  options(default_ops)
}
\seealso{
Other File I/O functions: 
\code{\link{export_to_actilife}()},
\code{\link{import_actigraph_count_csv}()},
\code{\link{import_actigraph_csv}()},
\code{\link{import_actigraph_meta}()},
\code{\link{import_activpal3_csv}()},
\code{\link{import_enmo_csv}()},
\code{\link{import_mhealth_csv_chunked}()},
\code{\link{import_mhealth_csv}()}
}
\concept{File I/O functions}
