% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFO.R
\name{DFO_quant}
\alias{DFO_quant}
\title{Department of Fisheries and Oceans biomass quantile plot}
\usage{
DFO_quant(
  MSEobj,
  maxcol = 6,
  qcol = rgb(0.4, 0.8, 0.95),
  lcol = "dodgerblue4",
  curyr = 2018,
  quants = c(0.05, 0.25, 0.75, 0.95),
  addline = T,
  forreport = T
)
}
\arguments{
\item{MSEobj}{An MSE object of class MSE produced by DLMtool function runMSE}

\item{maxcol}{Integer how many columns for panel plots?}

\item{qcol}{A color, the quantile coloration}

\item{lcol}{A color, the mean B/BMSY line}

\item{curyr}{The current calendar year}

\item{quants}{A vector 2 long for the quantiles e.g. 0.1 and 0.9 for the 10th and 90th quantiles}

\item{addline}{Should two individual example simulations be added to the plot?}

\item{forreport}{Logical. Is it for a report? If true, one plot of six MPs in a row will be provided one after another.}
}
\description{
A plot of biomass relative to BMSY quantiles over projected years
}
\author{
T. Carruthers
}
