% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Data_Functions.R
\name{Report}
\alias{Report}
\title{Generate a Data Report}
\usage{
Report(
  Data = NULL,
  md = NULL,
  name = "Data-Report",
  title = "Data Documentation",
  author = "Author Name",
  date = Sys.Date(),
  output_format = c("html_document", "pdf_document"),
  open = TRUE,
  quiet = TRUE,
  dir = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{Data}{Either an object of class \code{Data} or the file path to a valid
file to be imported with \code{XL2Data}}

\item{md}{Full file path to a valid text file documenting the Data}

\item{name}{Optional. Name of the output file}

\item{title}{Title for the Report. Title in the markdown file will override this value}

\item{author}{Author of the Report. Author in the markdown file will override this value}

\item{date}{Date of the Report. Date in the markdown file will override this value}

\item{output_format}{Output file format: \code{html_document} or \code{pdf_document}}

\item{open}{Logical. Open the compiled report?}

\item{quiet}{Logical.An option to suppress printing of the pandoc command line.}

\item{dir}{Optional. Directory to save the file. Defaults to \code{getwd()}}

\item{overwrite}{Logical. Overwrite an existing file with the same name?}
}
\value{
Nothing. A Data Report is generated and saved in \code{dir}
}
\description{
A HTML Data Report is generated and opened in a web browser
}
\examples{
\dontrun{
DataInit('Example') # generate example Data Input and Documentation files
Report('Example', 'Example.md')
}
}
\author{
A. Hordyk
}
