% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/OM_Plotting.R
\name{plot.pars}
\alias{plot.pars}
\alias{plot.Stock}
\alias{plot.Fleet}
\alias{plot.Obs}
\alias{plot.Imp}
\alias{plot.Hist}
\alias{plot.OM}
\title{Plot Operating Model Object}
\usage{
\method{plot}{pars}(
  x,
  Object,
  Stock = NULL,
  nsamp = 3,
  nsim = 200,
  nyears = 50,
  proyears = 28,
  output_file = NULL,
  output_dir = getwd(),
  quiet = TRUE,
  tabs = TRUE,
  title = NULL,
  date = NULL,
  plotPars = NULL,
  html = FALSE,
  open = TRUE,
  dev = FALSE,
  ...
)

\method{plot}{Stock}(
  x,
  nsamp = 3,
  nsim = 200,
  nyears = 50,
  proyears = 28,
  output_file = NULL,
  output_dir = getwd(),
  quiet = TRUE,
  tabs = TRUE,
  title = NULL,
  date = NULL,
  plotPars = NULL,
  open = TRUE,
  dev = FALSE,
  ...
)

\method{plot}{Fleet}(
  x,
  Stock = NULL,
  nsamp = 3,
  nsim = 200,
  nyears = 50,
  proyears = 28,
  output_file = NULL,
  output_dir = getwd(),
  quiet = TRUE,
  tabs = TRUE,
  title = NULL,
  date = NULL,
  plotPars = NULL,
  open = TRUE,
  dev = FALSE,
  ...
)

\method{plot}{Obs}(
  x,
  nsamp = 3,
  nsim = 200,
  nyears = 50,
  proyears = 28,
  output_file = NULL,
  output_dir = getwd(),
  quiet = TRUE,
  tabs = TRUE,
  title = NULL,
  date = NULL,
  plotPars = NULL,
  open = TRUE,
  dev = FALSE,
  ...
)

\method{plot}{Imp}(
  x,
  nsamp = 3,
  nsim = 200,
  nyears = 50,
  proyears = 28,
  output_file = NULL,
  output_dir = getwd(),
  quiet = TRUE,
  tabs = TRUE,
  title = NULL,
  date = NULL,
  plotPars = NULL,
  open = TRUE,
  dev = FALSE,
  ...
)

\method{plot}{Hist}(
  x,
  nsamp = 3,
  nsim = 200,
  nyears = 50,
  proyears = 28,
  output_file = NULL,
  output_dir = getwd(),
  quiet = TRUE,
  tabs = TRUE,
  title = NULL,
  date = NULL,
  plotPars = NULL,
  open = TRUE,
  dev = FALSE,
  ...
)

\method{plot}{OM}(
  x,
  nsamp = 3,
  nsim = 200,
  nyears = 50,
  proyears = 28,
  output_file = NULL,
  output_dir = getwd(),
  quiet = TRUE,
  tabs = TRUE,
  title = NULL,
  date = NULL,
  plotPars = NULL,
  open = TRUE,
  dev = FALSE,
  ...
)
}
\arguments{
\item{x}{An object of class \code{Stock}, \code{Fleet}, \code{Obs}, \code{Imp}, \code{Hist}, or \code{OM}, OR one
of the following character strings for \code{Object} of class \code{Stock}: "M", "Growth", "Maturity", "Recruitment", "Spatial",
or "Depletion" and for \code{Object} of class \code{Fleet}: "Effort", "Catchability", "MPA",
and "Selectivity".}

\item{Object}{An object of class \code{Stock} or \code{Fleet}}

\item{Stock}{An object of class \code{Stock} required for \code{Fleet} parameters}

\item{nsamp}{The number of random samples to show in the plot}

\item{nsim}{The number of simulations (only used for objects not of class \code{OM})}

\item{nyears}{The number of historical years (only used for objects not of class \code{OM})}

\item{proyears}{The number of projection years (only used for objects not of class \code{OM})}

\item{output_file}{Name of the output html file (without file extension)}

\item{output_dir}{Output directory. Defaults to \code{getwd()}}

\item{quiet}{An option to suppress printing of the pandoc command line}

\item{tabs}{Include tabs in the HTML file?}

\item{title}{Optional title for the markdown report}

\item{date}{Optional date for the markdown report}

\item{plotPars}{A named list with options for plots:
\itemize{
\item breaks - numeric. Number of breaks in histograms.
\item col - character. Color of histograms.
\item axes - logical. Include axes in histogram?
\item cex.main - numeric. Size of main title in plots.
\item lwd - numeric. Line width for time-series plots.
}}

\item{html}{Logical. Compile to a HTML report (TRUE) or print plots in R console (FALSE)}

\item{open}{Logical. Open the html file?}

\item{dev}{Logical. For development use only.}

\item{...}{Not used}
}
\description{
Generate HTML reports with plots of operating model components ("Stock",
"Fleet", "Obs", and "Imp"), the historical simulations ("Hist"), or the complete OM ("OM").

The individual component plots of objects of class \code{Stock} and \code{Fleet} can also be generated by
using the generic \code{plot.pars} function. See Examples below.
}
\examples{
\dontrun{
# Plot Stock Object:
Stock <- MSEtool::Albacore
plot(Stock)

# Individual plots:
plot("M", Stock)
plot("Growth", Stock)
plot("Maturity", Stock)
plot("Recruitment", Stock)
plot("Spatial", Stock)
plot("Depletion", Stock)

# Plot Fleet Object
Fleet <- MSEtool::Generic_DecE
plot(Fleet, Stock)

# Individual plots:
plot("Effort", Fleet, Stock)
plot("Catchability", Fleet, Stock)
plot("MPA", Fleet, Stock)
plot("Selectivity", Fleet, Stock)


# Plot Obs Object
Obs <- MSEtool::Imprecise_Unbiased
plot(Obs)

# Plot Imp Object
Imp <- MSEtool::Overages
plot(Imp)


# Plot Hist Object
OM <- MSEtool::testOM
Hist <- Simulate(OM)
plot(Hist)

# Plot OM Object
plot(OM)
}
}
