% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkMWRresults.R
\name{checkMWRresults}
\alias{checkMWRresults}
\title{Check water quality monitoring results}
\usage{
checkMWRresults(resdat, warn = TRUE)
}
\arguments{
\item{resdat}{input data frame for results}

\item{warn}{logical to return warnings to the console (default)}
}
\value{
\code{resdat} is returned as is if no errors are found, otherwise an informative error message is returned prompting the user to make the required correction to the raw data before proceeding. Checks with warnings can be fixed at the discretion of the user before proceeding.
}
\description{
Check water quality monitoring results
}
\details{
This function is used internally within \code{\link{readMWRresults}} to run several checks on the input data for completeness and conformance to WQX requirements.

The following checks are made:
\itemize{
\item{Column name spelling: }{Should be the following: Monitoring Location ID, Activity Type, Activity Start Date, Activity Start Time, Activity Depth/Height Measure, Activity Depth/Height Unit, Activity Relative Depth Name, Characteristic Name, Result Value, Result Unit, Quantitation Limit, QC Reference Value, Result Measure Qualifier, Result Attribute.}
\item{Columns present: }{All columns from the previous check should be present, Result Attribute is optional}
\item{Activity Type: }{Should be one of Field Msr/Obs, Sample-Routine, Quality Control Sample-Field Blank, Quality Control Sample-Lab Blank, Quality Control Sample-Lab Duplicate, Quality Control Sample-Lab Spike, Quality Control-Calibration Check, Quality Control-Meter Lab Duplicate, Quality Control-Meter Lab Blank}
\item{Date formats: }{Should be mm/dd/yyyy and parsed correctly on import}
\item{Non-numeric Activity Depth/Height Measure: }{All depth values should be numbers, excluding missing values}
\item{Activity Depth/Height Unit: }{All entries should be \code{ft}, \code{m}, or blank}
\item{Activity Relative Depth Name: }{Should be either Surface, Bottom, Midwater, Near Bottom, or blank (warning only)}
\item{Activity Depth/Height Measure out of range: }{All depth values should be less than or equal to 1 meter / 3.3 feet or entered as Surface in the Activity Relative Depth Name column (warning only)}
\item{Characteristic Name: }{Should match parameter names in the \code{Simple Parameter} or \code{WQX Parameter} columns of the \code{\link{paramsMWR}} data (warning only)}
\item{Result Value: }{Should be a numeric value or a text value as AQL or BDL}
\item{QC Reference Value: }{Should be a numeric value or a text value as AQL or BDL}
\item{Result Unit: }{No missing entries in \code{Result Unit}, except pH which can be blank}
\item{Single Result Unit: }{Each unique parameter in \code{Characteristic Name} should have only one entry in \code{Result Unit} (excludes entries for lab spikes reported as \code{\%} or \code{\% recovery})}
\item{Correct Result Unit: }{Each unique parameter in \code{Characteristic Name} should have an entry in \code{Result Unit} that matches one of the acceptable values in the \code{Units of measure} column of the \code{\link{paramsMWR}} data (excludes entries for lab spikes reported as \code{\%} or \code{\% recovery})}
}
}
\examples{
library(dplyr)

respth <- system.file('extdata/ExampleResults.xlsx', package = 'MassWateR')

resdat <- suppressWarnings(readxl::read_excel(respth, na = c('NA', 'na', ''), guess_max = Inf)) \%>\% 
  dplyr::mutate_if(function(x) !lubridate::is.POSIXct(x), as.character)
             
checkMWRresults(resdat)
}
